// ************************************************************************* //
//  File: SliceGUIPluginInfo.C
// ************************************************************************* //

#include <SlicePluginInfo.h>
#include <SliceAttributes.h>
#include <QvisSliceWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo Slice_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the Slice operator.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Thu Mar 13 13:08:28 PST 2003
//
// ****************************************************************************
extern "C" GUIOperatorPluginInfo* GetGUIInfo()
{
    return new SliceGUIPluginInfo;
}

// ****************************************************************************
//  Method: SliceGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Thu Mar 13 13:08:28 PST 2003
//
// ****************************************************************************

const char *
SliceGUIPluginInfo::GetMenuName() const
{
    return "Slice";
}


// ****************************************************************************
//  Method: SliceGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Thu Mar 13 13:08:28 PST 2003
//
// ****************************************************************************

QvisPostableWindowObserver *
SliceGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisSliceWindow(type, (SliceAttributes *)attr,
        "Slice operator attributes", "Slice operator", notepad);
}

// ****************************************************************************
//  Method: SliceGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Thu Mar 13 13:08:28 PST 2003
//
// ****************************************************************************

#include <Slice.xpm>
const char **
SliceGUIPluginInfo::XPMIconData() const
{
    return Slice_xpm;
}
