#include <SliceAttributes.h>
#include <DataNode.h>
#include <PlaneAttributes.h>

//
// Enum conversion methods for SliceAttributes::AxisType
//

static const char *AxisType_strings[] = {
"XAxis", "YAxis", "ZAxis", 
"Arbitrary"};

std::string
SliceAttributes::AxisType_ToString(SliceAttributes::AxisType t)
{
    int index = int(t);
    if(index < 0 || index >= 4) index = 0;
    return AxisType_strings[index];
}

std::string
SliceAttributes::AxisType_ToString(int t)
{
    int index = (t < 0 || t >= 4) ? 0 : t;
    return AxisType_strings[index];
}

bool
SliceAttributes::AxisType_FromString(const std::string &s, SliceAttributes::AxisType &val)
{
    val = SliceAttributes::XAxis;
    for(int i = 0; i < 4; ++i)
    {
        if(s == AxisType_strings[i])
        {
            val = (AxisType)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for SliceAttributes::OriginType
//

static const char *OriginType_strings[] = {
"Point", "Intercept", "Percent", 
"Zone", "Node"};

std::string
SliceAttributes::OriginType_ToString(SliceAttributes::OriginType t)
{
    int index = int(t);
    if(index < 0 || index >= 5) index = 0;
    return OriginType_strings[index];
}

std::string
SliceAttributes::OriginType_ToString(int t)
{
    int index = (t < 0 || t >= 5) ? 0 : t;
    return OriginType_strings[index];
}

bool
SliceAttributes::OriginType_FromString(const std::string &s, SliceAttributes::OriginType &val)
{
    val = SliceAttributes::Point;
    for(int i = 0; i < 5; ++i)
    {
        if(s == OriginType_strings[i])
        {
            val = (OriginType)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: SliceAttributes::SliceAttributes
//
// Purpose: 
//   Constructor for the SliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jan 25 16:57:05 PST 2005
//
// Modifications:
//   
// ****************************************************************************

SliceAttributes::SliceAttributes() : AttributeSubject("iDddiiDiDbbbiis")
{
    originType = Intercept;
    originPoint[0] = 0;
    originPoint[1] = 0;
    originPoint[2] = 0;
    originIntercept = 0;
    originPercent = 0;
    originZone = 0;
    originNode = 0;
    normal[0] = 0;
    normal[1] = -1;
    normal[2] = 0;
    axisType = YAxis;
    upAxis[0] = 0;
    upAxis[1] = 0;
    upAxis[2] = 1;
    project2d = true;
    interactive = true;
    flip = false;
    originZoneDomain = 0;
    originNodeDomain = 0;
    meshName = "default";
}

// ****************************************************************************
// Method: SliceAttributes::SliceAttributes
//
// Purpose: 
//   Copy constructor for the SliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jan 25 16:57:05 PST 2005
//
// Modifications:
//   
// ****************************************************************************

SliceAttributes::SliceAttributes(const SliceAttributes &obj) : AttributeSubject("iDddiiDiDbbbiis")
{
    originType = obj.originType;
    originPoint[0] = obj.originPoint[0];
    originPoint[1] = obj.originPoint[1];
    originPoint[2] = obj.originPoint[2];

    originIntercept = obj.originIntercept;
    originPercent = obj.originPercent;
    originZone = obj.originZone;
    originNode = obj.originNode;
    normal[0] = obj.normal[0];
    normal[1] = obj.normal[1];
    normal[2] = obj.normal[2];

    axisType = obj.axisType;
    upAxis[0] = obj.upAxis[0];
    upAxis[1] = obj.upAxis[1];
    upAxis[2] = obj.upAxis[2];

    project2d = obj.project2d;
    interactive = obj.interactive;
    flip = obj.flip;
    originZoneDomain = obj.originZoneDomain;
    originNodeDomain = obj.originNodeDomain;
    meshName = obj.meshName;

    SelectAll();
}

// ****************************************************************************
// Method: SliceAttributes::~SliceAttributes
//
// Purpose: 
//   Destructor for the SliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jan 25 16:57:05 PST 2005
//
// Modifications:
//   
// ****************************************************************************

SliceAttributes::~SliceAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: SliceAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the SliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jan 25 16:57:05 PST 2005
//
// Modifications:
//   
// ****************************************************************************

SliceAttributes& 
SliceAttributes::operator = (const SliceAttributes &obj)
{
    if (this == &obj) return *this;
    originType = obj.originType;
    originPoint[0] = obj.originPoint[0];
    originPoint[1] = obj.originPoint[1];
    originPoint[2] = obj.originPoint[2];

    originIntercept = obj.originIntercept;
    originPercent = obj.originPercent;
    originZone = obj.originZone;
    originNode = obj.originNode;
    normal[0] = obj.normal[0];
    normal[1] = obj.normal[1];
    normal[2] = obj.normal[2];

    axisType = obj.axisType;
    upAxis[0] = obj.upAxis[0];
    upAxis[1] = obj.upAxis[1];
    upAxis[2] = obj.upAxis[2];

    project2d = obj.project2d;
    interactive = obj.interactive;
    flip = obj.flip;
    originZoneDomain = obj.originZoneDomain;
    originNodeDomain = obj.originNodeDomain;
    meshName = obj.meshName;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: SliceAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the SliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jan 25 16:57:05 PST 2005
//
// Modifications:
//   
// ****************************************************************************

bool
SliceAttributes::operator == (const SliceAttributes &obj) const
{
    int i;

    // Compare the originPoint arrays.
    bool originPoint_equal = true;
    for(i = 0; i < 3 && originPoint_equal; ++i)
        originPoint_equal = (originPoint[i] == obj.originPoint[i]);

    // Compare the normal arrays.
    bool normal_equal = true;
    for(i = 0; i < 3 && normal_equal; ++i)
        normal_equal = (normal[i] == obj.normal[i]);

    // Compare the upAxis arrays.
    bool upAxis_equal = true;
    for(i = 0; i < 3 && upAxis_equal; ++i)
        upAxis_equal = (upAxis[i] == obj.upAxis[i]);

    // Create the return value
    return ((originType == obj.originType) &&
            originPoint_equal &&
            (originIntercept == obj.originIntercept) &&
            (originPercent == obj.originPercent) &&
            (originZone == obj.originZone) &&
            (originNode == obj.originNode) &&
            normal_equal &&
            true /* can ignore axisType */ &&
            upAxis_equal &&
            (project2d == obj.project2d) &&
            (interactive == obj.interactive) &&
            true /* can ignore flip */ &&
            (originZoneDomain == obj.originZoneDomain) &&
            (originNodeDomain == obj.originNodeDomain) &&
            (meshName == obj.meshName));
}

// ****************************************************************************
// Method: SliceAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the SliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jan 25 16:57:05 PST 2005
//
// Modifications:
//   
// ****************************************************************************

bool
SliceAttributes::operator != (const SliceAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: SliceAttributes::TypeName
//
// Purpose: 
//   Type name method for the SliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jan 25 16:57:05 PST 2005
//
// Modifications:
//   
// ****************************************************************************

const std::string
SliceAttributes::TypeName() const
{
    return "SliceAttributes";
}

// ****************************************************************************
// Method: SliceAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the SliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Mar 15 15:24:44 PST 2002
//
// Modifications:
//    Jeremy Meredith, Fri Mar 15 15:47:24 PST 2002
//    Made origin be a Point.
//
//    Jeremy Meredith, Sun Nov 17 17:38:10 PST 2002
//    Updated for some orthogonal additions.
//
//    Jeremy Meredith, Mon May  5 15:01:30 PDT 2003
//    Changed the way origin works.
//
// ****************************************************************************

bool
SliceAttributes::CopyAttributes(const AttributeGroup *atts)
{
    bool retval = false;

    if(TypeName() == atts->TypeName())
    {
        // Call assignment operator.
        const SliceAttributes *tmp = (const SliceAttributes *)atts;
        *this = *tmp;
        retval = true;
    }
    else if(atts->TypeName() == "PlaneAttributes")
    {
        if(interactive)
        {
            const PlaneAttributes *tmp = (const PlaneAttributes *)atts;
            SetOriginPoint(tmp->GetOrigin());
            SetOriginType(Point);
            SetNormal(tmp->GetNormal());
            SetUpAxis(tmp->GetUpAxis());
            SetAxisType(Arbitrary);
            retval = true;
        }
    }

    return retval;
}

// ****************************************************************************
// Method: SliceAttributes::CreateCompatible
//
// Purpose: 
//   Creates an object of the specified type initialized with the attributes
//   from this object.
//
// Arguments:
//   tname : The typename of the object that we want to create.
//
// Returns:    A new object of the type specified by tname or 0.
//
// Note:       
//
// Programmer: Brad Whitlock
// Creation:   Mon Feb 11 15:36:32 PST 2002
//
// Modifications:
//    Jeremy Meredith, Fri Mar 15 15:42:27 PST 2002
//    Made origin be a Point.
//   
//    Jeremy Meredith, Mon May  5 15:01:30 PDT 2003
//    Changed the way origin works.
//
//    Kathleen Bonnell, Thu Jul  3 11:18:43 PDT 2003 
//    Set 'threeSpace' variable in PlaneAtts from 'project2d'. 
//
// ****************************************************************************

AttributeSubject *
SliceAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;

    if(TypeName() == tname)
    {
        retval = new SliceAttributes(*this);
    }
    else if(tname == "PlaneAttributes")
    {
        PlaneAttributes *p = new PlaneAttributes;

        p->SetOrigin(GetOriginPoint());
        p->SetNormal(GetNormal());
        p->SetUpAxis(GetUpAxis());
        p->SetThreeSpace(!GetProject2d());
        retval = p;
    }

    return retval;
}

// ****************************************************************************
// Method: SliceAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the SliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jan 25 16:57:05 PST 2005
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SliceAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new SliceAttributes(*this);
    else
        retval = new SliceAttributes;

    return retval;
}

// ****************************************************************************
// Method: SliceAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jan 25 16:57:05 PST 2005
//
// Modifications:
//   
// ****************************************************************************

void
SliceAttributes::SelectAll()
{
    Select(0, (void *)&originType);
    Select(1, (void *)originPoint, 3);
    Select(2, (void *)&originIntercept);
    Select(3, (void *)&originPercent);
    Select(4, (void *)&originZone);
    Select(5, (void *)&originNode);
    Select(6, (void *)normal, 3);
    Select(7, (void *)&axisType);
    Select(8, (void *)upAxis, 3);
    Select(9, (void *)&project2d);
    Select(10, (void *)&interactive);
    Select(11, (void *)&flip);
    Select(12, (void *)&originZoneDomain);
    Select(13, (void *)&originNodeDomain);
    Select(14, (void *)&meshName);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SliceAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jan 25 16:57:05 PST 2005
//
// Modifications:
//   
// ****************************************************************************

bool
SliceAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    SliceAttributes defaultObject;
    bool addToParent = false;
    // Create a node for SliceAttributes.
    DataNode *node = new DataNode("SliceAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("originType", OriginType_ToString(originType)));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("originPoint", originPoint, 3));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("originIntercept", originIntercept));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("originPercent", originPercent));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("originZone", originZone));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("originNode", originNode));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("normal", normal, 3));
    }

    if(completeSave || !FieldsEqual(7, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("axisType", AxisType_ToString(axisType)));
    }

    if(completeSave || !FieldsEqual(8, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("upAxis", upAxis, 3));
    }

    if(completeSave || !FieldsEqual(9, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("project2d", project2d));
    }

    if(completeSave || !FieldsEqual(10, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("interactive", interactive));
    }

    if(completeSave || !FieldsEqual(11, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("flip", flip));
    }

    if(completeSave || !FieldsEqual(12, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("originZoneDomain", originZoneDomain));
    }

    if(completeSave || !FieldsEqual(13, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("originNodeDomain", originNodeDomain));
    }

    if(completeSave || !FieldsEqual(14, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("meshName", meshName));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: SliceAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jan 25 16:57:05 PST 2005
//
// Modifications:
//   
// ****************************************************************************

void
SliceAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("SliceAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("originType")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 5)
                SetOriginType(OriginType(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            OriginType value;
            if(OriginType_FromString(node->AsString(), value))
                SetOriginType(value);
        }
    }
    if((node = searchNode->GetNode("originPoint")) != 0)
        SetOriginPoint(node->AsDoubleArray());
    if((node = searchNode->GetNode("originIntercept")) != 0)
        SetOriginIntercept(node->AsDouble());
    if((node = searchNode->GetNode("originPercent")) != 0)
        SetOriginPercent(node->AsDouble());
    if((node = searchNode->GetNode("originZone")) != 0)
        SetOriginZone(node->AsInt());
    if((node = searchNode->GetNode("originNode")) != 0)
        SetOriginNode(node->AsInt());
    if((node = searchNode->GetNode("normal")) != 0)
        SetNormal(node->AsDoubleArray());
    if((node = searchNode->GetNode("axisType")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 4)
                SetAxisType(AxisType(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            AxisType value;
            if(AxisType_FromString(node->AsString(), value))
                SetAxisType(value);
        }
    }
    if((node = searchNode->GetNode("upAxis")) != 0)
        SetUpAxis(node->AsDoubleArray());
    if((node = searchNode->GetNode("project2d")) != 0)
        SetProject2d(node->AsBool());
    if((node = searchNode->GetNode("interactive")) != 0)
        SetInteractive(node->AsBool());
    if((node = searchNode->GetNode("flip")) != 0)
        SetFlip(node->AsBool());
    if((node = searchNode->GetNode("originZoneDomain")) != 0)
        SetOriginZoneDomain(node->AsInt());
    if((node = searchNode->GetNode("originNodeDomain")) != 0)
        SetOriginNodeDomain(node->AsInt());
    if((node = searchNode->GetNode("meshName")) != 0)
        SetMeshName(node->AsString());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
SliceAttributes::SetOriginType(SliceAttributes::OriginType originType_)
{
    originType = originType_;
    Select(0, (void *)&originType);
}

void
SliceAttributes::SetOriginPoint(const double *originPoint_)
{
    originPoint[0] = originPoint_[0];
    originPoint[1] = originPoint_[1];
    originPoint[2] = originPoint_[2];
    Select(1, (void *)originPoint, 3);
}

void
SliceAttributes::SetOriginIntercept(double originIntercept_)
{
    originIntercept = originIntercept_;
    Select(2, (void *)&originIntercept);
}

void
SliceAttributes::SetOriginPercent(double originPercent_)
{
    originPercent = originPercent_;
    Select(3, (void *)&originPercent);
}

void
SliceAttributes::SetOriginZone(int originZone_)
{
    originZone = originZone_;
    Select(4, (void *)&originZone);
}

void
SliceAttributes::SetOriginNode(int originNode_)
{
    originNode = originNode_;
    Select(5, (void *)&originNode);
}

void
SliceAttributes::SetNormal(const double *normal_)
{
    normal[0] = normal_[0];
    normal[1] = normal_[1];
    normal[2] = normal_[2];
    Select(6, (void *)normal, 3);
}

void
SliceAttributes::SetAxisType(SliceAttributes::AxisType axisType_)
{
    axisType = axisType_;
    Select(7, (void *)&axisType);

    UpdateOrthogonalAxes();
}

void
SliceAttributes::SetUpAxis(const double *upAxis_)
{
    upAxis[0] = upAxis_[0];
    upAxis[1] = upAxis_[1];
    upAxis[2] = upAxis_[2];
    Select(8, (void *)upAxis, 3);
}

void
SliceAttributes::SetProject2d(bool project2d_)
{
    project2d = project2d_;
    Select(9, (void *)&project2d);
}

void
SliceAttributes::SetInteractive(bool interactive_)
{
    interactive = interactive_;
    Select(10, (void *)&interactive);
}

void
SliceAttributes::SetFlip(bool flip_)
{
    flip = flip_;
    Select(11, (void *)&flip);

    UpdateOrthogonalAxes();
}

void
SliceAttributes::SetOriginZoneDomain(int originZoneDomain_)
{
    originZoneDomain = originZoneDomain_;
    Select(12, (void *)&originZoneDomain);
}

void
SliceAttributes::SetOriginNodeDomain(int originNodeDomain_)
{
    originNodeDomain = originNodeDomain_;
    Select(13, (void *)&originNodeDomain);
}

void
SliceAttributes::SetMeshName(const std::string &meshName_)
{
    meshName = meshName_;
    Select(14, (void *)&meshName);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

SliceAttributes::OriginType
SliceAttributes::GetOriginType() const
{
    return OriginType(originType);
}

const double *
SliceAttributes::GetOriginPoint() const
{
    return originPoint;
}

double *
SliceAttributes::GetOriginPoint()
{
    return originPoint;
}

double
SliceAttributes::GetOriginIntercept() const
{
    return originIntercept;
}

double
SliceAttributes::GetOriginPercent() const
{
    return originPercent;
}

int
SliceAttributes::GetOriginZone() const
{
    return originZone;
}

int
SliceAttributes::GetOriginNode() const
{
    return originNode;
}

const double *
SliceAttributes::GetNormal() const
{
    return normal;
}

double *
SliceAttributes::GetNormal()
{
    return normal;
}

SliceAttributes::AxisType
SliceAttributes::GetAxisType() const
{
    return AxisType(axisType);
}

const double *
SliceAttributes::GetUpAxis() const
{
    return upAxis;
}

double *
SliceAttributes::GetUpAxis()
{
    return upAxis;
}

bool
SliceAttributes::GetProject2d() const
{
    return project2d;
}

bool
SliceAttributes::GetInteractive() const
{
    return interactive;
}

bool
SliceAttributes::GetFlip() const
{
    return flip;
}

int
SliceAttributes::GetOriginZoneDomain() const
{
    return originZoneDomain;
}

int
SliceAttributes::GetOriginNodeDomain() const
{
    return originNodeDomain;
}

const std::string &
SliceAttributes::GetMeshName() const
{
    return meshName;
}

std::string &
SliceAttributes::GetMeshName()
{
    return meshName;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
SliceAttributes::SelectOriginPoint()
{
    Select(1, (void *)originPoint, 3);
}

void
SliceAttributes::SelectNormal()
{
    Select(6, (void *)normal, 3);
}

void
SliceAttributes::SelectUpAxis()
{
    Select(8, (void *)upAxis, 3);
}

void
SliceAttributes::SelectMeshName()
{
    Select(14, (void *)&meshName);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SliceAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jan 25 16:57:05 PST 2005
//
// Modifications:
//   
// ****************************************************************************

std::string
SliceAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "originType";
        case 1:  return "originPoint";
        case 2:  return "originIntercept";
        case 3:  return "originPercent";
        case 4:  return "originZone";
        case 5:  return "originNode";
        case 6:  return "normal";
        case 7:  return "axisType";
        case 8:  return "upAxis";
        case 9:  return "project2d";
        case 10:  return "interactive";
        case 11:  return "flip";
        case 12:  return "originZoneDomain";
        case 13:  return "originNodeDomain";
        case 14:  return "meshName";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SliceAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jan 25 16:57:05 PST 2005
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
SliceAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_enum;
        case 1:  return FieldType_doubleArray;
        case 2:  return FieldType_double;
        case 3:  return FieldType_double;
        case 4:  return FieldType_int;
        case 5:  return FieldType_int;
        case 6:  return FieldType_doubleArray;
        case 7:  return FieldType_enum;
        case 8:  return FieldType_doubleArray;
        case 9:  return FieldType_bool;
        case 10:  return FieldType_bool;
        case 11:  return FieldType_bool;
        case 12:  return FieldType_int;
        case 13:  return FieldType_int;
        case 14:  return FieldType_string;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: SliceAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jan 25 16:57:05 PST 2005
//
// Modifications:
//   
// ****************************************************************************

std::string
SliceAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "enum";
        case 1:  return "doubleArray";
        case 2:  return "double";
        case 3:  return "double";
        case 4:  return "int";
        case 5:  return "int";
        case 6:  return "doubleArray";
        case 7:  return "enum";
        case 8:  return "doubleArray";
        case 9:  return "bool";
        case 10:  return "bool";
        case 11:  return "bool";
        case 12:  return "int";
        case 13:  return "int";
        case 14:  return "string";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SliceAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jan 25 16:57:05 PST 2005
//
// Modifications:
//   
// ****************************************************************************

bool
SliceAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    int i;

    const SliceAttributes &obj = *((const SliceAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (originType == obj.originType);
        }
        break;
    case 1:
        {  // new scope
        // Compare the originPoint arrays.
        bool originPoint_equal = true;
        for(i = 0; i < 3 && originPoint_equal; ++i)
            originPoint_equal = (originPoint[i] == obj.originPoint[i]);

        retval = originPoint_equal;
        }
        break;
    case 2:
        {  // new scope
        retval = (originIntercept == obj.originIntercept);
        }
        break;
    case 3:
        {  // new scope
        retval = (originPercent == obj.originPercent);
        }
        break;
    case 4:
        {  // new scope
        retval = (originZone == obj.originZone);
        }
        break;
    case 5:
        {  // new scope
        retval = (originNode == obj.originNode);
        }
        break;
    case 6:
        {  // new scope
        // Compare the normal arrays.
        bool normal_equal = true;
        for(i = 0; i < 3 && normal_equal; ++i)
            normal_equal = (normal[i] == obj.normal[i]);

        retval = normal_equal;
        }
        break;
    case 7:
        {  // new scope
        retval = (axisType == obj.axisType);
        }
        break;
    case 8:
        {  // new scope
        // Compare the upAxis arrays.
        bool upAxis_equal = true;
        for(i = 0; i < 3 && upAxis_equal; ++i)
            upAxis_equal = (upAxis[i] == obj.upAxis[i]);

        retval = upAxis_equal;
        }
        break;
    case 9:
        {  // new scope
        retval = (project2d == obj.project2d);
        }
        break;
    case 10:
        {  // new scope
        retval = (interactive == obj.interactive);
        }
        break;
    case 11:
        {  // new scope
        retval = (flip == obj.flip);
        }
        break;
    case 12:
        {  // new scope
        retval = (originZoneDomain == obj.originZoneDomain);
        }
        break;
    case 13:
        {  // new scope
        retval = (originNodeDomain == obj.originNodeDomain);
        }
        break;
    case 14:
        {  // new scope
        retval = (meshName == obj.meshName);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
//  Method:  SliceAttributes::UpdateOrthogonalAxes
//
//  Purpose:
//    Updates upaxis and normal for an orthogonal axis.
//
//  Programmer:  Jeremy Meredith
//  Creation:    November 17, 2002
//
//  Modifications:
//    Jeremy Meredith, Mon May  5 15:01:59 PDT 2003
//    Re-ordered some fields, so the select calls needed to be changed here.
//
//    Kathleen Bonnell, Tue Jul  8 20:21:23 PDT 2003 
//    Slice now uses right-hand system when creating projection matrix.
//    Updated normals and upAxis to conform (with help from Jeremy). 
//
// ****************************************************************************
void
SliceAttributes::UpdateOrthogonalAxes()
{
    if (axisType == Arbitrary)
        return;

    switch(axisType)
    {
      case XAxis:
        if (!flip)
        {
            // X: Y vs Z
            normal[0] = -1.; normal[1] =  0.; normal[2] =  0.;
            upAxis[0] =  0.; upAxis[1] =  1.; upAxis[2] =  0.;
        }
        else
        {
            // X: Z vs Y
            normal[0] =  1.; normal[1] =  0.; normal[2] =  0.;
            upAxis[0] =  0.; upAxis[1] =  0.; upAxis[2] =  1.;
        }
        break;
      case YAxis:
        if (!flip)
        {
            // Y: Z vs X
            normal[0] =  0.; normal[1] = -1.; normal[2] =  0.;
            upAxis[0] =  0.; upAxis[1] =  0.; upAxis[2] =  1.;
        }
        else
        {
            // Y: X vs Z
            normal[0] =  0.; normal[1] =  1.; normal[2] =  0.;
            upAxis[0] =  1.; upAxis[1] =  0.; upAxis[2] =  0.;
        }
        break;
      case ZAxis:
        if (!flip)
        {
            // Z: Y vs X
            normal[0] =  0.; normal[1] =  0.; normal[2] =  1.;
            upAxis[0] =  0.; upAxis[1] =  1.; upAxis[2] =  0.;
        }
        else
        {
            // Z: X vs Y
            normal[0] =  0.; normal[1] =  0.; normal[2] = -1.;
            upAxis[0] =  1.; upAxis[1] =  0.; upAxis[2] =  0.;
        }
        break;
      default:
        break;
    }

    Select(6, (void *)normal, 3);
    Select(8, (void *)upAxis, 3);
}

