#include <PySliceAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PySliceAttributes
//
// Purpose: 
//   This class contains attributes for the arbitrary slice.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Tue Jan 25 16:57:23 PST 2005
//
// ****************************************************************************

//
// This struct contains the Python type information and a SliceAttributes.
//
struct SliceAttributesObject
{
    PyObject_HEAD
    SliceAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewSliceAttributes();

static PyObject *
SliceAttributes_Notify(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SliceAttributes_SetOriginType(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the originType in the object.
    if(ival >= 0 && ival < 5)
        obj->data->SetOriginType(SliceAttributes::OriginType(ival));
    else
    {
        fprintf(stderr, "An invalid originType value was given. "
                        "Valid values are in the range of [0,4]. "
                        "You can also use the following names: "
                        "Point, Intercept, Percent, Zone, Node.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SliceAttributes_GetOriginType(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOriginType()));
    return retval;
}

static PyObject *
SliceAttributes_SetOriginPoint(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;

    double *dvals = obj->data->GetOriginPoint();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the originPoint in the object as modified.
    obj->data->SelectOriginPoint();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SliceAttributes_GetOriginPoint(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the originPoint.
    PyObject *retval = PyTuple_New(3);
    const double *originPoint = obj->data->GetOriginPoint();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(originPoint[i]));
    return retval;
}

static PyObject *
SliceAttributes_SetOriginIntercept(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the originIntercept in the object.
    obj->data->SetOriginIntercept(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SliceAttributes_GetOriginIntercept(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOriginIntercept());
    return retval;
}

static PyObject *
SliceAttributes_SetOriginPercent(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the originPercent in the object.
    obj->data->SetOriginPercent(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SliceAttributes_GetOriginPercent(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOriginPercent());
    return retval;
}

static PyObject *
SliceAttributes_SetOriginZone(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the originZone in the object.
    obj->data->SetOriginZone(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SliceAttributes_GetOriginZone(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOriginZone()));
    return retval;
}

static PyObject *
SliceAttributes_SetOriginNode(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the originNode in the object.
    obj->data->SetOriginNode(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SliceAttributes_GetOriginNode(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOriginNode()));
    return retval;
}

static PyObject *
SliceAttributes_SetNormal(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;

    double *dvals = obj->data->GetNormal();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the normal in the object as modified.
    obj->data->SelectNormal();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SliceAttributes_GetNormal(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the normal.
    PyObject *retval = PyTuple_New(3);
    const double *normal = obj->data->GetNormal();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(normal[i]));
    return retval;
}

static PyObject *
SliceAttributes_SetAxisType(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the axisType in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetAxisType(SliceAttributes::AxisType(ival));
    else
    {
        fprintf(stderr, "An invalid axisType value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "XAxis, YAxis, ZAxis, Arbitrary.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SliceAttributes_GetAxisType(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetAxisType()));
    return retval;
}

static PyObject *
SliceAttributes_SetUpAxis(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;

    double *dvals = obj->data->GetUpAxis();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the upAxis in the object as modified.
    obj->data->SelectUpAxis();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SliceAttributes_GetUpAxis(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the upAxis.
    PyObject *retval = PyTuple_New(3);
    const double *upAxis = obj->data->GetUpAxis();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(upAxis[i]));
    return retval;
}

static PyObject *
SliceAttributes_SetProject2d(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the project2d in the object.
    obj->data->SetProject2d(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SliceAttributes_GetProject2d(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetProject2d()?1L:0L);
    return retval;
}

static PyObject *
SliceAttributes_SetInteractive(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the interactive in the object.
    obj->data->SetInteractive(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SliceAttributes_GetInteractive(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetInteractive()?1L:0L);
    return retval;
}

static PyObject *
SliceAttributes_SetFlip(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the flip in the object.
    obj->data->SetFlip(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SliceAttributes_GetFlip(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetFlip()?1L:0L);
    return retval;
}

static PyObject *
SliceAttributes_SetOriginZoneDomain(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the originZoneDomain in the object.
    obj->data->SetOriginZoneDomain(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SliceAttributes_GetOriginZoneDomain(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOriginZoneDomain()));
    return retval;
}

static PyObject *
SliceAttributes_SetOriginNodeDomain(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the originNodeDomain in the object.
    obj->data->SetOriginNodeDomain(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SliceAttributes_GetOriginNodeDomain(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOriginNodeDomain()));
    return retval;
}

static PyObject *
SliceAttributes_SetMeshName(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the meshName in the object.
    obj->data->SetMeshName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SliceAttributes_GetMeshName(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetMeshName().c_str());
    return retval;
}



static struct PyMethodDef SliceAttributes_methods[] = {
    {"Notify", SliceAttributes_Notify, METH_VARARGS},
    {"SetOriginType", SliceAttributes_SetOriginType, METH_VARARGS},
    {"GetOriginType", SliceAttributes_GetOriginType, METH_VARARGS},
    {"SetOriginPoint", SliceAttributes_SetOriginPoint, METH_VARARGS},
    {"GetOriginPoint", SliceAttributes_GetOriginPoint, METH_VARARGS},
    {"SetOriginIntercept", SliceAttributes_SetOriginIntercept, METH_VARARGS},
    {"GetOriginIntercept", SliceAttributes_GetOriginIntercept, METH_VARARGS},
    {"SetOriginPercent", SliceAttributes_SetOriginPercent, METH_VARARGS},
    {"GetOriginPercent", SliceAttributes_GetOriginPercent, METH_VARARGS},
    {"SetOriginZone", SliceAttributes_SetOriginZone, METH_VARARGS},
    {"GetOriginZone", SliceAttributes_GetOriginZone, METH_VARARGS},
    {"SetOriginNode", SliceAttributes_SetOriginNode, METH_VARARGS},
    {"GetOriginNode", SliceAttributes_GetOriginNode, METH_VARARGS},
    {"SetNormal", SliceAttributes_SetNormal, METH_VARARGS},
    {"GetNormal", SliceAttributes_GetNormal, METH_VARARGS},
    {"SetAxisType", SliceAttributes_SetAxisType, METH_VARARGS},
    {"GetAxisType", SliceAttributes_GetAxisType, METH_VARARGS},
    {"SetUpAxis", SliceAttributes_SetUpAxis, METH_VARARGS},
    {"GetUpAxis", SliceAttributes_GetUpAxis, METH_VARARGS},
    {"SetProject2d", SliceAttributes_SetProject2d, METH_VARARGS},
    {"GetProject2d", SliceAttributes_GetProject2d, METH_VARARGS},
    {"SetInteractive", SliceAttributes_SetInteractive, METH_VARARGS},
    {"GetInteractive", SliceAttributes_GetInteractive, METH_VARARGS},
    {"SetFlip", SliceAttributes_SetFlip, METH_VARARGS},
    {"GetFlip", SliceAttributes_GetFlip, METH_VARARGS},
    {"SetOriginZoneDomain", SliceAttributes_SetOriginZoneDomain, METH_VARARGS},
    {"GetOriginZoneDomain", SliceAttributes_GetOriginZoneDomain, METH_VARARGS},
    {"SetOriginNodeDomain", SliceAttributes_SetOriginNodeDomain, METH_VARARGS},
    {"GetOriginNodeDomain", SliceAttributes_GetOriginNodeDomain, METH_VARARGS},
    {"SetMeshName", SliceAttributes_SetMeshName, METH_VARARGS},
    {"GetMeshName", SliceAttributes_GetMeshName, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
SliceAttributes_dealloc(PyObject *v)
{
   SliceAttributesObject *obj = (SliceAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
SliceAttributes_compare(PyObject *v, PyObject *w)
{
    SliceAttributes *a = ((SliceAttributesObject *)v)->data;
    SliceAttributes *b = ((SliceAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
SliceAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "originType") == 0)
        return SliceAttributes_GetOriginType(self, NULL);
    if(strcmp(name, "Point") == 0)
        return PyInt_FromLong(long(SliceAttributes::Point));
    else if(strcmp(name, "Intercept") == 0)
        return PyInt_FromLong(long(SliceAttributes::Intercept));
    else if(strcmp(name, "Percent") == 0)
        return PyInt_FromLong(long(SliceAttributes::Percent));
    else if(strcmp(name, "Zone") == 0)
        return PyInt_FromLong(long(SliceAttributes::Zone));
    else if(strcmp(name, "Node") == 0)
        return PyInt_FromLong(long(SliceAttributes::Node));

    if(strcmp(name, "originPoint") == 0)
        return SliceAttributes_GetOriginPoint(self, NULL);
    if(strcmp(name, "originIntercept") == 0)
        return SliceAttributes_GetOriginIntercept(self, NULL);
    if(strcmp(name, "originPercent") == 0)
        return SliceAttributes_GetOriginPercent(self, NULL);
    if(strcmp(name, "originZone") == 0)
        return SliceAttributes_GetOriginZone(self, NULL);
    if(strcmp(name, "originNode") == 0)
        return SliceAttributes_GetOriginNode(self, NULL);
    if(strcmp(name, "normal") == 0)
        return SliceAttributes_GetNormal(self, NULL);
    if(strcmp(name, "axisType") == 0)
        return SliceAttributes_GetAxisType(self, NULL);
    if(strcmp(name, "XAxis") == 0)
        return PyInt_FromLong(long(SliceAttributes::XAxis));
    else if(strcmp(name, "YAxis") == 0)
        return PyInt_FromLong(long(SliceAttributes::YAxis));
    else if(strcmp(name, "ZAxis") == 0)
        return PyInt_FromLong(long(SliceAttributes::ZAxis));
    else if(strcmp(name, "Arbitrary") == 0)
        return PyInt_FromLong(long(SliceAttributes::Arbitrary));

    if(strcmp(name, "upAxis") == 0)
        return SliceAttributes_GetUpAxis(self, NULL);
    if(strcmp(name, "project2d") == 0)
        return SliceAttributes_GetProject2d(self, NULL);
    if(strcmp(name, "interactive") == 0)
        return SliceAttributes_GetInteractive(self, NULL);
    if(strcmp(name, "flip") == 0)
        return SliceAttributes_GetFlip(self, NULL);
    if(strcmp(name, "originZoneDomain") == 0)
        return SliceAttributes_GetOriginZoneDomain(self, NULL);
    if(strcmp(name, "originNodeDomain") == 0)
        return SliceAttributes_GetOriginNodeDomain(self, NULL);
    if(strcmp(name, "meshName") == 0)
        return SliceAttributes_GetMeshName(self, NULL);

    return Py_FindMethod(SliceAttributes_methods, self, name);
}

static int
SliceAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "originType") == 0)
        retval = (SliceAttributes_SetOriginType(self, tuple) != NULL);
    else if(strcmp(name, "originPoint") == 0)
        retval = (SliceAttributes_SetOriginPoint(self, tuple) != NULL);
    else if(strcmp(name, "originIntercept") == 0)
        retval = (SliceAttributes_SetOriginIntercept(self, tuple) != NULL);
    else if(strcmp(name, "originPercent") == 0)
        retval = (SliceAttributes_SetOriginPercent(self, tuple) != NULL);
    else if(strcmp(name, "originZone") == 0)
        retval = (SliceAttributes_SetOriginZone(self, tuple) != NULL);
    else if(strcmp(name, "originNode") == 0)
        retval = (SliceAttributes_SetOriginNode(self, tuple) != NULL);
    else if(strcmp(name, "normal") == 0)
        retval = (SliceAttributes_SetNormal(self, tuple) != NULL);
    else if(strcmp(name, "axisType") == 0)
        retval = (SliceAttributes_SetAxisType(self, tuple) != NULL);
    else if(strcmp(name, "upAxis") == 0)
        retval = (SliceAttributes_SetUpAxis(self, tuple) != NULL);
    else if(strcmp(name, "project2d") == 0)
        retval = (SliceAttributes_SetProject2d(self, tuple) != NULL);
    else if(strcmp(name, "interactive") == 0)
        retval = (SliceAttributes_SetInteractive(self, tuple) != NULL);
    else if(strcmp(name, "flip") == 0)
        retval = (SliceAttributes_SetFlip(self, tuple) != NULL);
    else if(strcmp(name, "originZoneDomain") == 0)
        retval = (SliceAttributes_SetOriginZoneDomain(self, tuple) != NULL);
    else if(strcmp(name, "originNodeDomain") == 0)
        retval = (SliceAttributes_SetOriginNodeDomain(self, tuple) != NULL);
    else if(strcmp(name, "meshName") == 0)
        retval = (SliceAttributes_SetMeshName(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
SliceAttributes_print(PyObject *v, FILE *fp, int flags)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)v;

    const char *originType_names = "Point, Intercept, Percent, Zone, Node";
    if(obj->data->GetOriginType() == SliceAttributes::Point)
        fprintf(fp, "originType = Point  # %s\n", originType_names);
    else if(obj->data->GetOriginType() == SliceAttributes::Intercept)
        fprintf(fp, "originType = Intercept  # %s\n", originType_names);
    else if(obj->data->GetOriginType() == SliceAttributes::Percent)
        fprintf(fp, "originType = Percent  # %s\n", originType_names);
    else if(obj->data->GetOriginType() == SliceAttributes::Zone)
        fprintf(fp, "originType = Zone  # %s\n", originType_names);
    else
        fprintf(fp, "originType = Node  # %s\n", originType_names);

    {   const double *originPoint = obj->data->GetOriginPoint();
        fprintf(fp, "originPoint = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", originPoint[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    fprintf(fp, "originIntercept = %g\n", obj->data->GetOriginIntercept());
    fprintf(fp, "originPercent = %g\n", obj->data->GetOriginPercent());
    fprintf(fp, "originZone = %d\n", obj->data->GetOriginZone());
    fprintf(fp, "originNode = %d\n", obj->data->GetOriginNode());
    {   const double *normal = obj->data->GetNormal();
        fprintf(fp, "normal = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", normal[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    const char *axisType_names = "XAxis, YAxis, ZAxis, Arbitrary";
    if(obj->data->GetAxisType() == SliceAttributes::XAxis)
        fprintf(fp, "axisType = XAxis  # %s\n", axisType_names);
    else if(obj->data->GetAxisType() == SliceAttributes::YAxis)
        fprintf(fp, "axisType = YAxis  # %s\n", axisType_names);
    else if(obj->data->GetAxisType() == SliceAttributes::ZAxis)
        fprintf(fp, "axisType = ZAxis  # %s\n", axisType_names);
    else
        fprintf(fp, "axisType = Arbitrary  # %s\n", axisType_names);

    {   const double *upAxis = obj->data->GetUpAxis();
        fprintf(fp, "upAxis = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", upAxis[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    if(obj->data->GetProject2d())
        fprintf(fp, "project2d = 1\n");
    else
        fprintf(fp, "project2d = 0\n");
    if(obj->data->GetInteractive())
        fprintf(fp, "interactive = 1\n");
    else
        fprintf(fp, "interactive = 0\n");
    if(obj->data->GetFlip())
        fprintf(fp, "flip = 1\n");
    else
        fprintf(fp, "flip = 0\n");
    fprintf(fp, "originZoneDomain = %d\n", obj->data->GetOriginZoneDomain());
    fprintf(fp, "originNodeDomain = %d\n", obj->data->GetOriginNodeDomain());
    fprintf(fp, "meshName = \"%s\"\n", obj->data->GetMeshName().c_str());

    return 0;
}

#include <snprintf.h>
PyObject *
PySliceAttributes_StringRepresentation(const SliceAttributes *atts)
{
   std::string str; 
   char tmpStr[1000]; 

    const char *originType_names = "Point, Intercept, Percent, Zone, Node";
    if(atts->GetOriginType() == SliceAttributes::Point)
        {
             SNPRINTF(tmpStr, 1000, "originType = Point  # %s\n", originType_names);
             str += tmpStr;
        }
    else if(atts->GetOriginType() == SliceAttributes::Intercept)
        {
             SNPRINTF(tmpStr, 1000, "originType = Intercept  # %s\n", originType_names);
             str += tmpStr;
        }
    else if(atts->GetOriginType() == SliceAttributes::Percent)
        {
             SNPRINTF(tmpStr, 1000, "originType = Percent  # %s\n", originType_names);
             str += tmpStr;
        }
    else if(atts->GetOriginType() == SliceAttributes::Zone)
        {
             SNPRINTF(tmpStr, 1000, "originType = Zone  # %s\n", originType_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "originType = Node  # %s\n", originType_names);
             str += tmpStr;
        }

    {   const double *originPoint = atts->GetOriginPoint();
        SNPRINTF(tmpStr, 1000, "originPoint = (");
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", originPoint[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "originIntercept = %g\n", atts->GetOriginIntercept());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "originPercent = %g\n", atts->GetOriginPercent());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "originZone = %d\n", atts->GetOriginZone());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "originNode = %d\n", atts->GetOriginNode());
    str += tmpStr;
    {   const double *normal = atts->GetNormal();
        SNPRINTF(tmpStr, 1000, "normal = (");
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", normal[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    const char *axisType_names = "XAxis, YAxis, ZAxis, Arbitrary";
    if(atts->GetAxisType() == SliceAttributes::XAxis)
        {
             SNPRINTF(tmpStr, 1000, "axisType = XAxis  # %s\n", axisType_names);
             str += tmpStr;
        }
    else if(atts->GetAxisType() == SliceAttributes::YAxis)
        {
             SNPRINTF(tmpStr, 1000, "axisType = YAxis  # %s\n", axisType_names);
             str += tmpStr;
        }
    else if(atts->GetAxisType() == SliceAttributes::ZAxis)
        {
             SNPRINTF(tmpStr, 1000, "axisType = ZAxis  # %s\n", axisType_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "axisType = Arbitrary  # %s\n", axisType_names);
             str += tmpStr;
        }

    {   const double *upAxis = atts->GetUpAxis();
        SNPRINTF(tmpStr, 1000, "upAxis = (");
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", upAxis[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->GetProject2d())
        SNPRINTF(tmpStr, 1000, "project2d = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "project2d = 0\n");
    str += tmpStr;
    if(atts->GetInteractive())
        SNPRINTF(tmpStr, 1000, "interactive = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "interactive = 0\n");
    str += tmpStr;
    if(atts->GetFlip())
        SNPRINTF(tmpStr, 1000, "flip = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "flip = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "originZoneDomain = %d\n", atts->GetOriginZoneDomain());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "originNodeDomain = %d\n", atts->GetOriginNodeDomain());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "meshName = \"%s\"\n", atts->GetMeshName().c_str());
    str += tmpStr;
    return PyString_FromString(str.c_str());
}

static PyObject *
SliceAttributes_str(PyObject *v)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)v;
    return PySliceAttributes_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
static char *SliceAttributes_Purpose = "This class contains attributes for the arbitrary slice.";

//
// The type description structure
//
static PyTypeObject SliceAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "SliceAttributes",                    // tp_name
    sizeof(SliceAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)SliceAttributes_dealloc,  // tp_dealloc
    (printfunc)SliceAttributes_print,     // tp_print
    (getattrfunc)SliceAttributes_getattr, // tp_getattr
    (setattrfunc)SliceAttributes_setattr, // tp_setattr
    (cmpfunc)SliceAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)SliceAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    SliceAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static SliceAttributes *defaultAtts = 0;

static PyObject *
NewSliceAttributes()
{
    SliceAttributesObject *newObject;
    newObject = PyObject_NEW(SliceAttributesObject, &SliceAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new SliceAttributes(*defaultAtts);
    else
        newObject->data = new SliceAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapSliceAttributes(const SliceAttributes *attr)
{
    SliceAttributesObject *newObject;
    newObject = PyObject_NEW(SliceAttributesObject, &SliceAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (SliceAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
SliceAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewSliceAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef SliceAttributesMethods[] = {
    {"SliceAttributes", SliceAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *SliceAttributesObserver = 0;
static bool SliceAttributesEnableLogging = true;

static void
PySliceAttributes_WriteLog(Subject *subj, void *data)
{
    SliceAttributes *atts = (SliceAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!SliceAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# SliceAttributes_WriteLog()\n");
}

void
PySliceAttributes_StartUp(SliceAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PySliceAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(SliceAttributesObserver == 0)
    {
        SliceAttributesObserver = new ObserverToCallback(subj,
            PySliceAttributes_WriteLog, (void *)logFile);
    }

    SliceAttributesEnableLogging = true;
}

void
PySliceAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete SliceAttributesObserver;
    SliceAttributesObserver = 0;
}

PyMethodDef *
PySliceAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return SliceAttributesMethods;
}

bool
PySliceAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &SliceAttributesType);
}

SliceAttributes *
PySliceAttributes_FromPyObject(PyObject *obj)
{
    SliceAttributesObject *obj2 = (SliceAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PySliceAttributes_NewPyObject()
{
    return NewSliceAttributes();
}

PyObject *
PySliceAttributes_WrapPyObject(const SliceAttributes *attr)
{
    return WrapSliceAttributes(attr);
}

void
PySliceAttributes_SetLogging(bool val)
{
    SliceAttributesEnableLogging = val;
}

void
PySliceAttributes_SetDefaults(const SliceAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new SliceAttributes(*atts);
}

