// ************************************************************************* //
//  File: SiloDumpViewerPluginInfo.C
// ************************************************************************* //

#include <SiloDumpPluginInfo.h>
#include <SiloDumpAttributes.h>

#if defined(__APPLE__)
#define GetViewerInfo SiloDump_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the SiloDump operator.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:04:53 PST 2003
//
// ****************************************************************************
extern "C" ViewerOperatorPluginInfo* GetViewerInfo()
{
    SiloDumpViewerPluginInfo::InitializeGlobalObjects();
    return new SiloDumpViewerPluginInfo;
}

//
// Storage for static data elements.
//
SiloDumpAttributes *SiloDumpViewerPluginInfo::clientAtts = NULL;
SiloDumpAttributes *SiloDumpViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  SiloDumpViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:04:53 PST 2003
//
// ****************************************************************************
void
SiloDumpViewerPluginInfo::InitializeGlobalObjects()
{
    SiloDumpViewerPluginInfo::clientAtts  = new SiloDumpAttributes;
    SiloDumpViewerPluginInfo::defaultAtts = new SiloDumpAttributes;
}

// ****************************************************************************
//  Method: SiloDumpViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:04:53 PST 2003
//
// ****************************************************************************

AttributeSubject *
SiloDumpViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: SiloDumpViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:04:53 PST 2003
//
// ****************************************************************************

AttributeSubject *
SiloDumpViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: SiloDumpViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:04:53 PST 2003
//
// ****************************************************************************

void
SiloDumpViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(SiloDumpAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: SiloDumpViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:04:53 PST 2003
//
// ****************************************************************************

void
SiloDumpViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(SiloDumpAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: SiloDumpViewerPluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:04:53 PST 2003
//
// ****************************************************************************

void
SiloDumpViewerPluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const ViewerPlot *plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(SiloDumpAttributes*)atts = *defaultAtts;
    else
        *(SiloDumpAttributes*)atts = *clientAtts;
}
