// ************************************************************************* //
//                        SiloDumpScriptingPluginInfo.C
// ************************************************************************* //
#include <SiloDumpPluginInfo.h>
#include <PySiloDumpAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo SiloDump_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the SiloDump plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:37:01 PST 2002
//
// ****************************************************************************
extern "C" ScriptingOperatorPluginInfo* GetScriptingInfo()
{
    return new SiloDumpScriptingPluginInfo;
}

// ****************************************************************************
// Method: SiloDumpScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:37:01 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
SiloDumpScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PySiloDumpAttributes_StartUp((SiloDumpAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: SiloDumpScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:37:01 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void *
SiloDumpScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PySiloDumpAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: SiloDumpScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is SiloDump plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:37:01 PST 2002
//
// Modifications:
//   
// ****************************************************************************

bool
SiloDumpScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PySiloDumpAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: SiloDumpScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:37:01 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
SiloDumpScriptingPluginInfo::SetLogging(bool val)
{
    PySiloDumpAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: SiloDumpScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:37:01 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
SiloDumpScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PySiloDumpAttributes_SetDefaults((const SiloDumpAttributes *)atts);
}
