// ************************************************************************* //
//  File: SiloDumpGUIPluginInfo.C
// ************************************************************************* //

#include <SiloDumpPluginInfo.h>
#include <SiloDumpAttributes.h>
#include <QvisSiloDumpWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo SiloDump_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the SiloDump operator.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri Jan 4 14:25:24 PST 2002
//
// ****************************************************************************
extern "C" GUIOperatorPluginInfo* GetGUIInfo()
{
    return new SiloDumpGUIPluginInfo;
}

// ****************************************************************************
//  Method: SiloDumpGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri Jan 4 14:25:24 PST 2002
//
// ****************************************************************************

const char *
SiloDumpGUIPluginInfo::GetMenuName() const
{
    return "Silo Dump";
}


// ****************************************************************************
//  Method: SiloDumpGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri Jan 4 14:25:24 PST 2002
//
// ****************************************************************************

QvisPostableWindowObserver *
SiloDumpGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisSiloDumpWindow(type, (SiloDumpAttributes *)attr,
        "Silo Dump operator attributes", "SiloDump operator", notepad);
}
