// ************************************************************************* //
//  File: RevolveViewerPluginInfo.C
// ************************************************************************* //

#include <RevolvePluginInfo.h>
#include <RevolveAttributes.h>

#if defined(__APPLE__)
#define GetViewerInfo Revolve_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Revolve operator.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:04:43 PST 2003
//
// ****************************************************************************
extern "C" ViewerOperatorPluginInfo* GetViewerInfo()
{
    RevolveViewerPluginInfo::InitializeGlobalObjects();
    return new RevolveViewerPluginInfo;
}

//
// Storage for static data elements.
//
RevolveAttributes *RevolveViewerPluginInfo::clientAtts = NULL;
RevolveAttributes *RevolveViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  RevolveViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:04:43 PST 2003
//
// ****************************************************************************
void
RevolveViewerPluginInfo::InitializeGlobalObjects()
{
    RevolveViewerPluginInfo::clientAtts  = new RevolveAttributes;
    RevolveViewerPluginInfo::defaultAtts = new RevolveAttributes;
}

// ****************************************************************************
//  Method: RevolveViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:04:43 PST 2003
//
// ****************************************************************************

AttributeSubject *
RevolveViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: RevolveViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:04:43 PST 2003
//
// ****************************************************************************

AttributeSubject *
RevolveViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: RevolveViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:04:43 PST 2003
//
// ****************************************************************************

void
RevolveViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(RevolveAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: RevolveViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:04:43 PST 2003
//
// ****************************************************************************

void
RevolveViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(RevolveAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: RevolveViewerPluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:04:43 PST 2003
//
// ****************************************************************************

void
RevolveViewerPluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const ViewerPlot *plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(RevolveAttributes*)atts = *defaultAtts;
    else
        *(RevolveAttributes*)atts = *clientAtts;
}
