// ************************************************************************* //
//                        RevolveScriptingPluginInfo.C
// ************************************************************************* //
#include <RevolvePluginInfo.h>
#include <PyRevolveAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo Revolve_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the Revolve plot.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Wed Dec 11 14:17:27 PST 2002
//
// ****************************************************************************
extern "C" ScriptingOperatorPluginInfo* GetScriptingInfo()
{
    return new RevolveScriptingPluginInfo;
}

// ****************************************************************************
// Method: RevolveScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Wed Dec 11 14:17:27 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
RevolveScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyRevolveAttributes_StartUp((RevolveAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: RevolveScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Wed Dec 11 14:17:27 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void *
RevolveScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyRevolveAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: RevolveScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is Revolve plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Wed Dec 11 14:17:27 PST 2002
//
// Modifications:
//   
// ****************************************************************************

bool
RevolveScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyRevolveAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: RevolveScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Wed Dec 11 14:17:27 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
RevolveScriptingPluginInfo::SetLogging(bool val)
{
    PyRevolveAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: RevolveScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Wed Dec 11 14:17:27 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
RevolveScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyRevolveAttributes_SetDefaults((const RevolveAttributes *)atts);
}
