// ************************************************************************* //
//  File: RevolveGUIPluginInfo.C
// ************************************************************************* //

#include <RevolvePluginInfo.h>
#include <RevolveAttributes.h>
#include <QvisRevolveWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo Revolve_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the Revolve operator.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Wed Dec 11 14:17:27 PST 2002
//
// ****************************************************************************
extern "C" GUIOperatorPluginInfo* GetGUIInfo()
{
    return new RevolveGUIPluginInfo;
}

// ****************************************************************************
//  Method: RevolveGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Wed Dec 11 14:17:27 PST 2002
//
// ****************************************************************************

const char *
RevolveGUIPluginInfo::GetMenuName() const
{
    return "Revolve";
}


// ****************************************************************************
//  Method: RevolveGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Wed Dec 11 14:17:27 PST 2002
//
// ****************************************************************************

QvisPostableWindowObserver *
RevolveGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisRevolveWindow(type, (RevolveAttributes *)attr,
        "Revolve operator attributes", "Revolve operator", notepad);
}
