package llnl.visit.operators;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;

// ****************************************************************************
// Class: RevolveAttributes
//
// Purpose:
//    This class contains attributes for the revolve operator.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Thu Jul 31 16:09:24 PST 2003
//
// Modifications:
//   
// ****************************************************************************

public class RevolveAttributes extends AttributeSubject implements Plugin
{
    public RevolveAttributes()
    {
        super(4);

        axis = new double[3];
        axis[0] = 1;
        axis[1] = 0;
        axis[2] = 0;
        startAngle = 0;
        stopAngle = 360;
        steps = 30;
    }

    public RevolveAttributes(RevolveAttributes obj)
    {
        super(4);

        int i;

        axis = new double[3];
        axis[0] = obj.axis[0];
        axis[1] = obj.axis[1];
        axis[2] = obj.axis[2];

        startAngle = obj.startAngle;
        stopAngle = obj.stopAngle;
        steps = obj.steps;

        SelectAll();
    }

    public boolean equals(RevolveAttributes obj)
    {
        int i;

        // Compare the axis arrays.
        boolean axis_equal = true;
        for(i = 0; i < 3 && axis_equal; ++i)
            axis_equal = (axis[i] == obj.axis[i]);

        // Create the return value
        return (axis_equal &&
                (startAngle == obj.startAngle) &&
                (stopAngle == obj.stopAngle) &&
                (steps == obj.steps));
    }

    public String GetName() { return "Revolve"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetAxis(double[] axis_)
    {
        axis[0] = axis_[0];
        axis[1] = axis_[1];
        axis[2] = axis_[2];
        Select(0);
    }

    public void SetAxis(double e0, double e1, double e2)
    {
        axis[0] = e0;
        axis[1] = e1;
        axis[2] = e2;
        Select(0);
    }

    public void SetStartAngle(double startAngle_)
    {
        startAngle = startAngle_;
        Select(1);
    }

    public void SetStopAngle(double stopAngle_)
    {
        stopAngle = stopAngle_;
        Select(2);
    }

    public void SetSteps(int steps_)
    {
        steps = steps_;
        Select(3);
    }

    // Property getting methods
    public double[] GetAxis() { return axis; }
    public double   GetStartAngle() { return startAngle; }
    public double   GetStopAngle() { return stopAngle; }
    public int      GetSteps() { return steps; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteDoubleArray(axis);
        if(WriteSelect(1, buf))
            buf.WriteDouble(startAngle);
        if(WriteSelect(2, buf))
            buf.WriteDouble(stopAngle);
        if(WriteSelect(3, buf))
            buf.WriteInt(steps);
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        for(int i = 0; i < n; ++i)
        {
            int index = (int)buf.ReadByte();
            switch(index)
            {
            case 0:
                SetAxis(buf.ReadDoubleArray());
                break;
            case 1:
                SetStartAngle(buf.ReadDouble());
                break;
            case 2:
                SetStopAngle(buf.ReadDouble());
                break;
            case 3:
                SetSteps(buf.ReadInt());
                break;
            }
        }
    }


    // Attributes
    private double[] axis;
    private double   startAngle;
    private double   stopAngle;
    private int      steps;
}

