#include <PyRevolveAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyRevolveAttributes
//
// Purpose: 
//   This class contains attributes for the revolve operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Wed Dec 11 14:17:28 PST 2002
//
// ****************************************************************************

//
// This struct contains the Python type information and a RevolveAttributes.
//
struct RevolveAttributesObject
{
    PyObject_HEAD
    RevolveAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewRevolveAttributes();

static PyObject *
RevolveAttributes_Notify(PyObject *self, PyObject *args)
{
    RevolveAttributesObject *obj = (RevolveAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
RevolveAttributes_SetAxis(PyObject *self, PyObject *args)
{
    RevolveAttributesObject *obj = (RevolveAttributesObject *)self;

    double *dvals = obj->data->GetAxis();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the axis in the object as modified.
    obj->data->SelectAxis();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
RevolveAttributes_GetAxis(PyObject *self, PyObject *args)
{
    RevolveAttributesObject *obj = (RevolveAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the axis.
    PyObject *retval = PyTuple_New(3);
    const double *axis = obj->data->GetAxis();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(axis[i]));
    return retval;
}

static PyObject *
RevolveAttributes_SetStartAngle(PyObject *self, PyObject *args)
{
    RevolveAttributesObject *obj = (RevolveAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the startAngle in the object.
    obj->data->SetStartAngle(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
RevolveAttributes_GetStartAngle(PyObject *self, PyObject *args)
{
    RevolveAttributesObject *obj = (RevolveAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetStartAngle());
    return retval;
}

static PyObject *
RevolveAttributes_SetStopAngle(PyObject *self, PyObject *args)
{
    RevolveAttributesObject *obj = (RevolveAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the stopAngle in the object.
    obj->data->SetStopAngle(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
RevolveAttributes_GetStopAngle(PyObject *self, PyObject *args)
{
    RevolveAttributesObject *obj = (RevolveAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetStopAngle());
    return retval;
}

static PyObject *
RevolveAttributes_SetSteps(PyObject *self, PyObject *args)
{
    RevolveAttributesObject *obj = (RevolveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the steps in the object.
    obj->data->SetSteps(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
RevolveAttributes_GetSteps(PyObject *self, PyObject *args)
{
    RevolveAttributesObject *obj = (RevolveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSteps()));
    return retval;
}



static struct PyMethodDef RevolveAttributes_methods[] = {
    {"Notify", RevolveAttributes_Notify, METH_VARARGS},
    {"SetAxis", RevolveAttributes_SetAxis, METH_VARARGS},
    {"GetAxis", RevolveAttributes_GetAxis, METH_VARARGS},
    {"SetStartAngle", RevolveAttributes_SetStartAngle, METH_VARARGS},
    {"GetStartAngle", RevolveAttributes_GetStartAngle, METH_VARARGS},
    {"SetStopAngle", RevolveAttributes_SetStopAngle, METH_VARARGS},
    {"GetStopAngle", RevolveAttributes_GetStopAngle, METH_VARARGS},
    {"SetSteps", RevolveAttributes_SetSteps, METH_VARARGS},
    {"GetSteps", RevolveAttributes_GetSteps, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
RevolveAttributes_dealloc(PyObject *v)
{
   RevolveAttributesObject *obj = (RevolveAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
RevolveAttributes_compare(PyObject *v, PyObject *w)
{
    RevolveAttributes *a = ((RevolveAttributesObject *)v)->data;
    RevolveAttributes *b = ((RevolveAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
RevolveAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "axis") == 0)
        return RevolveAttributes_GetAxis(self, NULL);
    if(strcmp(name, "startAngle") == 0)
        return RevolveAttributes_GetStartAngle(self, NULL);
    if(strcmp(name, "stopAngle") == 0)
        return RevolveAttributes_GetStopAngle(self, NULL);
    if(strcmp(name, "steps") == 0)
        return RevolveAttributes_GetSteps(self, NULL);

    return Py_FindMethod(RevolveAttributes_methods, self, name);
}

static int
RevolveAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "axis") == 0)
        retval = (RevolveAttributes_SetAxis(self, tuple) != NULL);
    else if(strcmp(name, "startAngle") == 0)
        retval = (RevolveAttributes_SetStartAngle(self, tuple) != NULL);
    else if(strcmp(name, "stopAngle") == 0)
        retval = (RevolveAttributes_SetStopAngle(self, tuple) != NULL);
    else if(strcmp(name, "steps") == 0)
        retval = (RevolveAttributes_SetSteps(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
RevolveAttributes_print(PyObject *v, FILE *fp, int flags)
{
    RevolveAttributesObject *obj = (RevolveAttributesObject *)v;

    {   const double *axis = obj->data->GetAxis();
        fprintf(fp, "axis = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", axis[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    fprintf(fp, "startAngle = %g\n", obj->data->GetStartAngle());
    fprintf(fp, "stopAngle = %g\n", obj->data->GetStopAngle());
    fprintf(fp, "steps = %d\n", obj->data->GetSteps());

    return 0;
}

//
// The doc string for the class.
//
static char *RevolveAttributes_Purpose = "This class contains attributes for the revolve operator.";

//
// The type description structure
//
static PyTypeObject RevolveAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "RevolveAttributes",                    // tp_name
    sizeof(RevolveAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)RevolveAttributes_dealloc,  // tp_dealloc
    (printfunc)RevolveAttributes_print,     // tp_print
    (getattrfunc)RevolveAttributes_getattr, // tp_getattr
    (setattrfunc)RevolveAttributes_setattr, // tp_setattr
    (cmpfunc)RevolveAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    0,                                   // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    RevolveAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static RevolveAttributes *defaultAtts = 0;

static PyObject *
NewRevolveAttributes()
{
    RevolveAttributesObject *newObject;
    newObject = PyObject_NEW(RevolveAttributesObject, &RevolveAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new RevolveAttributes(*defaultAtts);
    else
        newObject->data = new RevolveAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapRevolveAttributes(const RevolveAttributes *attr)
{
    RevolveAttributesObject *newObject;
    newObject = PyObject_NEW(RevolveAttributesObject, &RevolveAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (RevolveAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
RevolveAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewRevolveAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef RevolveAttributesMethods[] = {
    {"RevolveAttributes", RevolveAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *RevolveAttributesObserver = 0;
static bool RevolveAttributesEnableLogging = true;

static void
PyRevolveAttributes_WriteLog(Subject *subj, void *data)
{
    RevolveAttributes *atts = (RevolveAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!RevolveAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# RevolveAttributes_WriteLog()\n");
}

void
PyRevolveAttributes_StartUp(RevolveAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyRevolveAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(RevolveAttributesObserver == 0)
    {
        RevolveAttributesObserver = new ObserverToCallback(subj,
            PyRevolveAttributes_WriteLog, (void *)logFile);
    }

    RevolveAttributesEnableLogging = true;
}

void
PyRevolveAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete RevolveAttributesObserver;
    RevolveAttributesObserver = 0;
}

PyMethodDef *
PyRevolveAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return RevolveAttributesMethods;
}

bool
PyRevolveAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &RevolveAttributesType);
}

RevolveAttributes *
PyRevolveAttributes_FromPyObject(PyObject *obj)
{
    RevolveAttributesObject *obj2 = (RevolveAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyRevolveAttributes_NewPyObject()
{
    return NewRevolveAttributes();
}

PyObject *
PyRevolveAttributes_WrapPyObject(const RevolveAttributes *attr)
{
    return WrapRevolveAttributes(attr);
}

void
PyRevolveAttributes_SetLogging(bool val)
{
    RevolveAttributesEnableLogging = val;
}

void
PyRevolveAttributes_SetDefaults(const RevolveAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new RevolveAttributes(*atts);
}

