// ************************************************************************* //
//  File: avtResamplePluginFilter.C
// ************************************************************************* //

#include <avtResamplePluginFilter.h>

#include <avtResampleFilter.h>
#include <ResampleAttributes.h>

// ****************************************************************************
//  Method: avtResamplePluginFilter constructor
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sat Jan 29 10:17:24 PDT 2005
//
// ****************************************************************************

avtResamplePluginFilter::avtResamplePluginFilter()
{
    resampler = NULL;
}


// ****************************************************************************
//  Method: avtResamplePluginFilter destructor
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sat Jan 29 10:17:24 PDT 2005
//
//  Modifications:
//
// ****************************************************************************

avtResamplePluginFilter::~avtResamplePluginFilter()
{
    if (resampler != NULL)
    {
        delete resampler;
        resampler = NULL;
    }
}


// ****************************************************************************
//  Method:  avtResamplePluginFilter::Create
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sat Jan 29 10:17:24 PDT 2005
//
// ****************************************************************************

avtFilter *
avtResamplePluginFilter::Create()
{
    return new avtResamplePluginFilter();
}


// ****************************************************************************
//  Method:      avtResamplePluginFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sat Jan 29 10:17:24 PDT 2005
//
// ****************************************************************************

void
avtResamplePluginFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const ResamplePluginAttributes*)a;

    //
    // Construct a new resample filter based on these attributes.
    //
    if (resampler != NULL)
    {
        delete resampler;
    }

    ResampleAttributes res_atts;
    res_atts.SetDefaultVal(atts.GetDefaultValue());
    res_atts.SetUseTargetVal(false);
    res_atts.SetWidth(atts.GetSamplesX());
    res_atts.SetHeight(atts.GetSamplesY());
    if (atts.GetIs3D())
        res_atts.SetDepth(atts.GetSamplesZ());
    else
        res_atts.SetDepth(1);
    res_atts.SetUseBounds(true);
    res_atts.SetMinX(atts.GetStartX());
    res_atts.SetMaxX(atts.GetEndX());
    res_atts.SetMinY(atts.GetStartY());
    res_atts.SetMaxY(atts.GetEndY());
    if (atts.GetIs3D())
    {
        res_atts.SetMinZ(atts.GetStartZ());
        res_atts.SetMaxZ(atts.GetEndZ());
    }
    else
    {
        res_atts.SetMinZ(0);
        res_atts.SetMaxZ(0);
    }

    res_atts.SetUseArbitrator(atts.GetTieResolver() 
                           != ResamplePluginAttributes::random);
    res_atts.SetArbitratorLessThan(atts.GetTieResolver() 
                                   != ResamplePluginAttributes::smallest);
    res_atts.SetArbitratorVarName(atts.GetTieResolverVariable());
    
    resampler = new avtResampleFilter(&res_atts);
}


// ****************************************************************************
//  Method: avtResamplePluginFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtResamplePluginFilter with the given
//      parameters would result in an equivalent avtResamplePluginFilter.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sat Jan 29 10:17:24 PDT 2005
//
// ****************************************************************************

bool
avtResamplePluginFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(ResamplePluginAttributes*)a);
}


// ****************************************************************************
//  Method: avtResamplePluginFilter::GetFacadedFilter
//
//  Purpose:
//      Gets the filter that the filter that we are a facade of.
//
//  Programmer: Hank Childs
//  Creation:   January 29, 2005
//
// ****************************************************************************

avtFilter *
avtResamplePluginFilter::GetFacadedFilter(void)
{
    return resampler;
}


