// ************************************************************************* //
//  File: ResampleViewerPluginInfo.C
// ************************************************************************* //

#include <ResamplePluginInfo.h>
#include <ResamplePluginAttributes.h>

#if defined(__APPLE__)
#define GetViewerInfo Resample_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Resample operator.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Sat Jan 29 19:46:18 PST 2005
//
// ****************************************************************************
extern "C" ViewerOperatorPluginInfo* GetViewerInfo()
{
    ResampleViewerPluginInfo::InitializeGlobalObjects();
    return new ResampleViewerPluginInfo;
}

//
// Storage for static data elements.
//
ResamplePluginAttributes *ResampleViewerPluginInfo::clientAtts = NULL;
ResamplePluginAttributes *ResampleViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  ResampleViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Sat Jan 29 19:46:18 PST 2005
//
// ****************************************************************************
void
ResampleViewerPluginInfo::InitializeGlobalObjects()
{
    ResampleViewerPluginInfo::clientAtts  = new ResamplePluginAttributes;
    ResampleViewerPluginInfo::defaultAtts = new ResamplePluginAttributes;
}

// ****************************************************************************
//  Method: ResampleViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Sat Jan 29 19:46:18 PST 2005
//
// ****************************************************************************

AttributeSubject *
ResampleViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: ResampleViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Sat Jan 29 19:46:18 PST 2005
//
// ****************************************************************************

AttributeSubject *
ResampleViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: ResampleViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Sat Jan 29 19:46:18 PST 2005
//
// ****************************************************************************

void
ResampleViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(ResamplePluginAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: ResampleViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Sat Jan 29 19:46:18 PST 2005
//
// ****************************************************************************

void
ResampleViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(ResamplePluginAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: ResampleViewerPluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    md        The metadata used to initialize.
//    atts      The variable name used to initialize.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Sat Jan 29 19:46:18 PST 2005
//
// ****************************************************************************

void
ResampleViewerPluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const ViewerPlot *plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(ResamplePluginAttributes*)atts = *defaultAtts;
    else
        *(ResamplePluginAttributes*)atts = *clientAtts;
}
