// ************************************************************************* //
//                        ResampleScriptingPluginInfo.C
// ************************************************************************* //
#include <ResamplePluginInfo.h>
#include <PyResamplePluginAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo Resample_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the Resample plot.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Sat Jan 29 19:46:18 PST 2005
//
// ****************************************************************************
extern "C" ScriptingOperatorPluginInfo* GetScriptingInfo()
{
    return new ResampleScriptingPluginInfo;
}

// ****************************************************************************
// Method: ResampleScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Sat Jan 29 19:46:18 PST 2005
//
// Modifications:
//   
// ****************************************************************************

void
ResampleScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyResamplePluginAttributes_StartUp((ResamplePluginAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: ResampleScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Sat Jan 29 19:46:18 PST 2005
//
// Modifications:
//   
// ****************************************************************************

void *
ResampleScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyResamplePluginAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: ResampleScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is Resample plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Sat Jan 29 19:46:18 PST 2005
//
// Modifications:
//   
// ****************************************************************************

bool
ResampleScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyResamplePluginAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: ResampleScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Sat Jan 29 19:46:18 PST 2005
//
// Modifications:
//   
// ****************************************************************************

void
ResampleScriptingPluginInfo::SetLogging(bool val)
{
    PyResamplePluginAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: ResampleScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Sat Jan 29 19:46:18 PST 2005
//
// Modifications:
//   
// ****************************************************************************

void
ResampleScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyResamplePluginAttributes_SetDefaults((const ResamplePluginAttributes *)atts);
}
