// ************************************************************************* //
//  File: ResamplePluginInfo.h
// ************************************************************************* //

#ifndef RESAMPLE_PLUGIN_INFO_H
#define RESAMPLE_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class ResamplePluginAttributes;

// ****************************************************************************
//  Class: ResamplePluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an Resample operator
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Sat Jan 29 19:46:18 PST 2005
//
//  Modifications:
//
// ****************************************************************************

class ResampleGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
    virtual bool  EnabledByDefault() const;
};

class ResampleCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual ResampleGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class ResampleGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual ResampleCommonPluginInfo
{
  public:
    virtual const char *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, QvisNotepadArea *notepad);
};

class ResampleViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual ResampleCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const ViewerPlot *plot,
                                        const bool fromDefault);

    static void InitializeGlobalObjects();
  private:
    static ResamplePluginAttributes *defaultAtts;
    static ResamplePluginAttributes *clientAtts;
};

class ResampleEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual ResampleCommonPluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class ResampleScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual ResampleCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, FILE *log);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual void SetLogging(bool val);
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
