package llnl.visit.operators;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;

// ****************************************************************************
// Class: ResamplePluginAttributes
//
// Purpose:
//    Atts for Resample operator
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Sat Jan 29 19:46:19 PST 2005
//
// Modifications:
//   
// ****************************************************************************

public class ResamplePluginAttributes extends AttributeSubject implements Plugin
{
    // Enum values
    public final static int TIERESOLVER_RANDOM = 0;
    public final static int TIERESOLVER_LARGEST = 1;
    public final static int TIERESOLVER_SMALLEST = 2;


    public ResamplePluginAttributes()
    {
        super(13);

        startX = 0;
        endX = 1;
        samplesX = 10;
        startY = 0;
        endY = 1;
        samplesY = 10;
        is3D = true;
        startZ = 0;
        endZ = 1;
        samplesZ = 10;
        tieResolver = TIERESOLVER_RANDOM;
        tieResolverVariable = new String("default");
        defaultValue = 0;
    }

    public ResamplePluginAttributes(ResamplePluginAttributes obj)
    {
        super(13);

        startX = obj.startX;
        endX = obj.endX;
        samplesX = obj.samplesX;
        startY = obj.startY;
        endY = obj.endY;
        samplesY = obj.samplesY;
        is3D = obj.is3D;
        startZ = obj.startZ;
        endZ = obj.endZ;
        samplesZ = obj.samplesZ;
        tieResolver = obj.tieResolver;
        tieResolverVariable = new String(obj.tieResolverVariable);
        defaultValue = obj.defaultValue;

        SelectAll();
    }

    public boolean equals(ResamplePluginAttributes obj)
    {
        // Create the return value
        return ((startX == obj.startX) &&
                (endX == obj.endX) &&
                (samplesX == obj.samplesX) &&
                (startY == obj.startY) &&
                (endY == obj.endY) &&
                (samplesY == obj.samplesY) &&
                (is3D == obj.is3D) &&
                (startZ == obj.startZ) &&
                (endZ == obj.endZ) &&
                (samplesZ == obj.samplesZ) &&
                (tieResolver == obj.tieResolver) &&
                (tieResolverVariable == obj.tieResolverVariable) &&
                (defaultValue == obj.defaultValue));
    }

    public String GetName() { return "Resample"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetStartX(double startX_)
    {
        startX = startX_;
        Select(0);
    }

    public void SetEndX(double endX_)
    {
        endX = endX_;
        Select(1);
    }

    public void SetSamplesX(int samplesX_)
    {
        samplesX = samplesX_;
        Select(2);
    }

    public void SetStartY(double startY_)
    {
        startY = startY_;
        Select(3);
    }

    public void SetEndY(double endY_)
    {
        endY = endY_;
        Select(4);
    }

    public void SetSamplesY(int samplesY_)
    {
        samplesY = samplesY_;
        Select(5);
    }

    public void SetIs3D(boolean is3D_)
    {
        is3D = is3D_;
        Select(6);
    }

    public void SetStartZ(double startZ_)
    {
        startZ = startZ_;
        Select(7);
    }

    public void SetEndZ(double endZ_)
    {
        endZ = endZ_;
        Select(8);
    }

    public void SetSamplesZ(int samplesZ_)
    {
        samplesZ = samplesZ_;
        Select(9);
    }

    public void SetTieResolver(int tieResolver_)
    {
        tieResolver = tieResolver_;
        Select(10);
    }

    public void SetTieResolverVariable(String tieResolverVariable_)
    {
        tieResolverVariable = tieResolverVariable_;
        Select(11);
    }

    public void SetDefaultValue(double defaultValue_)
    {
        defaultValue = defaultValue_;
        Select(12);
    }

    // Property getting methods
    public double  GetStartX() { return startX; }
    public double  GetEndX() { return endX; }
    public int     GetSamplesX() { return samplesX; }
    public double  GetStartY() { return startY; }
    public double  GetEndY() { return endY; }
    public int     GetSamplesY() { return samplesY; }
    public boolean GetIs3D() { return is3D; }
    public double  GetStartZ() { return startZ; }
    public double  GetEndZ() { return endZ; }
    public int     GetSamplesZ() { return samplesZ; }
    public int     GetTieResolver() { return tieResolver; }
    public String  GetTieResolverVariable() { return tieResolverVariable; }
    public double  GetDefaultValue() { return defaultValue; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteDouble(startX);
        if(WriteSelect(1, buf))
            buf.WriteDouble(endX);
        if(WriteSelect(2, buf))
            buf.WriteInt(samplesX);
        if(WriteSelect(3, buf))
            buf.WriteDouble(startY);
        if(WriteSelect(4, buf))
            buf.WriteDouble(endY);
        if(WriteSelect(5, buf))
            buf.WriteInt(samplesY);
        if(WriteSelect(6, buf))
            buf.WriteBool(is3D);
        if(WriteSelect(7, buf))
            buf.WriteDouble(startZ);
        if(WriteSelect(8, buf))
            buf.WriteDouble(endZ);
        if(WriteSelect(9, buf))
            buf.WriteInt(samplesZ);
        if(WriteSelect(10, buf))
            buf.WriteInt(tieResolver);
        if(WriteSelect(11, buf))
            buf.WriteString(tieResolverVariable);
        if(WriteSelect(12, buf))
            buf.WriteDouble(defaultValue);
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        for(int i = 0; i < n; ++i)
        {
            int index = (int)buf.ReadByte();
            switch(index)
            {
            case 0:
                SetStartX(buf.ReadDouble());
                break;
            case 1:
                SetEndX(buf.ReadDouble());
                break;
            case 2:
                SetSamplesX(buf.ReadInt());
                break;
            case 3:
                SetStartY(buf.ReadDouble());
                break;
            case 4:
                SetEndY(buf.ReadDouble());
                break;
            case 5:
                SetSamplesY(buf.ReadInt());
                break;
            case 6:
                SetIs3D(buf.ReadBool());
                break;
            case 7:
                SetStartZ(buf.ReadDouble());
                break;
            case 8:
                SetEndZ(buf.ReadDouble());
                break;
            case 9:
                SetSamplesZ(buf.ReadInt());
                break;
            case 10:
                SetTieResolver(buf.ReadInt());
                break;
            case 11:
                SetTieResolverVariable(buf.ReadString());
                break;
            case 12:
                SetDefaultValue(buf.ReadDouble());
                break;
            }
        }
    }


    // Attributes
    private double  startX;
    private double  endX;
    private int     samplesX;
    private double  startY;
    private double  endY;
    private int     samplesY;
    private boolean is3D;
    private double  startZ;
    private double  endZ;
    private int     samplesZ;
    private int     tieResolver;
    private String  tieResolverVariable;
    private double  defaultValue;
}

