#ifndef RESAMPLEPLUGINATTRIBUTES_H
#define RESAMPLEPLUGINATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>

// ****************************************************************************
// Class: ResamplePluginAttributes
//
// Purpose:
//    Atts for Resample operator
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Sat Jan 29 19:46:18 PST 2005
//
// Modifications:
//   
// ****************************************************************************

class ResamplePluginAttributes : public AttributeSubject
{
public:
    enum TieResolver
    {
        random,
        largest,
        smallest
    };

    ResamplePluginAttributes();
    ResamplePluginAttributes(const ResamplePluginAttributes &obj);
    virtual ~ResamplePluginAttributes();

    virtual ResamplePluginAttributes& operator = (const ResamplePluginAttributes &obj);
    virtual bool operator == (const ResamplePluginAttributes &obj) const;
    virtual bool operator != (const ResamplePluginAttributes &obj) const;

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectTieResolverVariable();

    // Property setting methods
    void SetStartX(double startX_);
    void SetEndX(double endX_);
    void SetSamplesX(int samplesX_);
    void SetStartY(double startY_);
    void SetEndY(double endY_);
    void SetSamplesY(int samplesY_);
    void SetIs3D(bool is3D_);
    void SetStartZ(double startZ_);
    void SetEndZ(double endZ_);
    void SetSamplesZ(int samplesZ_);
    void SetTieResolver(TieResolver tieResolver_);
    void SetTieResolverVariable(const std::string &tieResolverVariable_);
    void SetDefaultValue(double defaultValue_);

    // Property getting methods
    double            GetStartX() const;
    double            GetEndX() const;
    int               GetSamplesX() const;
    double            GetStartY() const;
    double            GetEndY() const;
    int               GetSamplesY() const;
    bool              GetIs3D() const;
    double            GetStartZ() const;
    double            GetEndZ() const;
    int               GetSamplesZ() const;
    TieResolver       GetTieResolver() const;
    const std::string &GetTieResolverVariable() const;
          std::string &GetTieResolverVariable();
    double            GetDefaultValue() const;

    // Enum conversion functions
    static std::string TieResolver_ToString(TieResolver);
    static bool TieResolver_FromString(const std::string &, TieResolver &);
protected:
    static std::string TieResolver_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

private:
    double      startX;
    double      endX;
    int         samplesX;
    double      startY;
    double      endY;
    int         samplesY;
    bool        is3D;
    double      startZ;
    double      endZ;
    int         samplesZ;
    int         tieResolver;
    std::string tieResolverVariable;
    double      defaultValue;
};

#endif
