#include <ResamplePluginAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for ResamplePluginAttributes::TieResolver
//

static const char *TieResolver_strings[] = {
"random", "largest", "smallest"
};

std::string
ResamplePluginAttributes::TieResolver_ToString(ResamplePluginAttributes::TieResolver t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return TieResolver_strings[index];
}

std::string
ResamplePluginAttributes::TieResolver_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return TieResolver_strings[index];
}

bool
ResamplePluginAttributes::TieResolver_FromString(const std::string &s, ResamplePluginAttributes::TieResolver &val)
{
    val = ResamplePluginAttributes::random;
    for(int i = 0; i < 3; ++i)
    {
        if(s == TieResolver_strings[i])
        {
            val = (TieResolver)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: ResamplePluginAttributes::ResamplePluginAttributes
//
// Purpose: 
//   Constructor for the ResamplePluginAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Sat Jan 29 19:46:18 PST 2005
//
// Modifications:
//   
// ****************************************************************************

ResamplePluginAttributes::ResamplePluginAttributes() : AttributeSubject("ddiddibddiisd"),
    tieResolverVariable("default")
{
    startX = 0;
    endX = 1;
    samplesX = 10;
    startY = 0;
    endY = 1;
    samplesY = 10;
    is3D = true;
    startZ = 0;
    endZ = 1;
    samplesZ = 10;
    tieResolver = random;
    defaultValue = 0;
}

// ****************************************************************************
// Method: ResamplePluginAttributes::ResamplePluginAttributes
//
// Purpose: 
//   Copy constructor for the ResamplePluginAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Sat Jan 29 19:46:18 PST 2005
//
// Modifications:
//   
// ****************************************************************************

ResamplePluginAttributes::ResamplePluginAttributes(const ResamplePluginAttributes &obj) : AttributeSubject("ddiddibddiisd")
{
    startX = obj.startX;
    endX = obj.endX;
    samplesX = obj.samplesX;
    startY = obj.startY;
    endY = obj.endY;
    samplesY = obj.samplesY;
    is3D = obj.is3D;
    startZ = obj.startZ;
    endZ = obj.endZ;
    samplesZ = obj.samplesZ;
    tieResolver = obj.tieResolver;
    tieResolverVariable = obj.tieResolverVariable;
    defaultValue = obj.defaultValue;

    SelectAll();
}

// ****************************************************************************
// Method: ResamplePluginAttributes::~ResamplePluginAttributes
//
// Purpose: 
//   Destructor for the ResamplePluginAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Sat Jan 29 19:46:18 PST 2005
//
// Modifications:
//   
// ****************************************************************************

ResamplePluginAttributes::~ResamplePluginAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: ResamplePluginAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the ResamplePluginAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Sat Jan 29 19:46:18 PST 2005
//
// Modifications:
//   
// ****************************************************************************

ResamplePluginAttributes& 
ResamplePluginAttributes::operator = (const ResamplePluginAttributes &obj)
{
    if (this == &obj) return *this;
    startX = obj.startX;
    endX = obj.endX;
    samplesX = obj.samplesX;
    startY = obj.startY;
    endY = obj.endY;
    samplesY = obj.samplesY;
    is3D = obj.is3D;
    startZ = obj.startZ;
    endZ = obj.endZ;
    samplesZ = obj.samplesZ;
    tieResolver = obj.tieResolver;
    tieResolverVariable = obj.tieResolverVariable;
    defaultValue = obj.defaultValue;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: ResamplePluginAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the ResamplePluginAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Sat Jan 29 19:46:18 PST 2005
//
// Modifications:
//   
// ****************************************************************************

bool
ResamplePluginAttributes::operator == (const ResamplePluginAttributes &obj) const
{
    // Create the return value
    return ((startX == obj.startX) &&
            (endX == obj.endX) &&
            (samplesX == obj.samplesX) &&
            (startY == obj.startY) &&
            (endY == obj.endY) &&
            (samplesY == obj.samplesY) &&
            (is3D == obj.is3D) &&
            (startZ == obj.startZ) &&
            (endZ == obj.endZ) &&
            (samplesZ == obj.samplesZ) &&
            (tieResolver == obj.tieResolver) &&
            (tieResolverVariable == obj.tieResolverVariable) &&
            (defaultValue == obj.defaultValue));
}

// ****************************************************************************
// Method: ResamplePluginAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the ResamplePluginAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Sat Jan 29 19:46:18 PST 2005
//
// Modifications:
//   
// ****************************************************************************

bool
ResamplePluginAttributes::operator != (const ResamplePluginAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ResamplePluginAttributes::TypeName
//
// Purpose: 
//   Type name method for the ResamplePluginAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Sat Jan 29 19:46:18 PST 2005
//
// Modifications:
//   
// ****************************************************************************

const std::string
ResamplePluginAttributes::TypeName() const
{
    return "ResamplePluginAttributes";
}

// ****************************************************************************
// Method: ResamplePluginAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ResamplePluginAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Sat Jan 29 19:46:18 PST 2005
//
// Modifications:
//   
// ****************************************************************************

bool
ResamplePluginAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ResamplePluginAttributes *tmp = (const ResamplePluginAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ResamplePluginAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ResamplePluginAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Sat Jan 29 19:46:18 PST 2005
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ResamplePluginAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ResamplePluginAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: ResamplePluginAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the ResamplePluginAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Sat Jan 29 19:46:18 PST 2005
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ResamplePluginAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ResamplePluginAttributes(*this);
    else
        retval = new ResamplePluginAttributes;

    return retval;
}

// ****************************************************************************
// Method: ResamplePluginAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Sat Jan 29 19:46:18 PST 2005
//
// Modifications:
//   
// ****************************************************************************

void
ResamplePluginAttributes::SelectAll()
{
    Select(0, (void *)&startX);
    Select(1, (void *)&endX);
    Select(2, (void *)&samplesX);
    Select(3, (void *)&startY);
    Select(4, (void *)&endY);
    Select(5, (void *)&samplesY);
    Select(6, (void *)&is3D);
    Select(7, (void *)&startZ);
    Select(8, (void *)&endZ);
    Select(9, (void *)&samplesZ);
    Select(10, (void *)&tieResolver);
    Select(11, (void *)&tieResolverVariable);
    Select(12, (void *)&defaultValue);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ResamplePluginAttributes::SetStartX(double startX_)
{
    startX = startX_;
    Select(0, (void *)&startX);
}

void
ResamplePluginAttributes::SetEndX(double endX_)
{
    endX = endX_;
    Select(1, (void *)&endX);
}

void
ResamplePluginAttributes::SetSamplesX(int samplesX_)
{
    samplesX = samplesX_;
    Select(2, (void *)&samplesX);
}

void
ResamplePluginAttributes::SetStartY(double startY_)
{
    startY = startY_;
    Select(3, (void *)&startY);
}

void
ResamplePluginAttributes::SetEndY(double endY_)
{
    endY = endY_;
    Select(4, (void *)&endY);
}

void
ResamplePluginAttributes::SetSamplesY(int samplesY_)
{
    samplesY = samplesY_;
    Select(5, (void *)&samplesY);
}

void
ResamplePluginAttributes::SetIs3D(bool is3D_)
{
    is3D = is3D_;
    Select(6, (void *)&is3D);
}

void
ResamplePluginAttributes::SetStartZ(double startZ_)
{
    startZ = startZ_;
    Select(7, (void *)&startZ);
}

void
ResamplePluginAttributes::SetEndZ(double endZ_)
{
    endZ = endZ_;
    Select(8, (void *)&endZ);
}

void
ResamplePluginAttributes::SetSamplesZ(int samplesZ_)
{
    samplesZ = samplesZ_;
    Select(9, (void *)&samplesZ);
}

void
ResamplePluginAttributes::SetTieResolver(ResamplePluginAttributes::TieResolver tieResolver_)
{
    tieResolver = tieResolver_;
    Select(10, (void *)&tieResolver);
}

void
ResamplePluginAttributes::SetTieResolverVariable(const std::string &tieResolverVariable_)
{
    tieResolverVariable = tieResolverVariable_;
    Select(11, (void *)&tieResolverVariable);
}

void
ResamplePluginAttributes::SetDefaultValue(double defaultValue_)
{
    defaultValue = defaultValue_;
    Select(12, (void *)&defaultValue);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

double
ResamplePluginAttributes::GetStartX() const
{
    return startX;
}

double
ResamplePluginAttributes::GetEndX() const
{
    return endX;
}

int
ResamplePluginAttributes::GetSamplesX() const
{
    return samplesX;
}

double
ResamplePluginAttributes::GetStartY() const
{
    return startY;
}

double
ResamplePluginAttributes::GetEndY() const
{
    return endY;
}

int
ResamplePluginAttributes::GetSamplesY() const
{
    return samplesY;
}

bool
ResamplePluginAttributes::GetIs3D() const
{
    return is3D;
}

double
ResamplePluginAttributes::GetStartZ() const
{
    return startZ;
}

double
ResamplePluginAttributes::GetEndZ() const
{
    return endZ;
}

int
ResamplePluginAttributes::GetSamplesZ() const
{
    return samplesZ;
}

ResamplePluginAttributes::TieResolver
ResamplePluginAttributes::GetTieResolver() const
{
    return TieResolver(tieResolver);
}

const std::string &
ResamplePluginAttributes::GetTieResolverVariable() const
{
    return tieResolverVariable;
}

std::string &
ResamplePluginAttributes::GetTieResolverVariable()
{
    return tieResolverVariable;
}

double
ResamplePluginAttributes::GetDefaultValue() const
{
    return defaultValue;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
ResamplePluginAttributes::SelectTieResolverVariable()
{
    Select(11, (void *)&tieResolverVariable);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ResamplePluginAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Sat Jan 29 19:46:18 PST 2005
//
// Modifications:
//   
// ****************************************************************************

std::string
ResamplePluginAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "Start X";
        case 1:  return "End X";
        case 2:  return "Samples in X";
        case 3:  return "Start Y";
        case 4:  return "End Y";
        case 5:  return "Samples in Y";
        case 6:  return "3D resampling";
        case 7:  return "Start Z";
        case 8:  return "End Z";
        case 9:  return "Samples in Z";
        case 10:  return "Resolve ties";
        case 11:  return "Variable to resolve ties";
        case 12:  return "Value for uncovered regions";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ResamplePluginAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Sat Jan 29 19:46:18 PST 2005
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ResamplePluginAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_double;
        case 1:  return FieldType_double;
        case 2:  return FieldType_int;
        case 3:  return FieldType_double;
        case 4:  return FieldType_double;
        case 5:  return FieldType_int;
        case 6:  return FieldType_bool;
        case 7:  return FieldType_double;
        case 8:  return FieldType_double;
        case 9:  return FieldType_int;
        case 10:  return FieldType_enum;
        case 11:  return FieldType_variablename;
        case 12:  return FieldType_double;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ResamplePluginAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Sat Jan 29 19:46:18 PST 2005
//
// Modifications:
//   
// ****************************************************************************

std::string
ResamplePluginAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "double";
        case 1:  return "double";
        case 2:  return "int";
        case 3:  return "double";
        case 4:  return "double";
        case 5:  return "int";
        case 6:  return "bool";
        case 7:  return "double";
        case 8:  return "double";
        case 9:  return "int";
        case 10:  return "enum";
        case 11:  return "variablename";
        case 12:  return "double";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ResamplePluginAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Sat Jan 29 19:46:18 PST 2005
//
// Modifications:
//   
// ****************************************************************************

bool
ResamplePluginAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const ResamplePluginAttributes &obj = *((const ResamplePluginAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (startX == obj.startX);
        }
        break;
    case 1:
        {  // new scope
        retval = (endX == obj.endX);
        }
        break;
    case 2:
        {  // new scope
        retval = (samplesX == obj.samplesX);
        }
        break;
    case 3:
        {  // new scope
        retval = (startY == obj.startY);
        }
        break;
    case 4:
        {  // new scope
        retval = (endY == obj.endY);
        }
        break;
    case 5:
        {  // new scope
        retval = (samplesY == obj.samplesY);
        }
        break;
    case 6:
        {  // new scope
        retval = (is3D == obj.is3D);
        }
        break;
    case 7:
        {  // new scope
        retval = (startZ == obj.startZ);
        }
        break;
    case 8:
        {  // new scope
        retval = (endZ == obj.endZ);
        }
        break;
    case 9:
        {  // new scope
        retval = (samplesZ == obj.samplesZ);
        }
        break;
    case 10:
        {  // new scope
        retval = (tieResolver == obj.tieResolver);
        }
        break;
    case 11:
        {  // new scope
        retval = (tieResolverVariable == obj.tieResolverVariable);
        }
        break;
    case 12:
        {  // new scope
        retval = (defaultValue == obj.defaultValue);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

