// ************************************************************************* //
//  File: ResampleGUIPluginInfo.C
// ************************************************************************* //

#include <ResamplePluginInfo.h>
#include <ResamplePluginAttributes.h>
#include <QvisResampleWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo Resample_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the Resample operator.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Sat Jan 29 19:46:18 PST 2005
//
// ****************************************************************************
extern "C" GUIOperatorPluginInfo* GetGUIInfo()
{
    return new ResampleGUIPluginInfo;
}

// ****************************************************************************
//  Method: ResampleGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Sat Jan 29 19:46:18 PST 2005
//
// ****************************************************************************

const char *
ResampleGUIPluginInfo::GetMenuName() const
{
    return "Resample";
}


// ****************************************************************************
//  Method: ResampleGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Sat Jan 29 19:46:18 PST 2005
//
// ****************************************************************************

QvisPostableWindowObserver *
ResampleGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisResampleWindow(type, (ResamplePluginAttributes *)attr,
        "Resample operator attributes", "Resample operator", notepad);
}
