#include <PyResamplePluginAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyResamplePluginAttributes
//
// Purpose: 
//   Atts for Resample operator
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Sat Jan 29 19:46:19 PST 2005
//
// ****************************************************************************

//
// This struct contains the Python type information and a ResamplePluginAttributes.
//
struct ResamplePluginAttributesObject
{
    PyObject_HEAD
    ResamplePluginAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewResamplePluginAttributes();

static PyObject *
ResamplePluginAttributes_Notify(PyObject *self, PyObject *args)
{
    ResamplePluginAttributesObject *obj = (ResamplePluginAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ResamplePluginAttributes_SetStartX(PyObject *self, PyObject *args)
{
    ResamplePluginAttributesObject *obj = (ResamplePluginAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the startX in the object.
    obj->data->SetStartX(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ResamplePluginAttributes_GetStartX(PyObject *self, PyObject *args)
{
    ResamplePluginAttributesObject *obj = (ResamplePluginAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetStartX());
    return retval;
}

static PyObject *
ResamplePluginAttributes_SetEndX(PyObject *self, PyObject *args)
{
    ResamplePluginAttributesObject *obj = (ResamplePluginAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the endX in the object.
    obj->data->SetEndX(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ResamplePluginAttributes_GetEndX(PyObject *self, PyObject *args)
{
    ResamplePluginAttributesObject *obj = (ResamplePluginAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetEndX());
    return retval;
}

static PyObject *
ResamplePluginAttributes_SetSamplesX(PyObject *self, PyObject *args)
{
    ResamplePluginAttributesObject *obj = (ResamplePluginAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the samplesX in the object.
    obj->data->SetSamplesX(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ResamplePluginAttributes_GetSamplesX(PyObject *self, PyObject *args)
{
    ResamplePluginAttributesObject *obj = (ResamplePluginAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSamplesX()));
    return retval;
}

static PyObject *
ResamplePluginAttributes_SetStartY(PyObject *self, PyObject *args)
{
    ResamplePluginAttributesObject *obj = (ResamplePluginAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the startY in the object.
    obj->data->SetStartY(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ResamplePluginAttributes_GetStartY(PyObject *self, PyObject *args)
{
    ResamplePluginAttributesObject *obj = (ResamplePluginAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetStartY());
    return retval;
}

static PyObject *
ResamplePluginAttributes_SetEndY(PyObject *self, PyObject *args)
{
    ResamplePluginAttributesObject *obj = (ResamplePluginAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the endY in the object.
    obj->data->SetEndY(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ResamplePluginAttributes_GetEndY(PyObject *self, PyObject *args)
{
    ResamplePluginAttributesObject *obj = (ResamplePluginAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetEndY());
    return retval;
}

static PyObject *
ResamplePluginAttributes_SetSamplesY(PyObject *self, PyObject *args)
{
    ResamplePluginAttributesObject *obj = (ResamplePluginAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the samplesY in the object.
    obj->data->SetSamplesY(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ResamplePluginAttributes_GetSamplesY(PyObject *self, PyObject *args)
{
    ResamplePluginAttributesObject *obj = (ResamplePluginAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSamplesY()));
    return retval;
}

static PyObject *
ResamplePluginAttributes_SetIs3D(PyObject *self, PyObject *args)
{
    ResamplePluginAttributesObject *obj = (ResamplePluginAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the is3D in the object.
    obj->data->SetIs3D(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ResamplePluginAttributes_GetIs3D(PyObject *self, PyObject *args)
{
    ResamplePluginAttributesObject *obj = (ResamplePluginAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIs3D()?1L:0L);
    return retval;
}

static PyObject *
ResamplePluginAttributes_SetStartZ(PyObject *self, PyObject *args)
{
    ResamplePluginAttributesObject *obj = (ResamplePluginAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the startZ in the object.
    obj->data->SetStartZ(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ResamplePluginAttributes_GetStartZ(PyObject *self, PyObject *args)
{
    ResamplePluginAttributesObject *obj = (ResamplePluginAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetStartZ());
    return retval;
}

static PyObject *
ResamplePluginAttributes_SetEndZ(PyObject *self, PyObject *args)
{
    ResamplePluginAttributesObject *obj = (ResamplePluginAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the endZ in the object.
    obj->data->SetEndZ(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ResamplePluginAttributes_GetEndZ(PyObject *self, PyObject *args)
{
    ResamplePluginAttributesObject *obj = (ResamplePluginAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetEndZ());
    return retval;
}

static PyObject *
ResamplePluginAttributes_SetSamplesZ(PyObject *self, PyObject *args)
{
    ResamplePluginAttributesObject *obj = (ResamplePluginAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the samplesZ in the object.
    obj->data->SetSamplesZ(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ResamplePluginAttributes_GetSamplesZ(PyObject *self, PyObject *args)
{
    ResamplePluginAttributesObject *obj = (ResamplePluginAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSamplesZ()));
    return retval;
}

static PyObject *
ResamplePluginAttributes_SetTieResolver(PyObject *self, PyObject *args)
{
    ResamplePluginAttributesObject *obj = (ResamplePluginAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the tieResolver in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetTieResolver(ResamplePluginAttributes::TieResolver(ival));
    else
    {
        fprintf(stderr, "An invalid tieResolver value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "random, largest, smallest.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ResamplePluginAttributes_GetTieResolver(PyObject *self, PyObject *args)
{
    ResamplePluginAttributesObject *obj = (ResamplePluginAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTieResolver()));
    return retval;
}

static PyObject *
ResamplePluginAttributes_SetTieResolverVariable(PyObject *self, PyObject *args)
{
    ResamplePluginAttributesObject *obj = (ResamplePluginAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the tieResolverVariable in the object.
    obj->data->SetTieResolverVariable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ResamplePluginAttributes_GetTieResolverVariable(PyObject *self, PyObject *args)
{
    ResamplePluginAttributesObject *obj = (ResamplePluginAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetTieResolverVariable().c_str());
    return retval;
}

static PyObject *
ResamplePluginAttributes_SetDefaultValue(PyObject *self, PyObject *args)
{
    ResamplePluginAttributesObject *obj = (ResamplePluginAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the defaultValue in the object.
    obj->data->SetDefaultValue(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ResamplePluginAttributes_GetDefaultValue(PyObject *self, PyObject *args)
{
    ResamplePluginAttributesObject *obj = (ResamplePluginAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetDefaultValue());
    return retval;
}



static struct PyMethodDef ResamplePluginAttributes_methods[] = {
    {"Notify", ResamplePluginAttributes_Notify, METH_VARARGS},
    {"SetStartX", ResamplePluginAttributes_SetStartX, METH_VARARGS},
    {"GetStartX", ResamplePluginAttributes_GetStartX, METH_VARARGS},
    {"SetEndX", ResamplePluginAttributes_SetEndX, METH_VARARGS},
    {"GetEndX", ResamplePluginAttributes_GetEndX, METH_VARARGS},
    {"SetSamplesX", ResamplePluginAttributes_SetSamplesX, METH_VARARGS},
    {"GetSamplesX", ResamplePluginAttributes_GetSamplesX, METH_VARARGS},
    {"SetStartY", ResamplePluginAttributes_SetStartY, METH_VARARGS},
    {"GetStartY", ResamplePluginAttributes_GetStartY, METH_VARARGS},
    {"SetEndY", ResamplePluginAttributes_SetEndY, METH_VARARGS},
    {"GetEndY", ResamplePluginAttributes_GetEndY, METH_VARARGS},
    {"SetSamplesY", ResamplePluginAttributes_SetSamplesY, METH_VARARGS},
    {"GetSamplesY", ResamplePluginAttributes_GetSamplesY, METH_VARARGS},
    {"SetIs3D", ResamplePluginAttributes_SetIs3D, METH_VARARGS},
    {"GetIs3D", ResamplePluginAttributes_GetIs3D, METH_VARARGS},
    {"SetStartZ", ResamplePluginAttributes_SetStartZ, METH_VARARGS},
    {"GetStartZ", ResamplePluginAttributes_GetStartZ, METH_VARARGS},
    {"SetEndZ", ResamplePluginAttributes_SetEndZ, METH_VARARGS},
    {"GetEndZ", ResamplePluginAttributes_GetEndZ, METH_VARARGS},
    {"SetSamplesZ", ResamplePluginAttributes_SetSamplesZ, METH_VARARGS},
    {"GetSamplesZ", ResamplePluginAttributes_GetSamplesZ, METH_VARARGS},
    {"SetTieResolver", ResamplePluginAttributes_SetTieResolver, METH_VARARGS},
    {"GetTieResolver", ResamplePluginAttributes_GetTieResolver, METH_VARARGS},
    {"SetTieResolverVariable", ResamplePluginAttributes_SetTieResolverVariable, METH_VARARGS},
    {"GetTieResolverVariable", ResamplePluginAttributes_GetTieResolverVariable, METH_VARARGS},
    {"SetDefaultValue", ResamplePluginAttributes_SetDefaultValue, METH_VARARGS},
    {"GetDefaultValue", ResamplePluginAttributes_GetDefaultValue, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ResamplePluginAttributes_dealloc(PyObject *v)
{
   ResamplePluginAttributesObject *obj = (ResamplePluginAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
ResamplePluginAttributes_compare(PyObject *v, PyObject *w)
{
    ResamplePluginAttributes *a = ((ResamplePluginAttributesObject *)v)->data;
    ResamplePluginAttributes *b = ((ResamplePluginAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
ResamplePluginAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "startX") == 0)
        return ResamplePluginAttributes_GetStartX(self, NULL);
    if(strcmp(name, "endX") == 0)
        return ResamplePluginAttributes_GetEndX(self, NULL);
    if(strcmp(name, "samplesX") == 0)
        return ResamplePluginAttributes_GetSamplesX(self, NULL);
    if(strcmp(name, "startY") == 0)
        return ResamplePluginAttributes_GetStartY(self, NULL);
    if(strcmp(name, "endY") == 0)
        return ResamplePluginAttributes_GetEndY(self, NULL);
    if(strcmp(name, "samplesY") == 0)
        return ResamplePluginAttributes_GetSamplesY(self, NULL);
    if(strcmp(name, "is3D") == 0)
        return ResamplePluginAttributes_GetIs3D(self, NULL);
    if(strcmp(name, "startZ") == 0)
        return ResamplePluginAttributes_GetStartZ(self, NULL);
    if(strcmp(name, "endZ") == 0)
        return ResamplePluginAttributes_GetEndZ(self, NULL);
    if(strcmp(name, "samplesZ") == 0)
        return ResamplePluginAttributes_GetSamplesZ(self, NULL);
    if(strcmp(name, "tieResolver") == 0)
        return ResamplePluginAttributes_GetTieResolver(self, NULL);
    if(strcmp(name, "random") == 0)
        return PyInt_FromLong(long(ResamplePluginAttributes::random));
    else if(strcmp(name, "largest") == 0)
        return PyInt_FromLong(long(ResamplePluginAttributes::largest));
    else if(strcmp(name, "smallest") == 0)
        return PyInt_FromLong(long(ResamplePluginAttributes::smallest));

    if(strcmp(name, "tieResolverVariable") == 0)
        return ResamplePluginAttributes_GetTieResolverVariable(self, NULL);
    if(strcmp(name, "defaultValue") == 0)
        return ResamplePluginAttributes_GetDefaultValue(self, NULL);

    return Py_FindMethod(ResamplePluginAttributes_methods, self, name);
}

static int
ResamplePluginAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "startX") == 0)
        retval = (ResamplePluginAttributes_SetStartX(self, tuple) != NULL);
    else if(strcmp(name, "endX") == 0)
        retval = (ResamplePluginAttributes_SetEndX(self, tuple) != NULL);
    else if(strcmp(name, "samplesX") == 0)
        retval = (ResamplePluginAttributes_SetSamplesX(self, tuple) != NULL);
    else if(strcmp(name, "startY") == 0)
        retval = (ResamplePluginAttributes_SetStartY(self, tuple) != NULL);
    else if(strcmp(name, "endY") == 0)
        retval = (ResamplePluginAttributes_SetEndY(self, tuple) != NULL);
    else if(strcmp(name, "samplesY") == 0)
        retval = (ResamplePluginAttributes_SetSamplesY(self, tuple) != NULL);
    else if(strcmp(name, "is3D") == 0)
        retval = (ResamplePluginAttributes_SetIs3D(self, tuple) != NULL);
    else if(strcmp(name, "startZ") == 0)
        retval = (ResamplePluginAttributes_SetStartZ(self, tuple) != NULL);
    else if(strcmp(name, "endZ") == 0)
        retval = (ResamplePluginAttributes_SetEndZ(self, tuple) != NULL);
    else if(strcmp(name, "samplesZ") == 0)
        retval = (ResamplePluginAttributes_SetSamplesZ(self, tuple) != NULL);
    else if(strcmp(name, "tieResolver") == 0)
        retval = (ResamplePluginAttributes_SetTieResolver(self, tuple) != NULL);
    else if(strcmp(name, "tieResolverVariable") == 0)
        retval = (ResamplePluginAttributes_SetTieResolverVariable(self, tuple) != NULL);
    else if(strcmp(name, "defaultValue") == 0)
        retval = (ResamplePluginAttributes_SetDefaultValue(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
ResamplePluginAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ResamplePluginAttributesObject *obj = (ResamplePluginAttributesObject *)v;

    fprintf(fp, "startX = %g\n", obj->data->GetStartX());
    fprintf(fp, "endX = %g\n", obj->data->GetEndX());
    fprintf(fp, "samplesX = %d\n", obj->data->GetSamplesX());
    fprintf(fp, "startY = %g\n", obj->data->GetStartY());
    fprintf(fp, "endY = %g\n", obj->data->GetEndY());
    fprintf(fp, "samplesY = %d\n", obj->data->GetSamplesY());
    if(obj->data->GetIs3D())
        fprintf(fp, "is3D = 1\n");
    else
        fprintf(fp, "is3D = 0\n");
    fprintf(fp, "startZ = %g\n", obj->data->GetStartZ());
    fprintf(fp, "endZ = %g\n", obj->data->GetEndZ());
    fprintf(fp, "samplesZ = %d\n", obj->data->GetSamplesZ());
    const char *tieResolver_names = "random, largest, smallest";
    if(obj->data->GetTieResolver() == ResamplePluginAttributes::random)
        fprintf(fp, "tieResolver = random  # %s\n", tieResolver_names);
    else if(obj->data->GetTieResolver() == ResamplePluginAttributes::largest)
        fprintf(fp, "tieResolver = largest  # %s\n", tieResolver_names);
    else
        fprintf(fp, "tieResolver = smallest  # %s\n", tieResolver_names);

    fprintf(fp, "tieResolverVariable = \"%s\"\n", obj->data->GetTieResolverVariable().c_str());
    fprintf(fp, "defaultValue = %g\n", obj->data->GetDefaultValue());

    return 0;
}

#include <snprintf.h>
PyObject *
PyResamplePluginAttributes_StringRepresentation(const ResamplePluginAttributes *atts)
{
   std::string str; 
   char tmpStr[1000]; 

    SNPRINTF(tmpStr, 1000, "startX = %g\n", atts->GetStartX());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "endX = %g\n", atts->GetEndX());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "samplesX = %d\n", atts->GetSamplesX());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "startY = %g\n", atts->GetStartY());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "endY = %g\n", atts->GetEndY());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "samplesY = %d\n", atts->GetSamplesY());
    str += tmpStr;
    if(atts->GetIs3D())
        SNPRINTF(tmpStr, 1000, "is3D = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "is3D = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "startZ = %g\n", atts->GetStartZ());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "endZ = %g\n", atts->GetEndZ());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "samplesZ = %d\n", atts->GetSamplesZ());
    str += tmpStr;
    const char *tieResolver_names = "random, largest, smallest";
    if(atts->GetTieResolver() == ResamplePluginAttributes::random)
        {
             SNPRINTF(tmpStr, 1000, "tieResolver = random  # %s\n", tieResolver_names);
             str += tmpStr;
        }
    else if(atts->GetTieResolver() == ResamplePluginAttributes::largest)
        {
             SNPRINTF(tmpStr, 1000, "tieResolver = largest  # %s\n", tieResolver_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "tieResolver = smallest  # %s\n", tieResolver_names);
             str += tmpStr;
        }

   SNPRINTF(tmpStr, 1000, "tieResolverVariable = \"%s\"\n", atts->GetTieResolverVariable().c_str());
   str += tmpStr;
    SNPRINTF(tmpStr, 1000, "defaultValue = %g\n", atts->GetDefaultValue());
    str += tmpStr;
    return PyString_FromString(str.c_str());
}

static PyObject *
ResamplePluginAttributes_str(PyObject *v)
{
    ResamplePluginAttributesObject *obj = (ResamplePluginAttributesObject *)v;
    return PyResamplePluginAttributes_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
static char *ResamplePluginAttributes_Purpose = "Atts for Resample operator";

//
// The type description structure
//
static PyTypeObject ResamplePluginAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ResamplePluginAttributes",                    // tp_name
    sizeof(ResamplePluginAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ResamplePluginAttributes_dealloc,  // tp_dealloc
    (printfunc)ResamplePluginAttributes_print,     // tp_print
    (getattrfunc)ResamplePluginAttributes_getattr, // tp_getattr
    (setattrfunc)ResamplePluginAttributes_setattr, // tp_setattr
    (cmpfunc)ResamplePluginAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ResamplePluginAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ResamplePluginAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ResamplePluginAttributes *defaultAtts = 0;

static PyObject *
NewResamplePluginAttributes()
{
    ResamplePluginAttributesObject *newObject;
    newObject = PyObject_NEW(ResamplePluginAttributesObject, &ResamplePluginAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new ResamplePluginAttributes(*defaultAtts);
    else
        newObject->data = new ResamplePluginAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapResamplePluginAttributes(const ResamplePluginAttributes *attr)
{
    ResamplePluginAttributesObject *newObject;
    newObject = PyObject_NEW(ResamplePluginAttributesObject, &ResamplePluginAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ResamplePluginAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ResamplePluginAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewResamplePluginAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ResamplePluginAttributesMethods[] = {
    {"ResamplePluginAttributes", ResamplePluginAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ResamplePluginAttributesObserver = 0;
static bool ResamplePluginAttributesEnableLogging = true;

static void
PyResamplePluginAttributes_WriteLog(Subject *subj, void *data)
{
    ResamplePluginAttributes *atts = (ResamplePluginAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!ResamplePluginAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# ResamplePluginAttributes_WriteLog()\n");
}

void
PyResamplePluginAttributes_StartUp(ResamplePluginAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyResamplePluginAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ResamplePluginAttributesObserver == 0)
    {
        ResamplePluginAttributesObserver = new ObserverToCallback(subj,
            PyResamplePluginAttributes_WriteLog, (void *)logFile);
    }

    ResamplePluginAttributesEnableLogging = true;
}

void
PyResamplePluginAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ResamplePluginAttributesObserver;
    ResamplePluginAttributesObserver = 0;
}

PyMethodDef *
PyResamplePluginAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ResamplePluginAttributesMethods;
}

bool
PyResamplePluginAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ResamplePluginAttributesType);
}

ResamplePluginAttributes *
PyResamplePluginAttributes_FromPyObject(PyObject *obj)
{
    ResamplePluginAttributesObject *obj2 = (ResamplePluginAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyResamplePluginAttributes_NewPyObject()
{
    return NewResamplePluginAttributes();
}

PyObject *
PyResamplePluginAttributes_WrapPyObject(const ResamplePluginAttributes *attr)
{
    return WrapResamplePluginAttributes(attr);
}

void
PyResamplePluginAttributes_SetLogging(bool val)
{
    ResamplePluginAttributesEnableLogging = val;
}

void
PyResamplePluginAttributes_SetDefaults(const ResamplePluginAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ResamplePluginAttributes(*atts);
}

