// ************************************************************************* //
//  File: RemoveCellsGUIPluginInfo.C
// ************************************************************************* //

#include <RemoveCellsPluginInfo.h>
#include <RemoveCellsAttributes.h>
#include <QvisRemoveCellsWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo Makefile_GetGUIInfo
#endif

#if defined(__APPLE__)
#define GetGUIInfo RemoveCells_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the RemoveCells operator.
//
//  Programmer: haddox1 -- generated by xml2info
//  Creation:   Mon Jul 21 09:53:49 PDT 2003
//
// ****************************************************************************
extern "C" GUIOperatorPluginInfo* GetGUIInfo()
{
    return new RemoveCellsGUIPluginInfo;
}

// ****************************************************************************
//  Method: RemoveCellsGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: haddox1 -- generated by xml2info
//  Creation:   Mon Jul 21 09:53:49 PDT 2003
//
// ****************************************************************************

const char *
RemoveCellsGUIPluginInfo::GetMenuName() const
{
    return "RemoveCells";
}


// ****************************************************************************
//  Method: RemoveCellsGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: haddox1 -- generated by xml2info
//  Creation:   Mon Jul 21 09:53:49 PDT 2003
//
// ****************************************************************************

QvisPostableWindowObserver *
RemoveCellsGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisRemoveCellsWindow(type, (RemoveCellsAttributes *)attr,
        "RemoveCells operator attributes", "RemoveCells operator", notepad);
}

// ****************************************************************************
//  Method: RemoveCellsGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: haddox1 -- generated by xml2info
//  Creation:   Mon Jul 21 09:53:49 PDT 2003
//
// ****************************************************************************

#include <RemoveCells.xpm>
const char **
RemoveCellsGUIPluginInfo::XPMIconData() const
{
    return RemoveCells_xpm;
}
