package llnl.visit.operators;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;
import java.lang.Integer;
import java.util.Vector;

// ****************************************************************************
// Class: RemoveCellsAttributes
//
// Purpose:
//    This class contains attributes for the RemoveCells operator.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Thu Jul 31 16:09:22 PST 2003
//
// Modifications:
//   
// ****************************************************************************

public class RemoveCellsAttributes extends AttributeSubject implements Plugin
{
    public RemoveCellsAttributes()
    {
        super(4);

        cell = 0;
        domain = 0;
        cellList = new Vector();
        domainList = new Vector();
    }

    public RemoveCellsAttributes(RemoveCellsAttributes obj)
    {
        super(4);

        int i;

        cell = obj.cell;
        domain = obj.domain;
        cellList = new Vector();
        for(i = 0; i < obj.cellList.size(); ++i)
        {
            Integer iv = (Integer)obj.cellList.elementAt(i);
            cellList.addElement(new Integer(iv.intValue()));
        }
        domainList = new Vector();
        for(i = 0; i < obj.domainList.size(); ++i)
        {
            Integer iv = (Integer)obj.domainList.elementAt(i);
            domainList.addElement(new Integer(iv.intValue()));
        }

        SelectAll();
    }

    public boolean equals(RemoveCellsAttributes obj)
    {
        int i;

        // Create the return value
        return ((cell == obj.cell) &&
                (domain == obj.domain) &&
                (cellList == obj.cellList) &&
                (domainList == obj.domainList));
    }

    public String GetName() { return "RemoveCells"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetCell(int cell_)
    {
        cell = cell_;
        Select(0);
    }

    public void SetDomain(int domain_)
    {
        domain = domain_;
        Select(1);
    }

    public void SetCellList(Vector cellList_)
    {
        cellList = cellList_;
        Select(2);
    }

    public void SetDomainList(Vector domainList_)
    {
        domainList = domainList_;
        Select(3);
    }

    // Property getting methods
    public int    GetCell() { return cell; }
    public int    GetDomain() { return domain; }
    public Vector GetCellList() { return cellList; }
    public Vector GetDomainList() { return domainList; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteInt(cell);
        if(WriteSelect(1, buf))
            buf.WriteInt(domain);
        if(WriteSelect(2, buf))
            buf.WriteIntVector(cellList);
        if(WriteSelect(3, buf))
            buf.WriteIntVector(domainList);
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        for(int i = 0; i < n; ++i)
        {
            int index = (int)buf.ReadByte();
            switch(index)
            {
            case 0:
                SetCell(buf.ReadInt());
                break;
            case 1:
                SetDomain(buf.ReadInt());
                break;
            case 2:
                SetCellList(buf.ReadIntVector());
                break;
            case 3:
                SetDomainList(buf.ReadIntVector());
                break;
            }
        }
    }


    // Attributes
    private int    cell;
    private int    domain;
    private Vector cellList; // vector of Integer objects
    private Vector domainList; // vector of Integer objects
}

