#include <PyRemoveCellsAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyRemoveCellsAttributes
//
// Purpose: 
//   This class contains attributes for the RemoveCells operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Mon Jul 21 09:53:51 PDT 2003
//
// ****************************************************************************

//
// This struct contains the Python type information and a RemoveCellsAttributes.
//
struct RemoveCellsAttributesObject
{
    PyObject_HEAD
    RemoveCellsAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewRemoveCellsAttributes();

static PyObject *
RemoveCellsAttributes_Notify(PyObject *self, PyObject *args)
{
    RemoveCellsAttributesObject *obj = (RemoveCellsAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
RemoveCellsAttributes_SetCell(PyObject *self, PyObject *args)
{
    RemoveCellsAttributesObject *obj = (RemoveCellsAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the cell in the object.
    obj->data->SetCell(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
RemoveCellsAttributes_GetCell(PyObject *self, PyObject *args)
{
    RemoveCellsAttributesObject *obj = (RemoveCellsAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetCell()));
    return retval;
}

static PyObject *
RemoveCellsAttributes_SetDomain(PyObject *self, PyObject *args)
{
    RemoveCellsAttributesObject *obj = (RemoveCellsAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the domain in the object.
    obj->data->SetDomain(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
RemoveCellsAttributes_GetDomain(PyObject *self, PyObject *args)
{
    RemoveCellsAttributesObject *obj = (RemoveCellsAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDomain()));
    return retval;
}

static PyObject *
RemoveCellsAttributes_SetCellList(PyObject *self, PyObject *args)
{
    RemoveCellsAttributesObject *obj = (RemoveCellsAttributesObject *)self;

    intVector  &vec = obj->data->GetCellList();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the cellList in the object as modified.
    obj->data->SelectCellList();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
RemoveCellsAttributes_GetCellList(PyObject *self, PyObject *args)
{
    RemoveCellsAttributesObject *obj = (RemoveCellsAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the cellList.
    const intVector &cellList = obj->data->GetCellList();
    PyObject *retval = PyTuple_New(cellList.size());
    for(int i = 0; i < cellList.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(cellList[i])));
    return retval;
}

static PyObject *
RemoveCellsAttributes_SetDomainList(PyObject *self, PyObject *args)
{
    RemoveCellsAttributesObject *obj = (RemoveCellsAttributesObject *)self;

    intVector  &vec = obj->data->GetDomainList();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the domainList in the object as modified.
    obj->data->SelectDomainList();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
RemoveCellsAttributes_GetDomainList(PyObject *self, PyObject *args)
{
    RemoveCellsAttributesObject *obj = (RemoveCellsAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the domainList.
    const intVector &domainList = obj->data->GetDomainList();
    PyObject *retval = PyTuple_New(domainList.size());
    for(int i = 0; i < domainList.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(domainList[i])));
    return retval;
}



static struct PyMethodDef RemoveCellsAttributes_methods[] = {
    {"Notify", RemoveCellsAttributes_Notify, METH_VARARGS},
    {"SetCell", RemoveCellsAttributes_SetCell, METH_VARARGS},
    {"GetCell", RemoveCellsAttributes_GetCell, METH_VARARGS},
    {"SetDomain", RemoveCellsAttributes_SetDomain, METH_VARARGS},
    {"GetDomain", RemoveCellsAttributes_GetDomain, METH_VARARGS},
    {"SetCellList", RemoveCellsAttributes_SetCellList, METH_VARARGS},
    {"GetCellList", RemoveCellsAttributes_GetCellList, METH_VARARGS},
    {"SetDomainList", RemoveCellsAttributes_SetDomainList, METH_VARARGS},
    {"GetDomainList", RemoveCellsAttributes_GetDomainList, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
RemoveCellsAttributes_dealloc(PyObject *v)
{
   RemoveCellsAttributesObject *obj = (RemoveCellsAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
RemoveCellsAttributes_compare(PyObject *v, PyObject *w)
{
    RemoveCellsAttributes *a = ((RemoveCellsAttributesObject *)v)->data;
    RemoveCellsAttributes *b = ((RemoveCellsAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
RemoveCellsAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "cell") == 0)
        return RemoveCellsAttributes_GetCell(self, NULL);
    if(strcmp(name, "domain") == 0)
        return RemoveCellsAttributes_GetDomain(self, NULL);
    if(strcmp(name, "cellList") == 0)
        return RemoveCellsAttributes_GetCellList(self, NULL);
    if(strcmp(name, "domainList") == 0)
        return RemoveCellsAttributes_GetDomainList(self, NULL);

    return Py_FindMethod(RemoveCellsAttributes_methods, self, name);
}

static int
RemoveCellsAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "cell") == 0)
        retval = (RemoveCellsAttributes_SetCell(self, tuple) != NULL);
    else if(strcmp(name, "domain") == 0)
        retval = (RemoveCellsAttributes_SetDomain(self, tuple) != NULL);
    else if(strcmp(name, "cellList") == 0)
        retval = (RemoveCellsAttributes_SetCellList(self, tuple) != NULL);
    else if(strcmp(name, "domainList") == 0)
        retval = (RemoveCellsAttributes_SetDomainList(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
RemoveCellsAttributes_print(PyObject *v, FILE *fp, int flags)
{
    RemoveCellsAttributesObject *obj = (RemoveCellsAttributesObject *)v;

    fprintf(fp, "cell = %d\n", obj->data->GetCell());
    fprintf(fp, "domain = %d\n", obj->data->GetDomain());
    {   const intVector &cellList = obj->data->GetCellList();
        fprintf(fp, "cellList = (");
        for(int i = 0; i < cellList.size(); ++i)
        {
            fprintf(fp, "%d", cellList[i]);
            if(i < cellList.size() - 1)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    {   const intVector &domainList = obj->data->GetDomainList();
        fprintf(fp, "domainList = (");
        for(int i = 0; i < domainList.size(); ++i)
        {
            fprintf(fp, "%d", domainList[i]);
            if(i < domainList.size() - 1)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }

    return 0;
}

//
// The doc string for the class.
//
static char *RemoveCellsAttributes_Purpose = "This class contains attributes for the RemoveCells operator.";

//
// The type description structure
//
static PyTypeObject RemoveCellsAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "RemoveCellsAttributes",                    // tp_name
    sizeof(RemoveCellsAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)RemoveCellsAttributes_dealloc,  // tp_dealloc
    (printfunc)RemoveCellsAttributes_print,     // tp_print
    (getattrfunc)RemoveCellsAttributes_getattr, // tp_getattr
    (setattrfunc)RemoveCellsAttributes_setattr, // tp_setattr
    (cmpfunc)RemoveCellsAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    0,                                   // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    RemoveCellsAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static RemoveCellsAttributes *defaultAtts = 0;

static PyObject *
NewRemoveCellsAttributes()
{
    RemoveCellsAttributesObject *newObject;
    newObject = PyObject_NEW(RemoveCellsAttributesObject, &RemoveCellsAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new RemoveCellsAttributes(*defaultAtts);
    else
        newObject->data = new RemoveCellsAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapRemoveCellsAttributes(const RemoveCellsAttributes *attr)
{
    RemoveCellsAttributesObject *newObject;
    newObject = PyObject_NEW(RemoveCellsAttributesObject, &RemoveCellsAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (RemoveCellsAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
RemoveCellsAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewRemoveCellsAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef RemoveCellsAttributesMethods[] = {
    {"RemoveCellsAttributes", RemoveCellsAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *RemoveCellsAttributesObserver = 0;
static bool RemoveCellsAttributesEnableLogging = true;

static void
PyRemoveCellsAttributes_WriteLog(Subject *subj, void *data)
{
    RemoveCellsAttributes *atts = (RemoveCellsAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!RemoveCellsAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# RemoveCellsAttributes_WriteLog()\n");
}

void
PyRemoveCellsAttributes_StartUp(RemoveCellsAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyRemoveCellsAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(RemoveCellsAttributesObserver == 0)
    {
        RemoveCellsAttributesObserver = new ObserverToCallback(subj,
            PyRemoveCellsAttributes_WriteLog, (void *)logFile);
    }

    RemoveCellsAttributesEnableLogging = true;
}

void
PyRemoveCellsAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete RemoveCellsAttributesObserver;
    RemoveCellsAttributesObserver = 0;
}

PyMethodDef *
PyRemoveCellsAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return RemoveCellsAttributesMethods;
}

bool
PyRemoveCellsAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &RemoveCellsAttributesType);
}

RemoveCellsAttributes *
PyRemoveCellsAttributes_FromPyObject(PyObject *obj)
{
    RemoveCellsAttributesObject *obj2 = (RemoveCellsAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyRemoveCellsAttributes_NewPyObject()
{
    return NewRemoveCellsAttributes();
}

PyObject *
PyRemoveCellsAttributes_WrapPyObject(const RemoveCellsAttributes *attr)
{
    return WrapRemoveCellsAttributes(attr);
}

void
PyRemoveCellsAttributes_SetLogging(bool val)
{
    RemoveCellsAttributesEnableLogging = val;
}

void
PyRemoveCellsAttributes_SetDefaults(const RemoveCellsAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new RemoveCellsAttributes(*atts);
}

