// ************************************************************************* //
//  File: ReflectViewerPluginInfo.C
// ************************************************************************* //

#include <ReflectPluginInfo.h>
#include <ReflectAttributes.h>

#if defined(__APPLE__)
#define GetViewerInfo Reflect_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Reflect operator.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:04:21 PST 2003
//
// ****************************************************************************
extern "C" ViewerOperatorPluginInfo* GetViewerInfo()
{
    ReflectViewerPluginInfo::InitializeGlobalObjects();
    return new ReflectViewerPluginInfo;
}

//
// Storage for static data elements.
//
ReflectAttributes *ReflectViewerPluginInfo::clientAtts = NULL;
ReflectAttributes *ReflectViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  ReflectViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:04:21 PST 2003
//
// ****************************************************************************
void
ReflectViewerPluginInfo::InitializeGlobalObjects()
{
    ReflectViewerPluginInfo::clientAtts  = new ReflectAttributes;
    ReflectViewerPluginInfo::defaultAtts = new ReflectAttributes;
}

// ****************************************************************************
//  Method: ReflectViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:04:21 PST 2003
//
// ****************************************************************************

AttributeSubject *
ReflectViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: ReflectViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:04:21 PST 2003
//
// ****************************************************************************

AttributeSubject *
ReflectViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: ReflectViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:04:21 PST 2003
//
// ****************************************************************************

void
ReflectViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(ReflectAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: ReflectViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:04:21 PST 2003
//
// ****************************************************************************

void
ReflectViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(ReflectAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: ReflectViewerPluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:04:21 PST 2003
//
// ****************************************************************************

void
ReflectViewerPluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const ViewerPlot *plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(ReflectAttributes*)atts = *defaultAtts;
    else
        *(ReflectAttributes*)atts = *clientAtts;
}

// ****************************************************************************
//  Method: ReflectViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:04:21 PST 2003
//
// ****************************************************************************

#include <Reflect.xpm>
const char **
ReflectViewerPluginInfo::XPMIconData() const
{
    return Reflect_xpm;
}
