// ************************************************************************* //
//                        ReflectScriptingPluginInfo.C
// ************************************************************************* //
#include <ReflectPluginInfo.h>
#include <PyReflectAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo Reflect_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the Reflect plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:36:58 PST 2002
//
// ****************************************************************************
extern "C" ScriptingOperatorPluginInfo* GetScriptingInfo()
{
    return new ReflectScriptingPluginInfo;
}

// ****************************************************************************
// Method: ReflectScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:36:58 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
ReflectScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyReflectAttributes_StartUp((ReflectAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: ReflectScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:36:58 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void *
ReflectScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyReflectAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: ReflectScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is Reflect plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:36:58 PST 2002
//
// Modifications:
//   
// ****************************************************************************

bool
ReflectScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyReflectAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: ReflectScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:36:58 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
ReflectScriptingPluginInfo::SetLogging(bool val)
{
    PyReflectAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: ReflectScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:36:58 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
ReflectScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyReflectAttributes_SetDefaults((const ReflectAttributes *)atts);
}
