// ************************************************************************* //
//  File: ReflectGUIPluginInfo.C
// ************************************************************************* //

#include <ReflectPluginInfo.h>
#include <ReflectAttributes.h>
#include <QvisReflectWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo Reflect_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the Reflect operator.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Thu Mar 13 13:46:47 PST 2003
//
// ****************************************************************************
extern "C" GUIOperatorPluginInfo* GetGUIInfo()
{
    return new ReflectGUIPluginInfo;
}

// ****************************************************************************
//  Method: ReflectGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Thu Mar 13 13:46:47 PST 2003
//
// ****************************************************************************

const char *
ReflectGUIPluginInfo::GetMenuName() const
{
    return "Reflect";
}


// ****************************************************************************
//  Method: ReflectGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Thu Mar 13 13:46:47 PST 2003
//
// ****************************************************************************

QvisPostableWindowObserver *
ReflectGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisReflectWindow(type, (ReflectAttributes *)attr,
        "Reflect operator attributes", "Reflect operator", notepad);
}

// ****************************************************************************
//  Method: ReflectGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Thu Mar 13 13:46:47 PST 2003
//
// ****************************************************************************

#include <Reflect.xpm>
const char **
ReflectGUIPluginInfo::XPMIconData() const
{
    return Reflect_xpm;
}
