#include <ReflectAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for ReflectAttributes::Octant
//

static const char *Octant_strings[] = {
"PXPYPZ", "NXPYPZ", "PXNYPZ", 
"NXNYPZ", "PXPYNZ", "NXPYNZ", 
"PXNYNZ", "NXNYNZ"};

std::string
ReflectAttributes::Octant_ToString(ReflectAttributes::Octant t)
{
    int index = int(t);
    if(index < 0 || index >= 8) index = 0;
    return Octant_strings[index];
}

std::string
ReflectAttributes::Octant_ToString(int t)
{
    int index = (t < 0 || t >= 8) ? 0 : t;
    return Octant_strings[index];
}

bool
ReflectAttributes::Octant_FromString(const std::string &s, ReflectAttributes::Octant &val)
{
    val = ReflectAttributes::PXPYPZ;
    for(int i = 0; i < 8; ++i)
    {
        if(s == Octant_strings[i])
        {
            val = (Octant)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: ReflectAttributes::ReflectAttributes
//
// Purpose: 
//   Constructor for the ReflectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:01 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

ReflectAttributes::ReflectAttributes() : AttributeSubject("ibdbdbdI")
{
    octant = PXPYPZ;
    useXBoundary = true;
    specifiedX = 0;
    useYBoundary = true;
    specifiedY = 0;
    useZBoundary = true;
    specifiedZ = 0;
    reflections[0] = 1;
    reflections[1] = 0;
    reflections[2] = 1;
    reflections[3] = 0;
    reflections[4] = 0;
    reflections[5] = 0;
    reflections[6] = 0;
    reflections[7] = 0;
}

// ****************************************************************************
// Method: ReflectAttributes::ReflectAttributes
//
// Purpose: 
//   Copy constructor for the ReflectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:01 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

ReflectAttributes::ReflectAttributes(const ReflectAttributes &obj) : AttributeSubject("ibdbdbdI")
{
    int i;

    octant = obj.octant;
    useXBoundary = obj.useXBoundary;
    specifiedX = obj.specifiedX;
    useYBoundary = obj.useYBoundary;
    specifiedY = obj.specifiedY;
    useZBoundary = obj.useZBoundary;
    specifiedZ = obj.specifiedZ;
    for(i = 0; i < 8; ++i)
        reflections[i] = obj.reflections[i];


    SelectAll();
}

// ****************************************************************************
// Method: ReflectAttributes::~ReflectAttributes
//
// Purpose: 
//   Destructor for the ReflectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:01 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

ReflectAttributes::~ReflectAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: ReflectAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the ReflectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:01 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
ReflectAttributes::operator = (const ReflectAttributes &obj)
{
    int i;

    octant = obj.octant;
    useXBoundary = obj.useXBoundary;
    specifiedX = obj.specifiedX;
    useYBoundary = obj.useYBoundary;
    specifiedY = obj.specifiedY;
    useZBoundary = obj.useZBoundary;
    specifiedZ = obj.specifiedZ;
    for(i = 0; i < 8; ++i)
        reflections[i] = obj.reflections[i];


    SelectAll();
}

// ****************************************************************************
// Method: ReflectAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the ReflectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:01 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ReflectAttributes::operator == (const ReflectAttributes &obj) const
{
    int i;

    // Compare the reflections arrays.
    bool reflections_equal = true;
    for(i = 0; i < 8 && reflections_equal; ++i)
        reflections_equal = (reflections[i] == obj.reflections[i]);

    // Create the return value
    return ((octant == obj.octant) &&
            (useXBoundary == obj.useXBoundary) &&
            (specifiedX == obj.specifiedX) &&
            (useYBoundary == obj.useYBoundary) &&
            (specifiedY == obj.specifiedY) &&
            (useZBoundary == obj.useZBoundary) &&
            (specifiedZ == obj.specifiedZ) &&
            reflections_equal);
}

// ****************************************************************************
// Method: ReflectAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the ReflectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:01 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ReflectAttributes::operator != (const ReflectAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ReflectAttributes::TypeName
//
// Purpose: 
//   Type name method for the ReflectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:01 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const std::string
ReflectAttributes::TypeName() const
{
    return "ReflectAttributes";
}

// ****************************************************************************
// Method: ReflectAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ReflectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:01 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ReflectAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ReflectAttributes *tmp = (const ReflectAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ReflectAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ReflectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:01 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ReflectAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ReflectAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: ReflectAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the ReflectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:01 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ReflectAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ReflectAttributes(*this);
    else
        retval = new ReflectAttributes;

    return retval;
}

// ****************************************************************************
// Method: ReflectAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:01 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
ReflectAttributes::SelectAll()
{
    Select(0, (void *)&octant);
    Select(1, (void *)&useXBoundary);
    Select(2, (void *)&specifiedX);
    Select(3, (void *)&useYBoundary);
    Select(4, (void *)&specifiedY);
    Select(5, (void *)&useZBoundary);
    Select(6, (void *)&specifiedZ);
    Select(7, (void *)reflections, 8);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ReflectAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:01 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ReflectAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    ReflectAttributes defaultObject;
    bool addToParent = false;
    // Create a node for ReflectAttributes.
    DataNode *node = new DataNode("ReflectAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("octant", Octant_ToString(octant)));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("useXBoundary", useXBoundary));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("specifiedX", specifiedX));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("useYBoundary", useYBoundary));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("specifiedY", specifiedY));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("useZBoundary", useZBoundary));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("specifiedZ", specifiedZ));
    }

    if(completeSave || !FieldsEqual(7, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("reflections", reflections, 8));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: ReflectAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:01 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
ReflectAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("ReflectAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("octant")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 8)
                SetOctant(Octant(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Octant value;
            if(Octant_FromString(node->AsString(), value))
                SetOctant(value);
        }
    }
    if((node = searchNode->GetNode("useXBoundary")) != 0)
        SetUseXBoundary(node->AsBool());
    if((node = searchNode->GetNode("specifiedX")) != 0)
        SetSpecifiedX(node->AsDouble());
    if((node = searchNode->GetNode("useYBoundary")) != 0)
        SetUseYBoundary(node->AsBool());
    if((node = searchNode->GetNode("specifiedY")) != 0)
        SetSpecifiedY(node->AsDouble());
    if((node = searchNode->GetNode("useZBoundary")) != 0)
        SetUseZBoundary(node->AsBool());
    if((node = searchNode->GetNode("specifiedZ")) != 0)
        SetSpecifiedZ(node->AsDouble());
    if((node = searchNode->GetNode("reflections")) != 0)
        SetReflections(node->AsIntArray());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ReflectAttributes::SetOctant(ReflectAttributes::Octant octant_)
{
    octant = octant_;
    Select(0, (void *)&octant);
}

void
ReflectAttributes::SetUseXBoundary(bool useXBoundary_)
{
    useXBoundary = useXBoundary_;
    Select(1, (void *)&useXBoundary);
}

void
ReflectAttributes::SetSpecifiedX(double specifiedX_)
{
    specifiedX = specifiedX_;
    Select(2, (void *)&specifiedX);
}

void
ReflectAttributes::SetUseYBoundary(bool useYBoundary_)
{
    useYBoundary = useYBoundary_;
    Select(3, (void *)&useYBoundary);
}

void
ReflectAttributes::SetSpecifiedY(double specifiedY_)
{
    specifiedY = specifiedY_;
    Select(4, (void *)&specifiedY);
}

void
ReflectAttributes::SetUseZBoundary(bool useZBoundary_)
{
    useZBoundary = useZBoundary_;
    Select(5, (void *)&useZBoundary);
}

void
ReflectAttributes::SetSpecifiedZ(double specifiedZ_)
{
    specifiedZ = specifiedZ_;
    Select(6, (void *)&specifiedZ);
}

void
ReflectAttributes::SetReflections(const int *reflections_)
{
    for(int i = 0; i < 8; ++i)
        reflections[i] = reflections_[i];
    Select(7, (void *)reflections, 8);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

ReflectAttributes::Octant
ReflectAttributes::GetOctant() const
{
    return Octant(octant);
}

bool
ReflectAttributes::GetUseXBoundary() const
{
    return useXBoundary;
}

double
ReflectAttributes::GetSpecifiedX() const
{
    return specifiedX;
}

bool
ReflectAttributes::GetUseYBoundary() const
{
    return useYBoundary;
}

double
ReflectAttributes::GetSpecifiedY() const
{
    return specifiedY;
}

bool
ReflectAttributes::GetUseZBoundary() const
{
    return useZBoundary;
}

double
ReflectAttributes::GetSpecifiedZ() const
{
    return specifiedZ;
}

const int *
ReflectAttributes::GetReflections() const
{
    return reflections;
}

int *
ReflectAttributes::GetReflections()
{
    return reflections;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
ReflectAttributes::SelectReflections()
{
    Select(7, (void *)reflections, 8);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ReflectAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:01 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
ReflectAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "octant";
        case 1:  return "useXBoundary";
        case 2:  return "specifiedX";
        case 3:  return "useYBoundary";
        case 4:  return "specifiedY";
        case 5:  return "useZBoundary";
        case 6:  return "specifiedZ";
        case 7:  return "reflections";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ReflectAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:01 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ReflectAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_enum;
        case 1:  return FieldType_bool;
        case 2:  return FieldType_double;
        case 3:  return FieldType_bool;
        case 4:  return FieldType_double;
        case 5:  return FieldType_bool;
        case 6:  return FieldType_double;
        case 7:  return FieldType_intArray;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ReflectAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:01 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
ReflectAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "enum";
        case 1:  return "bool";
        case 2:  return "double";
        case 3:  return "bool";
        case 4:  return "double";
        case 5:  return "bool";
        case 6:  return "double";
        case 7:  return "intArray";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ReflectAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:01 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ReflectAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    int i;

    const ReflectAttributes &obj = *((const ReflectAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (octant == obj.octant);
        }
        break;
    case 1:
        {  // new scope
        retval = (useXBoundary == obj.useXBoundary);
        }
        break;
    case 2:
        {  // new scope
        retval = (specifiedX == obj.specifiedX);
        }
        break;
    case 3:
        {  // new scope
        retval = (useYBoundary == obj.useYBoundary);
        }
        break;
    case 4:
        {  // new scope
        retval = (specifiedY == obj.specifiedY);
        }
        break;
    case 5:
        {  // new scope
        retval = (useZBoundary == obj.useZBoundary);
        }
        break;
    case 6:
        {  // new scope
        retval = (specifiedZ == obj.specifiedZ);
        }
        break;
    case 7:
        {  // new scope
        // Compare the reflections arrays.
        bool reflections_equal = true;
        for(i = 0; i < 8 && reflections_equal; ++i)
            reflections_equal = (reflections[i] == obj.reflections[i]);

        retval = reflections_equal;
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ReflectAttributes::ProcessOldVersions
//
// Purpose:
//   Updates the config settings in the data node to the current Reflect
//   opertor version.
//
// Arguments:
//   parentNode    : The data node that stores the Reflect attributes.
//   configVersion : The version of the config file from which the node
//                   was read.
//
// Programmer: Brad Whitlock
// Creation:   Thu Apr 24 08:22:22 PDT 2003
//
// Modifications:
//
// ****************************************************************************

void
ReflectAttributes::ProcessOldVersions(DataNode *parentNode,
    const char *configVersion)
{
    if(parentNode == 0)
        return;

    DataNode *reflectNode = parentNode->GetNode("ReflectAttributes");
    if(reflectNode == 0)
        return;

    //
    // If the config file is less than version 1.1.4, update the default
    // reflections to the ones recommended by version 1.1.4.
    //
    if(VersionLessThan(configVersion, "1.1.4"))
    {
         DataNode *reflectionsNode = reflectNode->GetNode("reflections");
         reflectionsNode->SetIntArray(reflections, 8);
    }
}

