#include <PyReflectAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyReflectAttributes
//
// Purpose: 
//   This class contains attributes for the reflect operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Mon Dec 16 10:23:02 PDT 2002
//
// ****************************************************************************

//
// This struct contains the Python type information and a ReflectAttributes.
//
struct ReflectAttributesObject
{
    PyObject_HEAD
    ReflectAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewReflectAttributes();

static PyObject *
ReflectAttributes_Notify(PyObject *self, PyObject *args)
{
    ReflectAttributesObject *obj = (ReflectAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ReflectAttributes_SetOctant(PyObject *self, PyObject *args)
{
    ReflectAttributesObject *obj = (ReflectAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the octant in the object.
    if(ival >= 0 && ival < 8)
        obj->data->SetOctant(ReflectAttributes::Octant(ival));
    else
    {
        fprintf(stderr, "An invalid octant value was given. "
                        "Valid values are in the range of [0,7]. "
                        "You can also use the following names: "
                        "PXPYPZ, NXPYPZ, PXNYPZ, NXNYPZ, PXPYNZ, NXPYNZ, PXNYNZ, NXNYNZ.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ReflectAttributes_GetOctant(PyObject *self, PyObject *args)
{
    ReflectAttributesObject *obj = (ReflectAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOctant()));
    return retval;
}

static PyObject *
ReflectAttributes_SetUseXBoundary(PyObject *self, PyObject *args)
{
    ReflectAttributesObject *obj = (ReflectAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useXBoundary in the object.
    obj->data->SetUseXBoundary(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ReflectAttributes_GetUseXBoundary(PyObject *self, PyObject *args)
{
    ReflectAttributesObject *obj = (ReflectAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseXBoundary()?1L:0L);
    return retval;
}

static PyObject *
ReflectAttributes_SetSpecifiedX(PyObject *self, PyObject *args)
{
    ReflectAttributesObject *obj = (ReflectAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the specifiedX in the object.
    obj->data->SetSpecifiedX(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ReflectAttributes_GetSpecifiedX(PyObject *self, PyObject *args)
{
    ReflectAttributesObject *obj = (ReflectAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetSpecifiedX());
    return retval;
}

static PyObject *
ReflectAttributes_SetUseYBoundary(PyObject *self, PyObject *args)
{
    ReflectAttributesObject *obj = (ReflectAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useYBoundary in the object.
    obj->data->SetUseYBoundary(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ReflectAttributes_GetUseYBoundary(PyObject *self, PyObject *args)
{
    ReflectAttributesObject *obj = (ReflectAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseYBoundary()?1L:0L);
    return retval;
}

static PyObject *
ReflectAttributes_SetSpecifiedY(PyObject *self, PyObject *args)
{
    ReflectAttributesObject *obj = (ReflectAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the specifiedY in the object.
    obj->data->SetSpecifiedY(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ReflectAttributes_GetSpecifiedY(PyObject *self, PyObject *args)
{
    ReflectAttributesObject *obj = (ReflectAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetSpecifiedY());
    return retval;
}

static PyObject *
ReflectAttributes_SetUseZBoundary(PyObject *self, PyObject *args)
{
    ReflectAttributesObject *obj = (ReflectAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useZBoundary in the object.
    obj->data->SetUseZBoundary(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ReflectAttributes_GetUseZBoundary(PyObject *self, PyObject *args)
{
    ReflectAttributesObject *obj = (ReflectAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseZBoundary()?1L:0L);
    return retval;
}

static PyObject *
ReflectAttributes_SetSpecifiedZ(PyObject *self, PyObject *args)
{
    ReflectAttributesObject *obj = (ReflectAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the specifiedZ in the object.
    obj->data->SetSpecifiedZ(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ReflectAttributes_GetSpecifiedZ(PyObject *self, PyObject *args)
{
    ReflectAttributesObject *obj = (ReflectAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetSpecifiedZ());
    return retval;
}

static PyObject *
ReflectAttributes_SetReflections(PyObject *self, PyObject *args)
{
    ReflectAttributesObject *obj = (ReflectAttributesObject *)self;

    int *ivals = obj->data->GetReflections();
    if(!PyArg_ParseTuple(args, "iiiiiiii", &ivals[0], &ivals[1], &ivals[2], &ivals[3], &ivals[4], &ivals[5], &ivals[6], &ivals[7]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 8)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    ivals[i] = int(PyFloat_AS_DOUBLE(item));
                else if(PyInt_Check(item))
                    ivals[i] = int(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    ivals[i] = int(PyLong_AsDouble(item));
                else
                    ivals[i] = 0;
            }
        }
        else
            return NULL;
    }

    // Mark the reflections in the object as modified.
    obj->data->SelectReflections();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ReflectAttributes_GetReflections(PyObject *self, PyObject *args)
{
    ReflectAttributesObject *obj = (ReflectAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the reflections.
    PyObject *retval = PyTuple_New(8);
    const int *reflections = obj->data->GetReflections();
    for(int i = 0; i < 8; ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(reflections[i])));
    return retval;
}



static struct PyMethodDef ReflectAttributes_methods[] = {
    {"Notify", ReflectAttributes_Notify, METH_VARARGS},
    {"SetOctant", ReflectAttributes_SetOctant, METH_VARARGS},
    {"GetOctant", ReflectAttributes_GetOctant, METH_VARARGS},
    {"SetUseXBoundary", ReflectAttributes_SetUseXBoundary, METH_VARARGS},
    {"GetUseXBoundary", ReflectAttributes_GetUseXBoundary, METH_VARARGS},
    {"SetSpecifiedX", ReflectAttributes_SetSpecifiedX, METH_VARARGS},
    {"GetSpecifiedX", ReflectAttributes_GetSpecifiedX, METH_VARARGS},
    {"SetUseYBoundary", ReflectAttributes_SetUseYBoundary, METH_VARARGS},
    {"GetUseYBoundary", ReflectAttributes_GetUseYBoundary, METH_VARARGS},
    {"SetSpecifiedY", ReflectAttributes_SetSpecifiedY, METH_VARARGS},
    {"GetSpecifiedY", ReflectAttributes_GetSpecifiedY, METH_VARARGS},
    {"SetUseZBoundary", ReflectAttributes_SetUseZBoundary, METH_VARARGS},
    {"GetUseZBoundary", ReflectAttributes_GetUseZBoundary, METH_VARARGS},
    {"SetSpecifiedZ", ReflectAttributes_SetSpecifiedZ, METH_VARARGS},
    {"GetSpecifiedZ", ReflectAttributes_GetSpecifiedZ, METH_VARARGS},
    {"SetReflections", ReflectAttributes_SetReflections, METH_VARARGS},
    {"GetReflections", ReflectAttributes_GetReflections, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ReflectAttributes_dealloc(PyObject *v)
{
   ReflectAttributesObject *obj = (ReflectAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
ReflectAttributes_compare(PyObject *v, PyObject *w)
{
    ReflectAttributes *a = ((ReflectAttributesObject *)v)->data;
    ReflectAttributes *b = ((ReflectAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
ReflectAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "octant") == 0)
        return ReflectAttributes_GetOctant(self, NULL);
    if(strcmp(name, "PXPYPZ") == 0)
        return PyInt_FromLong(long(ReflectAttributes::PXPYPZ));
    else if(strcmp(name, "NXPYPZ") == 0)
        return PyInt_FromLong(long(ReflectAttributes::NXPYPZ));
    else if(strcmp(name, "PXNYPZ") == 0)
        return PyInt_FromLong(long(ReflectAttributes::PXNYPZ));
    else if(strcmp(name, "NXNYPZ") == 0)
        return PyInt_FromLong(long(ReflectAttributes::NXNYPZ));
    else if(strcmp(name, "PXPYNZ") == 0)
        return PyInt_FromLong(long(ReflectAttributes::PXPYNZ));
    else if(strcmp(name, "NXPYNZ") == 0)
        return PyInt_FromLong(long(ReflectAttributes::NXPYNZ));
    else if(strcmp(name, "PXNYNZ") == 0)
        return PyInt_FromLong(long(ReflectAttributes::PXNYNZ));
    else if(strcmp(name, "NXNYNZ") == 0)
        return PyInt_FromLong(long(ReflectAttributes::NXNYNZ));

    if(strcmp(name, "useXBoundary") == 0)
        return ReflectAttributes_GetUseXBoundary(self, NULL);
    if(strcmp(name, "specifiedX") == 0)
        return ReflectAttributes_GetSpecifiedX(self, NULL);
    if(strcmp(name, "useYBoundary") == 0)
        return ReflectAttributes_GetUseYBoundary(self, NULL);
    if(strcmp(name, "specifiedY") == 0)
        return ReflectAttributes_GetSpecifiedY(self, NULL);
    if(strcmp(name, "useZBoundary") == 0)
        return ReflectAttributes_GetUseZBoundary(self, NULL);
    if(strcmp(name, "specifiedZ") == 0)
        return ReflectAttributes_GetSpecifiedZ(self, NULL);
    if(strcmp(name, "reflections") == 0)
        return ReflectAttributes_GetReflections(self, NULL);

    return Py_FindMethod(ReflectAttributes_methods, self, name);
}

static int
ReflectAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "octant") == 0)
        retval = (ReflectAttributes_SetOctant(self, tuple) != NULL);
    else if(strcmp(name, "useXBoundary") == 0)
        retval = (ReflectAttributes_SetUseXBoundary(self, tuple) != NULL);
    else if(strcmp(name, "specifiedX") == 0)
        retval = (ReflectAttributes_SetSpecifiedX(self, tuple) != NULL);
    else if(strcmp(name, "useYBoundary") == 0)
        retval = (ReflectAttributes_SetUseYBoundary(self, tuple) != NULL);
    else if(strcmp(name, "specifiedY") == 0)
        retval = (ReflectAttributes_SetSpecifiedY(self, tuple) != NULL);
    else if(strcmp(name, "useZBoundary") == 0)
        retval = (ReflectAttributes_SetUseZBoundary(self, tuple) != NULL);
    else if(strcmp(name, "specifiedZ") == 0)
        retval = (ReflectAttributes_SetSpecifiedZ(self, tuple) != NULL);
    else if(strcmp(name, "reflections") == 0)
        retval = (ReflectAttributes_SetReflections(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
ReflectAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ReflectAttributesObject *obj = (ReflectAttributesObject *)v;

    const char *octant_names = "PXPYPZ, NXPYPZ, PXNYPZ, NXNYPZ, PXPYNZ, NXPYNZ, PXNYNZ, NXNYNZ";
    if(obj->data->GetOctant() == ReflectAttributes::PXPYPZ)
        fprintf(fp, "octant = PXPYPZ  # %s\n", octant_names);
    else if(obj->data->GetOctant() == ReflectAttributes::NXPYPZ)
        fprintf(fp, "octant = NXPYPZ  # %s\n", octant_names);
    else if(obj->data->GetOctant() == ReflectAttributes::PXNYPZ)
        fprintf(fp, "octant = PXNYPZ  # %s\n", octant_names);
    else if(obj->data->GetOctant() == ReflectAttributes::NXNYPZ)
        fprintf(fp, "octant = NXNYPZ  # %s\n", octant_names);
    else if(obj->data->GetOctant() == ReflectAttributes::PXPYNZ)
        fprintf(fp, "octant = PXPYNZ  # %s\n", octant_names);
    else if(obj->data->GetOctant() == ReflectAttributes::NXPYNZ)
        fprintf(fp, "octant = NXPYNZ  # %s\n", octant_names);
    else if(obj->data->GetOctant() == ReflectAttributes::PXNYNZ)
        fprintf(fp, "octant = PXNYNZ  # %s\n", octant_names);
    else
        fprintf(fp, "octant = NXNYNZ  # %s\n", octant_names);

    if(obj->data->GetUseXBoundary())
        fprintf(fp, "useXBoundary = 1\n");
    else
        fprintf(fp, "useXBoundary = 0\n");
    fprintf(fp, "specifiedX = %g\n", obj->data->GetSpecifiedX());
    if(obj->data->GetUseYBoundary())
        fprintf(fp, "useYBoundary = 1\n");
    else
        fprintf(fp, "useYBoundary = 0\n");
    fprintf(fp, "specifiedY = %g\n", obj->data->GetSpecifiedY());
    if(obj->data->GetUseZBoundary())
        fprintf(fp, "useZBoundary = 1\n");
    else
        fprintf(fp, "useZBoundary = 0\n");
    fprintf(fp, "specifiedZ = %g\n", obj->data->GetSpecifiedZ());
    {   const int *reflections = obj->data->GetReflections();
        fprintf(fp, "reflections = (");
        for(int i = 0; i < 8; ++i)
        {
            fprintf(fp, "%d", reflections[i]);
            if(i < 7)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }

    return 0;
}

//
// The doc string for the class.
//
static char *ReflectAttributes_Purpose = "This class contains attributes for the reflect operator.";

//
// The type description structure
//
static PyTypeObject ReflectAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ReflectAttributes",                    // tp_name
    sizeof(ReflectAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ReflectAttributes_dealloc,  // tp_dealloc
    (printfunc)ReflectAttributes_print,     // tp_print
    (getattrfunc)ReflectAttributes_getattr, // tp_getattr
    (setattrfunc)ReflectAttributes_setattr, // tp_setattr
    (cmpfunc)ReflectAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    0,                                   // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ReflectAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ReflectAttributes *defaultAtts = 0;

static PyObject *
NewReflectAttributes()
{
    ReflectAttributesObject *newObject;
    newObject = PyObject_NEW(ReflectAttributesObject, &ReflectAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new ReflectAttributes(*defaultAtts);
    else
        newObject->data = new ReflectAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapReflectAttributes(const ReflectAttributes *attr)
{
    ReflectAttributesObject *newObject;
    newObject = PyObject_NEW(ReflectAttributesObject, &ReflectAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ReflectAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ReflectAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewReflectAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ReflectAttributesMethods[] = {
    {"ReflectAttributes", ReflectAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ReflectAttributesObserver = 0;
static bool ReflectAttributesEnableLogging = true;

static void
PyReflectAttributes_WriteLog(Subject *subj, void *data)
{
    ReflectAttributes *atts = (ReflectAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!ReflectAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# ReflectAttributes_WriteLog()\n");
}

void
PyReflectAttributes_StartUp(ReflectAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyReflectAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ReflectAttributesObserver == 0)
    {
        ReflectAttributesObserver = new ObserverToCallback(subj,
            PyReflectAttributes_WriteLog, (void *)logFile);
    }

    ReflectAttributesEnableLogging = true;
}

void
PyReflectAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ReflectAttributesObserver;
    ReflectAttributesObserver = 0;
}

PyMethodDef *
PyReflectAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ReflectAttributesMethods;
}

bool
PyReflectAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ReflectAttributesType);
}

ReflectAttributes *
PyReflectAttributes_FromPyObject(PyObject *obj)
{
    ReflectAttributesObject *obj2 = (ReflectAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyReflectAttributes_NewPyObject()
{
    return NewReflectAttributes();
}

PyObject *
PyReflectAttributes_WrapPyObject(const ReflectAttributes *attr)
{
    return WrapReflectAttributes(attr);
}

void
PyReflectAttributes_SetLogging(bool val)
{
    ReflectAttributesEnableLogging = val;
}

void
PyReflectAttributes_SetDefaults(const ReflectAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ReflectAttributes(*atts);
}

