#include <PyProjectAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyProjectAttributes
//
// Purpose: 
//   Project data from three to two dimensions
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Tue May 18 14:35:40 PST 2004
//
// ****************************************************************************

//
// This struct contains the Python type information and a ProjectAttributes.
//
struct ProjectAttributesObject
{
    PyObject_HEAD
    ProjectAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewProjectAttributes();

static PyObject *
ProjectAttributes_Notify(PyObject *self, PyObject *args)
{
    ProjectAttributesObject *obj = (ProjectAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ProjectAttributes_SetProjectionType(PyObject *self, PyObject *args)
{
    ProjectAttributesObject *obj = (ProjectAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the projectionType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetProjectionType(ProjectAttributes::ProjectionType(ival));
    else
    {
        fprintf(stderr, "An invalid projectionType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "XYCartesian, ZRCylindrical.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ProjectAttributes_GetProjectionType(PyObject *self, PyObject *args)
{
    ProjectAttributesObject *obj = (ProjectAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetProjectionType()));
    return retval;
}



static struct PyMethodDef ProjectAttributes_methods[] = {
    {"Notify", ProjectAttributes_Notify, METH_VARARGS},
    {"SetProjectionType", ProjectAttributes_SetProjectionType, METH_VARARGS},
    {"GetProjectionType", ProjectAttributes_GetProjectionType, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ProjectAttributes_dealloc(PyObject *v)
{
   ProjectAttributesObject *obj = (ProjectAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
ProjectAttributes_compare(PyObject *v, PyObject *w)
{
    ProjectAttributes *a = ((ProjectAttributesObject *)v)->data;
    ProjectAttributes *b = ((ProjectAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
ProjectAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "projectionType") == 0)
        return ProjectAttributes_GetProjectionType(self, NULL);
    if(strcmp(name, "XYCartesian") == 0)
        return PyInt_FromLong(long(ProjectAttributes::XYCartesian));
    else if(strcmp(name, "ZRCylindrical") == 0)
        return PyInt_FromLong(long(ProjectAttributes::ZRCylindrical));


    return Py_FindMethod(ProjectAttributes_methods, self, name);
}

static int
ProjectAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "projectionType") == 0)
        retval = (ProjectAttributes_SetProjectionType(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
ProjectAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ProjectAttributesObject *obj = (ProjectAttributesObject *)v;

    const char *projectionType_names = "XYCartesian, ZRCylindrical";
    if(obj->data->GetProjectionType() == ProjectAttributes::XYCartesian)
        fprintf(fp, "projectionType = XYCartesian  # %s\n", projectionType_names);
    else
        fprintf(fp, "projectionType = ZRCylindrical  # %s\n", projectionType_names);


    return 0;
}

#include <snprintf.h>
PyObject *
PyProjectAttributes_StringRepresentation(const ProjectAttributes *atts)
{
   std::string str; 
   char tmpStr[1000]; 

    const char *projectionType_names = "XYCartesian, ZRCylindrical";
    if(atts->GetProjectionType() == ProjectAttributes::XYCartesian)
        {
             SNPRINTF(tmpStr, 10000, "projectionType = XYCartesian  # %s\n", projectionType_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 10000, "projectionType = ZRCylindrical  # %s\n", projectionType_names);
             str += tmpStr;
        }

    return PyString_FromString(str.c_str());
}

static PyObject *
ProjectAttributes_str(PyObject *v)
{
    ProjectAttributesObject *obj = (ProjectAttributesObject *)v;
    return PyProjectAttributes_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
static char *ProjectAttributes_Purpose = "Project data from three to two dimensions";

//
// The type description structure
//
static PyTypeObject ProjectAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ProjectAttributes",                    // tp_name
    sizeof(ProjectAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ProjectAttributes_dealloc,  // tp_dealloc
    (printfunc)ProjectAttributes_print,     // tp_print
    (getattrfunc)ProjectAttributes_getattr, // tp_getattr
    (setattrfunc)ProjectAttributes_setattr, // tp_setattr
    (cmpfunc)ProjectAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ProjectAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ProjectAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ProjectAttributes *defaultAtts = 0;

static PyObject *
NewProjectAttributes()
{
    ProjectAttributesObject *newObject;
    newObject = PyObject_NEW(ProjectAttributesObject, &ProjectAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new ProjectAttributes(*defaultAtts);
    else
        newObject->data = new ProjectAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapProjectAttributes(const ProjectAttributes *attr)
{
    ProjectAttributesObject *newObject;
    newObject = PyObject_NEW(ProjectAttributesObject, &ProjectAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ProjectAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ProjectAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewProjectAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ProjectAttributesMethods[] = {
    {"ProjectAttributes", ProjectAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ProjectAttributesObserver = 0;
static bool ProjectAttributesEnableLogging = true;

static void
PyProjectAttributes_WriteLog(Subject *subj, void *data)
{
    ProjectAttributes *atts = (ProjectAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!ProjectAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# ProjectAttributes_WriteLog()\n");
}

void
PyProjectAttributes_StartUp(ProjectAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyProjectAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ProjectAttributesObserver == 0)
    {
        ProjectAttributesObserver = new ObserverToCallback(subj,
            PyProjectAttributes_WriteLog, (void *)logFile);
    }

    ProjectAttributesEnableLogging = true;
}

void
PyProjectAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ProjectAttributesObserver;
    ProjectAttributesObserver = 0;
}

PyMethodDef *
PyProjectAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ProjectAttributesMethods;
}

bool
PyProjectAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ProjectAttributesType);
}

ProjectAttributes *
PyProjectAttributes_FromPyObject(PyObject *obj)
{
    ProjectAttributesObject *obj2 = (ProjectAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyProjectAttributes_NewPyObject()
{
    return NewProjectAttributes();
}

PyObject *
PyProjectAttributes_WrapPyObject(const ProjectAttributes *attr)
{
    return WrapProjectAttributes(attr);
}

void
PyProjectAttributes_SetLogging(bool val)
{
    ProjectAttributesEnableLogging = val;
}

void
PyProjectAttributes_SetDefaults(const ProjectAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ProjectAttributes(*atts);
}

