// ************************************************************************* //
//  File: ProjectViewerPluginInfo.C
// ************************************************************************* //

#include <ProjectPluginInfo.h>
#include <ProjectAttributes.h>

#if defined(__APPLE__)
#define GetViewerInfo Project_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Project operator.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue May 18 14:35:37 PST 2004
//
// ****************************************************************************
extern "C" ViewerOperatorPluginInfo* GetViewerInfo()
{
    ProjectViewerPluginInfo::InitializeGlobalObjects();
    return new ProjectViewerPluginInfo;
}

//
// Storage for static data elements.
//
ProjectAttributes *ProjectViewerPluginInfo::clientAtts = NULL;
ProjectAttributes *ProjectViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  ProjectViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue May 18 14:35:37 PST 2004
//
// ****************************************************************************
void
ProjectViewerPluginInfo::InitializeGlobalObjects()
{
    ProjectViewerPluginInfo::clientAtts  = new ProjectAttributes;
    ProjectViewerPluginInfo::defaultAtts = new ProjectAttributes;
}

// ****************************************************************************
//  Method: ProjectViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue May 18 14:35:37 PST 2004
//
// ****************************************************************************

AttributeSubject *
ProjectViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: ProjectViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue May 18 14:35:37 PST 2004
//
// ****************************************************************************

AttributeSubject *
ProjectViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: ProjectViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue May 18 14:35:37 PST 2004
//
// ****************************************************************************

void
ProjectViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(ProjectAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: ProjectViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue May 18 14:35:37 PST 2004
//
// ****************************************************************************

void
ProjectViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(ProjectAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: ProjectViewerPluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    md        The metadata used to initialize.
//    atts      The variable name used to initialize.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue May 18 14:35:37 PST 2004
//
// ****************************************************************************

void
ProjectViewerPluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const ViewerPlot *plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(ProjectAttributes*)atts = *defaultAtts;
    else
        *(ProjectAttributes*)atts = *clientAtts;
}

// ****************************************************************************
//  Method: ProjectViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue May 18 14:35:37 PST 2004
//
// ****************************************************************************

#include <Project.xpm>
const char **
ProjectViewerPluginInfo::XPMIconData() const
{
    return Project_xpm;
}
