// ************************************************************************* //
//                        ProjectScriptingPluginInfo.C
// ************************************************************************* //
#include <ProjectPluginInfo.h>
#include <PyProjectAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo Project_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the Project plot.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue May 18 14:35:37 PST 2004
//
// ****************************************************************************
extern "C" ScriptingOperatorPluginInfo* GetScriptingInfo()
{
    return new ProjectScriptingPluginInfo;
}

// ****************************************************************************
// Method: ProjectScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue May 18 14:35:37 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
ProjectScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyProjectAttributes_StartUp((ProjectAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: ProjectScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue May 18 14:35:37 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void *
ProjectScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyProjectAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: ProjectScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is Project plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue May 18 14:35:37 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
ProjectScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyProjectAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: ProjectScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue May 18 14:35:37 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
ProjectScriptingPluginInfo::SetLogging(bool val)
{
    PyProjectAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: ProjectScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue May 18 14:35:37 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
ProjectScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyProjectAttributes_SetDefaults((const ProjectAttributes *)atts);
}
