// ************************************************************************* //
//  File: ProjectPluginInfo.h
// ************************************************************************* //

#ifndef PROJECT_PLUGIN_INFO_H
#define PROJECT_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class ProjectAttributes;

// ****************************************************************************
//  Class: ProjectPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an Project operator
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue May 18 14:35:37 PST 2004
//
//  Modifications:
//
// ****************************************************************************

class ProjectGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
    virtual bool  EnabledByDefault() const;
};

class ProjectCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual ProjectGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class ProjectGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual ProjectCommonPluginInfo
{
  public:
    virtual const char *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, QvisNotepadArea *notepad);
    virtual const char **XPMIconData() const;
};

class ProjectViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual ProjectCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const ViewerPlot *plot,
                                        const bool fromDefault);
    virtual const char **XPMIconData() const;

    static void InitializeGlobalObjects();
  private:
    static ProjectAttributes *defaultAtts;
    static ProjectAttributes *clientAtts;
};

class ProjectEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual ProjectCommonPluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class ProjectScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual ProjectCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, FILE *log);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual void SetLogging(bool val);
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
