// ************************************************************************* //
//  File: ProjectGUIPluginInfo.C
// ************************************************************************* //

#include <ProjectPluginInfo.h>
#include <ProjectAttributes.h>
#include <QvisProjectWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo Project_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the Project operator.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue May 18 14:35:37 PST 2004
//
// ****************************************************************************
extern "C" GUIOperatorPluginInfo* GetGUIInfo()
{
    return new ProjectGUIPluginInfo;
}

// ****************************************************************************
//  Method: ProjectGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue May 18 14:35:37 PST 2004
//
// ****************************************************************************

const char *
ProjectGUIPluginInfo::GetMenuName() const
{
    return "Project";
}


// ****************************************************************************
//  Method: ProjectGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue May 18 14:35:37 PST 2004
//
// ****************************************************************************

QvisPostableWindowObserver *
ProjectGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisProjectWindow(type, (ProjectAttributes *)attr,
        "Project operator attributes", "Project operator", notepad);
}

// ****************************************************************************
//  Method: ProjectGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue May 18 14:35:37 PST 2004
//
// ****************************************************************************

#include <Project.xpm>
const char **
ProjectGUIPluginInfo::XPMIconData() const
{
    return Project_xpm;
}
