#include <ProjectAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for ProjectAttributes::ProjectionType
//

static const char *ProjectionType_strings[] = {
"XYCartesian", "ZRCylindrical"};

std::string
ProjectAttributes::ProjectionType_ToString(ProjectAttributes::ProjectionType t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return ProjectionType_strings[index];
}

std::string
ProjectAttributes::ProjectionType_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return ProjectionType_strings[index];
}

bool
ProjectAttributes::ProjectionType_FromString(const std::string &s, ProjectAttributes::ProjectionType &val)
{
    val = ProjectAttributes::XYCartesian;
    for(int i = 0; i < 2; ++i)
    {
        if(s == ProjectionType_strings[i])
        {
            val = (ProjectionType)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: ProjectAttributes::ProjectAttributes
//
// Purpose: 
//   Constructor for the ProjectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue May 18 14:35:36 PST 2004
//
// Modifications:
//   
// ****************************************************************************

ProjectAttributes::ProjectAttributes() : AttributeSubject("i")
{
    projectionType = XYCartesian;
}

// ****************************************************************************
// Method: ProjectAttributes::ProjectAttributes
//
// Purpose: 
//   Copy constructor for the ProjectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue May 18 14:35:36 PST 2004
//
// Modifications:
//   
// ****************************************************************************

ProjectAttributes::ProjectAttributes(const ProjectAttributes &obj) : AttributeSubject("i")
{
    projectionType = obj.projectionType;

    SelectAll();
}

// ****************************************************************************
// Method: ProjectAttributes::~ProjectAttributes
//
// Purpose: 
//   Destructor for the ProjectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue May 18 14:35:36 PST 2004
//
// Modifications:
//   
// ****************************************************************************

ProjectAttributes::~ProjectAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: ProjectAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the ProjectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue May 18 14:35:36 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
ProjectAttributes::operator = (const ProjectAttributes &obj)
{
    projectionType = obj.projectionType;

    SelectAll();
}

// ****************************************************************************
// Method: ProjectAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the ProjectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue May 18 14:35:36 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
ProjectAttributes::operator == (const ProjectAttributes &obj) const
{
    // Create the return value
    return ((projectionType == obj.projectionType));
}

// ****************************************************************************
// Method: ProjectAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the ProjectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue May 18 14:35:36 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
ProjectAttributes::operator != (const ProjectAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ProjectAttributes::TypeName
//
// Purpose: 
//   Type name method for the ProjectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue May 18 14:35:36 PST 2004
//
// Modifications:
//   
// ****************************************************************************

const std::string
ProjectAttributes::TypeName() const
{
    return "ProjectAttributes";
}

// ****************************************************************************
// Method: ProjectAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ProjectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue May 18 14:35:36 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
ProjectAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ProjectAttributes *tmp = (const ProjectAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ProjectAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ProjectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue May 18 14:35:36 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ProjectAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ProjectAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: ProjectAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the ProjectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue May 18 14:35:36 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ProjectAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ProjectAttributes(*this);
    else
        retval = new ProjectAttributes;

    return retval;
}

// ****************************************************************************
// Method: ProjectAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue May 18 14:35:36 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
ProjectAttributes::SelectAll()
{
    Select(0, (void *)&projectionType);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ProjectAttributes::SetProjectionType(ProjectAttributes::ProjectionType projectionType_)
{
    projectionType = projectionType_;
    Select(0, (void *)&projectionType);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

ProjectAttributes::ProjectionType
ProjectAttributes::GetProjectionType() const
{
    return ProjectionType(projectionType);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ProjectAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue May 18 14:35:36 PST 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
ProjectAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "projectionType";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ProjectAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue May 18 14:35:36 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ProjectAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_enum;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ProjectAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue May 18 14:35:36 PST 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
ProjectAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "enum";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ProjectAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue May 18 14:35:36 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
ProjectAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const ProjectAttributes &obj = *((const ProjectAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (projectionType == obj.projectionType);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

