#include <PyOnionPeelAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyOnionPeelAttributes
//
// Purpose: 
//   Attributes for the onion peel operator
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Wed Jan 19 15:43:06 PST 2005
//
// ****************************************************************************

//
// This struct contains the Python type information and a OnionPeelAttributes.
//
struct OnionPeelAttributesObject
{
    PyObject_HEAD
    OnionPeelAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewOnionPeelAttributes();

static PyObject *
OnionPeelAttributes_Notify(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
OnionPeelAttributes_SetAdjacencyType(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the adjacencyType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetAdjacencyType(OnionPeelAttributes::NodeFace(ival));
    else
    {
        fprintf(stderr, "An invalid adjacencyType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Node, Face.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
OnionPeelAttributes_GetAdjacencyType(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetAdjacencyType()));
    return retval;
}

static PyObject *
OnionPeelAttributes_SetUseGlobalId(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useGlobalId in the object.
    obj->data->SetUseGlobalId(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
OnionPeelAttributes_GetUseGlobalId(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseGlobalId()?1L:0L);
    return retval;
}

static PyObject *
OnionPeelAttributes_SetCategoryName(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the categoryName in the object.
    obj->data->SetCategoryName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
OnionPeelAttributes_GetCategoryName(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetCategoryName().c_str());
    return retval;
}

static PyObject *
OnionPeelAttributes_SetSubsetName(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the subsetName in the object.
    obj->data->SetSubsetName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
OnionPeelAttributes_GetSubsetName(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetSubsetName().c_str());
    return retval;
}

static PyObject *
OnionPeelAttributes_SetIndex(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;

    intVector  &vec = obj->data->GetIndex();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the index in the object as modified.
    obj->data->SelectIndex();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
OnionPeelAttributes_GetIndex(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the index.
    const intVector &index = obj->data->GetIndex();
    PyObject *retval = PyTuple_New(index.size());
    for(int i = 0; i < index.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(index[i])));
    return retval;
}

static PyObject *
OnionPeelAttributes_SetLogical(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the logical in the object.
    obj->data->SetLogical(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
OnionPeelAttributes_GetLogical(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLogical()?1L:0L);
    return retval;
}

static PyObject *
OnionPeelAttributes_SetRequestedLayer(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the requestedLayer in the object.
    obj->data->SetRequestedLayer(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
OnionPeelAttributes_GetRequestedLayer(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetRequestedLayer()));
    return retval;
}

static PyObject *
OnionPeelAttributes_SetSeedType(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the seedType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetSeedType(OnionPeelAttributes::SeedIdType(ival));
    else
    {
        fprintf(stderr, "An invalid seedType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "SeedCell, SeedNode.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
OnionPeelAttributes_GetSeedType(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSeedType()));
    return retval;
}



static struct PyMethodDef OnionPeelAttributes_methods[] = {
    {"Notify", OnionPeelAttributes_Notify, METH_VARARGS},
    {"SetAdjacencyType", OnionPeelAttributes_SetAdjacencyType, METH_VARARGS},
    {"GetAdjacencyType", OnionPeelAttributes_GetAdjacencyType, METH_VARARGS},
    {"SetUseGlobalId", OnionPeelAttributes_SetUseGlobalId, METH_VARARGS},
    {"GetUseGlobalId", OnionPeelAttributes_GetUseGlobalId, METH_VARARGS},
    {"SetCategoryName", OnionPeelAttributes_SetCategoryName, METH_VARARGS},
    {"GetCategoryName", OnionPeelAttributes_GetCategoryName, METH_VARARGS},
    {"SetSubsetName", OnionPeelAttributes_SetSubsetName, METH_VARARGS},
    {"GetSubsetName", OnionPeelAttributes_GetSubsetName, METH_VARARGS},
    {"SetIndex", OnionPeelAttributes_SetIndex, METH_VARARGS},
    {"GetIndex", OnionPeelAttributes_GetIndex, METH_VARARGS},
    {"SetLogical", OnionPeelAttributes_SetLogical, METH_VARARGS},
    {"GetLogical", OnionPeelAttributes_GetLogical, METH_VARARGS},
    {"SetRequestedLayer", OnionPeelAttributes_SetRequestedLayer, METH_VARARGS},
    {"GetRequestedLayer", OnionPeelAttributes_GetRequestedLayer, METH_VARARGS},
    {"SetSeedType", OnionPeelAttributes_SetSeedType, METH_VARARGS},
    {"GetSeedType", OnionPeelAttributes_GetSeedType, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
OnionPeelAttributes_dealloc(PyObject *v)
{
   OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
OnionPeelAttributes_compare(PyObject *v, PyObject *w)
{
    OnionPeelAttributes *a = ((OnionPeelAttributesObject *)v)->data;
    OnionPeelAttributes *b = ((OnionPeelAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
OnionPeelAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "adjacencyType") == 0)
        return OnionPeelAttributes_GetAdjacencyType(self, NULL);
    if(strcmp(name, "Node") == 0)
        return PyInt_FromLong(long(OnionPeelAttributes::Node));
    else if(strcmp(name, "Face") == 0)
        return PyInt_FromLong(long(OnionPeelAttributes::Face));

    if(strcmp(name, "useGlobalId") == 0)
        return OnionPeelAttributes_GetUseGlobalId(self, NULL);
    if(strcmp(name, "categoryName") == 0)
        return OnionPeelAttributes_GetCategoryName(self, NULL);
    if(strcmp(name, "subsetName") == 0)
        return OnionPeelAttributes_GetSubsetName(self, NULL);
    if(strcmp(name, "index") == 0)
        return OnionPeelAttributes_GetIndex(self, NULL);
    if(strcmp(name, "logical") == 0)
        return OnionPeelAttributes_GetLogical(self, NULL);
    if(strcmp(name, "requestedLayer") == 0)
        return OnionPeelAttributes_GetRequestedLayer(self, NULL);
    if(strcmp(name, "seedType") == 0)
        return OnionPeelAttributes_GetSeedType(self, NULL);
    if(strcmp(name, "SeedCell") == 0)
        return PyInt_FromLong(long(OnionPeelAttributes::SeedCell));
    else if(strcmp(name, "SeedNode") == 0)
        return PyInt_FromLong(long(OnionPeelAttributes::SeedNode));


    return Py_FindMethod(OnionPeelAttributes_methods, self, name);
}

static int
OnionPeelAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "adjacencyType") == 0)
        retval = (OnionPeelAttributes_SetAdjacencyType(self, tuple) != NULL);
    else if(strcmp(name, "useGlobalId") == 0)
        retval = (OnionPeelAttributes_SetUseGlobalId(self, tuple) != NULL);
    else if(strcmp(name, "categoryName") == 0)
        retval = (OnionPeelAttributes_SetCategoryName(self, tuple) != NULL);
    else if(strcmp(name, "subsetName") == 0)
        retval = (OnionPeelAttributes_SetSubsetName(self, tuple) != NULL);
    else if(strcmp(name, "index") == 0)
        retval = (OnionPeelAttributes_SetIndex(self, tuple) != NULL);
    else if(strcmp(name, "logical") == 0)
        retval = (OnionPeelAttributes_SetLogical(self, tuple) != NULL);
    else if(strcmp(name, "requestedLayer") == 0)
        retval = (OnionPeelAttributes_SetRequestedLayer(self, tuple) != NULL);
    else if(strcmp(name, "seedType") == 0)
        retval = (OnionPeelAttributes_SetSeedType(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
OnionPeelAttributes_print(PyObject *v, FILE *fp, int flags)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)v;

    const char *adjacencyType_names = "Node, Face";
    if(obj->data->GetAdjacencyType() == OnionPeelAttributes::Node)
        fprintf(fp, "adjacencyType = Node  # %s\n", adjacencyType_names);
    else
        fprintf(fp, "adjacencyType = Face  # %s\n", adjacencyType_names);

    if(obj->data->GetUseGlobalId())
        fprintf(fp, "useGlobalId = 1\n");
    else
        fprintf(fp, "useGlobalId = 0\n");
    fprintf(fp, "categoryName = \"%s\"\n", obj->data->GetCategoryName().c_str());
    fprintf(fp, "subsetName = \"%s\"\n", obj->data->GetSubsetName().c_str());
    {   const intVector &index = obj->data->GetIndex();
        fprintf(fp, "index = (");
        for(int i = 0; i < index.size(); ++i)
        {
            fprintf(fp, "%d", index[i]);
            if(i < index.size() - 1)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    if(obj->data->GetLogical())
        fprintf(fp, "logical = 1\n");
    else
        fprintf(fp, "logical = 0\n");
    fprintf(fp, "requestedLayer = %d\n", obj->data->GetRequestedLayer());
    const char *seedType_names = "SeedCell, SeedNode";
    if(obj->data->GetSeedType() == OnionPeelAttributes::SeedCell)
        fprintf(fp, "seedType = SeedCell  # %s\n", seedType_names);
    else
        fprintf(fp, "seedType = SeedNode  # %s\n", seedType_names);


    return 0;
}

#include <snprintf.h>
PyObject *
PyOnionPeelAttributes_StringRepresentation(const OnionPeelAttributes *atts)
{
   std::string str; 
   char tmpStr[1000]; 

    const char *adjacencyType_names = "Node, Face";
    if(atts->GetAdjacencyType() == OnionPeelAttributes::Node)
        {
             SNPRINTF(tmpStr, 1000, "adjacencyType = Node  # %s\n", adjacencyType_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "adjacencyType = Face  # %s\n", adjacencyType_names);
             str += tmpStr;
        }

    if(atts->GetUseGlobalId())
        SNPRINTF(tmpStr, 1000, "useGlobalId = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "useGlobalId = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "categoryName = \"%s\"\n", atts->GetCategoryName().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "subsetName = \"%s\"\n", atts->GetSubsetName().c_str());
    str += tmpStr;
    {   const intVector &index = atts->GetIndex();
        SNPRINTF(tmpStr, 1000, "index = (");
        str += tmpStr;
        for(int i = 0; i < index.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", index[i]);
            str += tmpStr;
            if(i < index.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->GetLogical())
        SNPRINTF(tmpStr, 1000, "logical = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "logical = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "requestedLayer = %d\n", atts->GetRequestedLayer());
    str += tmpStr;
    const char *seedType_names = "SeedCell, SeedNode";
    if(atts->GetSeedType() == OnionPeelAttributes::SeedCell)
        {
             SNPRINTF(tmpStr, 1000, "seedType = SeedCell  # %s\n", seedType_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "seedType = SeedNode  # %s\n", seedType_names);
             str += tmpStr;
        }

    return PyString_FromString(str.c_str());
}

static PyObject *
OnionPeelAttributes_str(PyObject *v)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)v;
    return PyOnionPeelAttributes_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
static char *OnionPeelAttributes_Purpose = "Attributes for the onion peel operator";

//
// The type description structure
//
static PyTypeObject OnionPeelAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "OnionPeelAttributes",                    // tp_name
    sizeof(OnionPeelAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)OnionPeelAttributes_dealloc,  // tp_dealloc
    (printfunc)OnionPeelAttributes_print,     // tp_print
    (getattrfunc)OnionPeelAttributes_getattr, // tp_getattr
    (setattrfunc)OnionPeelAttributes_setattr, // tp_setattr
    (cmpfunc)OnionPeelAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)OnionPeelAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    OnionPeelAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static OnionPeelAttributes *defaultAtts = 0;

static PyObject *
NewOnionPeelAttributes()
{
    OnionPeelAttributesObject *newObject;
    newObject = PyObject_NEW(OnionPeelAttributesObject, &OnionPeelAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new OnionPeelAttributes(*defaultAtts);
    else
        newObject->data = new OnionPeelAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapOnionPeelAttributes(const OnionPeelAttributes *attr)
{
    OnionPeelAttributesObject *newObject;
    newObject = PyObject_NEW(OnionPeelAttributesObject, &OnionPeelAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (OnionPeelAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
OnionPeelAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewOnionPeelAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef OnionPeelAttributesMethods[] = {
    {"OnionPeelAttributes", OnionPeelAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *OnionPeelAttributesObserver = 0;
static bool OnionPeelAttributesEnableLogging = true;

static void
PyOnionPeelAttributes_WriteLog(Subject *subj, void *data)
{
    OnionPeelAttributes *atts = (OnionPeelAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!OnionPeelAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# OnionPeelAttributes_WriteLog()\n");
}

void
PyOnionPeelAttributes_StartUp(OnionPeelAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyOnionPeelAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(OnionPeelAttributesObserver == 0)
    {
        OnionPeelAttributesObserver = new ObserverToCallback(subj,
            PyOnionPeelAttributes_WriteLog, (void *)logFile);
    }

    OnionPeelAttributesEnableLogging = true;
}

void
PyOnionPeelAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete OnionPeelAttributesObserver;
    OnionPeelAttributesObserver = 0;
}

PyMethodDef *
PyOnionPeelAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return OnionPeelAttributesMethods;
}

bool
PyOnionPeelAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &OnionPeelAttributesType);
}

OnionPeelAttributes *
PyOnionPeelAttributes_FromPyObject(PyObject *obj)
{
    OnionPeelAttributesObject *obj2 = (OnionPeelAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyOnionPeelAttributes_NewPyObject()
{
    return NewOnionPeelAttributes();
}

PyObject *
PyOnionPeelAttributes_WrapPyObject(const OnionPeelAttributes *attr)
{
    return WrapOnionPeelAttributes(attr);
}

void
PyOnionPeelAttributes_SetLogging(bool val)
{
    OnionPeelAttributesEnableLogging = val;
}

void
PyOnionPeelAttributes_SetDefaults(const OnionPeelAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new OnionPeelAttributes(*atts);
}

