// ************************************************************************* //
//  File: OnionPeelViewerPluginInfo.C
// ************************************************************************* //

#include <OnionPeelPluginInfo.h>
#include <OnionPeelAttributes.h>

#include <avtSIL.h>
#include <avtSILRestriction.h>
#include <CompactSILRestrictionAttributes.h>
#include <ViewerPlot.h>

#if defined(__APPLE__)
#define GetViewerInfo OnionPeel_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the OnionPeel operator.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:04:02 PST 2003
//
// ****************************************************************************
extern "C" ViewerOperatorPluginInfo* GetViewerInfo()
{
    OnionPeelViewerPluginInfo::InitializeGlobalObjects();
    return new OnionPeelViewerPluginInfo;
}

//
// Storage for static data elements.
//
OnionPeelAttributes *OnionPeelViewerPluginInfo::clientAtts = NULL;
OnionPeelAttributes *OnionPeelViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  OnionPeelViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:04:02 PST 2003
//
// ****************************************************************************
void
OnionPeelViewerPluginInfo::InitializeGlobalObjects()
{
    OnionPeelViewerPluginInfo::clientAtts  = new OnionPeelAttributes;
    OnionPeelViewerPluginInfo::defaultAtts = new OnionPeelAttributes;
}

// ****************************************************************************
//  Method: OnionPeelViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:04:02 PST 2003
//
// ****************************************************************************

AttributeSubject *
OnionPeelViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: OnionPeelViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:04:02 PST 2003
//
// ****************************************************************************

AttributeSubject *
OnionPeelViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: OnionPeelViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:04:02 PST 2003
//
// ****************************************************************************

void
OnionPeelViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(OnionPeelAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: OnionPeelViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:04:02 PST 2003
//
// ****************************************************************************

void
OnionPeelViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(OnionPeelAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: OnionPeelViewerPluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:04:02 PST 2003
//
//  Modifications:
//    Added code to set the category name and subset name from the plot's
//    SILRestriction. 
//
// ****************************************************************************

void
OnionPeelViewerPluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const ViewerPlot *plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(OnionPeelAttributes*)atts = *defaultAtts;
    else
        *(OnionPeelAttributes*)atts = *clientAtts;

    OnionPeelAttributes *opAtts = (OnionPeelAttributes*)atts;


    string categoryName = opAtts->GetCategoryName();
    string subsetName = opAtts->GetSubsetName();
    string defaultName = "Whole";
    string firstCategoryName = defaultName;
    string firstSubsetName = defaultName;

    bool categoryNameValid = false;
    bool subsetNameValid = false;
    avtSILRestriction_p restriction = plot->GetSILRestriction();
    int silTopSet = restriction->GetTopSet();

    // 
    // Determine the first valid category name, and determine if
    // currently set category name is valid. 
    // 
    avtSILSet_p current = restriction->GetSILSet(silTopSet);
    const std::vector<int> &mapsOut = current->GetMapsOut();
    for (int j = 0; j < mapsOut.size() && !categoryNameValid; ++j)
    {
        int cIndex = mapsOut[j];
        avtSILCollection_p collection =restriction->GetSILCollection(cIndex);
        if ((collection->GetRole() == SIL_DOMAIN) ||
            (collection->GetRole() == SIL_BLOCK)) 
        {
            if (collection->GetCategory() == categoryName)
            {
                categoryNameValid = true;
            }
            else if (firstCategoryName == defaultName)
            {
                firstCategoryName = collection->GetCategory();
            }
            CompactSILRestrictionAttributes *silAtts = 
                restriction->MakeCompactAttributes();
            const unsignedCharVector &useSet =  silAtts->GetUseSet();
            //
            // Find the first valid subset name, and also determine if
            // the currently set subset name is valid.
            //
            int colIndex = restriction->GetCollectionIndex(collection->GetCategory());
            avtSILCollection_p collection =restriction->GetSILCollection(colIndex); 
            if (*collection != NULL)
            {
                std::vector<int> sets = collection->GetSubsetList();
                for (int i = 0; i < sets.size() && !subsetNameValid; ++i)
                {
                    if (useSet[sets[i]] != 0)
                    {
                        avtSILSet_p set = restriction->GetSILSet(sets[i]);
                        if (set->GetName() == subsetName)
                        {
                            subsetNameValid = true;
                        }
                        else if (firstSubsetName == defaultName)
                        {
                            firstSubsetName = set->GetName();
                        }
                    }
                }
            } 
        } 
    }

    // 
    // Use the currently set category and subsets name only if they
    // have they are valid.
    // 
    if (subsetNameValid)
    {
        opAtts->SetSubsetName(subsetName);
        defaultAtts->SetSubsetName(subsetName);
    }
    else 
    {
        opAtts->SetSubsetName(firstSubsetName);
        defaultAtts->SetSubsetName(firstSubsetName);
    }
    if (categoryNameValid)
    {
       opAtts->SetCategoryName(categoryName);
       defaultAtts->SetCategoryName(categoryName);
    }
    else 
    {
        opAtts->SetCategoryName(firstCategoryName);
        defaultAtts->SetCategoryName(firstCategoryName);
    }
}

// ****************************************************************************
//  Method: OnionPeelViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:04:02 PST 2003
//
// ****************************************************************************

#include <OnionPeel.xpm>
const char **
OnionPeelViewerPluginInfo::XPMIconData() const
{
    return OnionPeel_xpm;
}
