// ************************************************************************* //
//                        OnionPeelScriptingPluginInfo.C
// ************************************************************************* //
#include <OnionPeelPluginInfo.h>
#include <PyOnionPeelAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo OnionPeel_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the OnionPeel plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:36:54 PST 2002
//
// ****************************************************************************
extern "C" ScriptingOperatorPluginInfo* GetScriptingInfo()
{
    return new OnionPeelScriptingPluginInfo;
}

// ****************************************************************************
// Method: OnionPeelScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:36:54 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
OnionPeelScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyOnionPeelAttributes_StartUp((OnionPeelAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: OnionPeelScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:36:54 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void *
OnionPeelScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyOnionPeelAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: OnionPeelScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is OnionPeel plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:36:54 PST 2002
//
// Modifications:
//   
// ****************************************************************************

bool
OnionPeelScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyOnionPeelAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: OnionPeelScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:36:54 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
OnionPeelScriptingPluginInfo::SetLogging(bool val)
{
    PyOnionPeelAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: OnionPeelScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:36:54 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
OnionPeelScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyOnionPeelAttributes_SetDefaults((const OnionPeelAttributes *)atts);
}
