// ************************************************************************* //
//  File: OnionPeelGUIPluginInfo.C
// ************************************************************************* //

#include <OnionPeelPluginInfo.h>
#include <OnionPeelAttributes.h>
#include <QvisOnionPeelWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo OnionPeel_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the OnionPeel operator.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 16:13:01 PST 2003
//
// ****************************************************************************
extern "C" GUIOperatorPluginInfo* GetGUIInfo()
{
    return new OnionPeelGUIPluginInfo;
}

// ****************************************************************************
//  Method: OnionPeelGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 16:13:01 PST 2003
//
// ****************************************************************************

const char *
OnionPeelGUIPluginInfo::GetMenuName() const
{
    return "Onion Peel";
}


// ****************************************************************************
//  Method: OnionPeelGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 16:13:01 PST 2003
//
// ****************************************************************************

QvisPostableWindowObserver *
OnionPeelGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisOnionPeelWindow(type, (OnionPeelAttributes *)attr,
        "Onion Peel operator attributes", "OnionPeel operator", notepad);
}

// ****************************************************************************
//  Method: OnionPeelGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 16:13:01 PST 2003
//
// ****************************************************************************

#include <OnionPeel.xpm>
const char **
OnionPeelGUIPluginInfo::XPMIconData() const
{
    return OnionPeel_xpm;
}
