#ifndef ONIONPEELATTRIBUTES_H
#define ONIONPEELATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>

// ****************************************************************************
// Class: OnionPeelAttributes
//
// Purpose:
//    Attributes for the onion peel operator
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Jan 19 15:42:52 PST 2005
//
// Modifications:
//   
// ****************************************************************************

class OnionPeelAttributes : public AttributeSubject
{
public:
    enum NodeFace
    {
        Node,
        Face
    };
    enum SeedIdType
    {
        SeedCell,
        SeedNode
    };

    OnionPeelAttributes();
    OnionPeelAttributes(const OnionPeelAttributes &obj);
    virtual ~OnionPeelAttributes();

    virtual OnionPeelAttributes& operator = (const OnionPeelAttributes &obj);
    virtual bool operator == (const OnionPeelAttributes &obj) const;
    virtual bool operator != (const OnionPeelAttributes &obj) const;

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectCategoryName();
    void SelectSubsetName();
    void SelectIndex();

    // Property setting methods
    void SetAdjacencyType(NodeFace adjacencyType_);
    void SetUseGlobalId(bool useGlobalId_);
    void SetCategoryName(const std::string &categoryName_);
    void SetSubsetName(const std::string &subsetName_);
    void SetIndex(const intVector &index_);
    void SetLogical(bool logical_);
    void SetRequestedLayer(int requestedLayer_);
    void SetSeedType(SeedIdType seedType_);

    // Property getting methods
    NodeFace          GetAdjacencyType() const;
    bool              GetUseGlobalId() const;
    const std::string &GetCategoryName() const;
          std::string &GetCategoryName();
    const std::string &GetSubsetName() const;
          std::string &GetSubsetName();
    const intVector   &GetIndex() const;
          intVector   &GetIndex();
    bool              GetLogical() const;
    int               GetRequestedLayer() const;
    SeedIdType        GetSeedType() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string NodeFace_ToString(NodeFace);
    static bool NodeFace_FromString(const std::string &, NodeFace &);
protected:
    static std::string NodeFace_ToString(int);
public:
    static std::string SeedIdType_ToString(SeedIdType);
    static bool SeedIdType_FromString(const std::string &, SeedIdType &);
protected:
    static std::string SeedIdType_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

private:
    int         adjacencyType;
    bool        useGlobalId;
    std::string categoryName;
    std::string subsetName;
    intVector   index;
    bool        logical;
    int         requestedLayer;
    int         seedType;
};

#endif
