#include <OnionPeelAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for OnionPeelAttributes::NodeFace
//

static const char *NodeFace_strings[] = {
"Node", "Face"};

std::string
OnionPeelAttributes::NodeFace_ToString(OnionPeelAttributes::NodeFace t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return NodeFace_strings[index];
}

std::string
OnionPeelAttributes::NodeFace_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return NodeFace_strings[index];
}

bool
OnionPeelAttributes::NodeFace_FromString(const std::string &s, OnionPeelAttributes::NodeFace &val)
{
    val = OnionPeelAttributes::Node;
    for(int i = 0; i < 2; ++i)
    {
        if(s == NodeFace_strings[i])
        {
            val = (NodeFace)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for OnionPeelAttributes::SeedIdType
//

static const char *SeedIdType_strings[] = {
"SeedCell", "SeedNode"};

std::string
OnionPeelAttributes::SeedIdType_ToString(OnionPeelAttributes::SeedIdType t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return SeedIdType_strings[index];
}

std::string
OnionPeelAttributes::SeedIdType_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return SeedIdType_strings[index];
}

bool
OnionPeelAttributes::SeedIdType_FromString(const std::string &s, OnionPeelAttributes::SeedIdType &val)
{
    val = OnionPeelAttributes::SeedCell;
    for(int i = 0; i < 2; ++i)
    {
        if(s == SeedIdType_strings[i])
        {
            val = (SeedIdType)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: OnionPeelAttributes::OnionPeelAttributes
//
// Purpose: 
//   Constructor for the OnionPeelAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Jan 19 15:42:52 PST 2005
//
// Modifications:
//   
// ****************************************************************************

OnionPeelAttributes::OnionPeelAttributes() : AttributeSubject("ibssi*bii")
{
    adjacencyType = Node;
    useGlobalId = false;
    categoryName = "Whole";
    subsetName = "Whole";
    index.push_back(1);
    logical = false;
    requestedLayer = 0;
    seedType = SeedCell;
}

// ****************************************************************************
// Method: OnionPeelAttributes::OnionPeelAttributes
//
// Purpose: 
//   Copy constructor for the OnionPeelAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Jan 19 15:42:52 PST 2005
//
// Modifications:
//   
// ****************************************************************************

OnionPeelAttributes::OnionPeelAttributes(const OnionPeelAttributes &obj) : AttributeSubject("ibssi*bii")
{
    adjacencyType = obj.adjacencyType;
    useGlobalId = obj.useGlobalId;
    categoryName = obj.categoryName;
    subsetName = obj.subsetName;
    index = obj.index;
    logical = obj.logical;
    requestedLayer = obj.requestedLayer;
    seedType = obj.seedType;

    SelectAll();
}

// ****************************************************************************
// Method: OnionPeelAttributes::~OnionPeelAttributes
//
// Purpose: 
//   Destructor for the OnionPeelAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Jan 19 15:42:52 PST 2005
//
// Modifications:
//   
// ****************************************************************************

OnionPeelAttributes::~OnionPeelAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: OnionPeelAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the OnionPeelAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Jan 19 15:42:52 PST 2005
//
// Modifications:
//   
// ****************************************************************************

OnionPeelAttributes& 
OnionPeelAttributes::operator = (const OnionPeelAttributes &obj)
{
    if (this == &obj) return *this;
    adjacencyType = obj.adjacencyType;
    useGlobalId = obj.useGlobalId;
    categoryName = obj.categoryName;
    subsetName = obj.subsetName;
    index = obj.index;
    logical = obj.logical;
    requestedLayer = obj.requestedLayer;
    seedType = obj.seedType;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: OnionPeelAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the OnionPeelAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Jan 19 15:42:52 PST 2005
//
// Modifications:
//   
// ****************************************************************************

bool
OnionPeelAttributes::operator == (const OnionPeelAttributes &obj) const
{
    // Create the return value
    return ((adjacencyType == obj.adjacencyType) &&
            (useGlobalId == obj.useGlobalId) &&
            (categoryName == obj.categoryName) &&
            (subsetName == obj.subsetName) &&
            (index == obj.index) &&
            (logical == obj.logical) &&
            (requestedLayer == obj.requestedLayer) &&
            (seedType == obj.seedType));
}

// ****************************************************************************
// Method: OnionPeelAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the OnionPeelAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Jan 19 15:42:52 PST 2005
//
// Modifications:
//   
// ****************************************************************************

bool
OnionPeelAttributes::operator != (const OnionPeelAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: OnionPeelAttributes::TypeName
//
// Purpose: 
//   Type name method for the OnionPeelAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Jan 19 15:42:52 PST 2005
//
// Modifications:
//   
// ****************************************************************************

const std::string
OnionPeelAttributes::TypeName() const
{
    return "OnionPeelAttributes";
}

// ****************************************************************************
// Method: OnionPeelAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the OnionPeelAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Jan 19 15:42:52 PST 2005
//
// Modifications:
//   
// ****************************************************************************

bool
OnionPeelAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const OnionPeelAttributes *tmp = (const OnionPeelAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: OnionPeelAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the OnionPeelAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Jan 19 15:42:52 PST 2005
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
OnionPeelAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new OnionPeelAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: OnionPeelAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the OnionPeelAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Jan 19 15:42:52 PST 2005
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
OnionPeelAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new OnionPeelAttributes(*this);
    else
        retval = new OnionPeelAttributes;

    return retval;
}

// ****************************************************************************
// Method: OnionPeelAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Jan 19 15:42:52 PST 2005
//
// Modifications:
//   
// ****************************************************************************

void
OnionPeelAttributes::SelectAll()
{
    Select(0, (void *)&adjacencyType);
    Select(1, (void *)&useGlobalId);
    Select(2, (void *)&categoryName);
    Select(3, (void *)&subsetName);
    Select(4, (void *)&index);
    Select(5, (void *)&logical);
    Select(6, (void *)&requestedLayer);
    Select(7, (void *)&seedType);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: OnionPeelAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Jan 19 15:42:52 PST 2005
//
// Modifications:
//   
// ****************************************************************************

bool
OnionPeelAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    OnionPeelAttributes defaultObject;
    bool addToParent = false;
    // Create a node for OnionPeelAttributes.
    DataNode *node = new DataNode("OnionPeelAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("adjacencyType", NodeFace_ToString(adjacencyType)));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("useGlobalId", useGlobalId));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("categoryName", categoryName));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("subsetName", subsetName));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("index", index));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("logical", logical));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("requestedLayer", requestedLayer));
    }

    if(completeSave || !FieldsEqual(7, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("seedType", SeedIdType_ToString(seedType)));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: OnionPeelAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Jan 19 15:42:52 PST 2005
//
// Modifications:
//   
// ****************************************************************************

void
OnionPeelAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("OnionPeelAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("adjacencyType")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 2)
                SetAdjacencyType(NodeFace(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            NodeFace value;
            if(NodeFace_FromString(node->AsString(), value))
                SetAdjacencyType(value);
        }
    }
    if((node = searchNode->GetNode("useGlobalId")) != 0)
        SetUseGlobalId(node->AsBool());
    if((node = searchNode->GetNode("categoryName")) != 0)
        SetCategoryName(node->AsString());
    if((node = searchNode->GetNode("subsetName")) != 0)
        SetSubsetName(node->AsString());
    if((node = searchNode->GetNode("index")) != 0)
        SetIndex(node->AsIntVector());
    if((node = searchNode->GetNode("logical")) != 0)
        SetLogical(node->AsBool());
    if((node = searchNode->GetNode("requestedLayer")) != 0)
        SetRequestedLayer(node->AsInt());
    if((node = searchNode->GetNode("seedType")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 2)
                SetSeedType(SeedIdType(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            SeedIdType value;
            if(SeedIdType_FromString(node->AsString(), value))
                SetSeedType(value);
        }
    }
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
OnionPeelAttributes::SetAdjacencyType(OnionPeelAttributes::NodeFace adjacencyType_)
{
    adjacencyType = adjacencyType_;
    Select(0, (void *)&adjacencyType);
}

void
OnionPeelAttributes::SetUseGlobalId(bool useGlobalId_)
{
    useGlobalId = useGlobalId_;
    Select(1, (void *)&useGlobalId);
}

void
OnionPeelAttributes::SetCategoryName(const std::string &categoryName_)
{
    categoryName = categoryName_;
    Select(2, (void *)&categoryName);
}

void
OnionPeelAttributes::SetSubsetName(const std::string &subsetName_)
{
    subsetName = subsetName_;
    Select(3, (void *)&subsetName);
}

void
OnionPeelAttributes::SetIndex(const intVector &index_)
{
    index = index_;
    Select(4, (void *)&index);
}

void
OnionPeelAttributes::SetLogical(bool logical_)
{
    logical = logical_;
    Select(5, (void *)&logical);
}

void
OnionPeelAttributes::SetRequestedLayer(int requestedLayer_)
{
    requestedLayer = requestedLayer_;
    Select(6, (void *)&requestedLayer);
}

void
OnionPeelAttributes::SetSeedType(OnionPeelAttributes::SeedIdType seedType_)
{
    seedType = seedType_;
    Select(7, (void *)&seedType);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

OnionPeelAttributes::NodeFace
OnionPeelAttributes::GetAdjacencyType() const
{
    return NodeFace(adjacencyType);
}

bool
OnionPeelAttributes::GetUseGlobalId() const
{
    return useGlobalId;
}

const std::string &
OnionPeelAttributes::GetCategoryName() const
{
    return categoryName;
}

std::string &
OnionPeelAttributes::GetCategoryName()
{
    return categoryName;
}

const std::string &
OnionPeelAttributes::GetSubsetName() const
{
    return subsetName;
}

std::string &
OnionPeelAttributes::GetSubsetName()
{
    return subsetName;
}

const intVector &
OnionPeelAttributes::GetIndex() const
{
    return index;
}

intVector &
OnionPeelAttributes::GetIndex()
{
    return index;
}

bool
OnionPeelAttributes::GetLogical() const
{
    return logical;
}

int
OnionPeelAttributes::GetRequestedLayer() const
{
    return requestedLayer;
}

OnionPeelAttributes::SeedIdType
OnionPeelAttributes::GetSeedType() const
{
    return SeedIdType(seedType);
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
OnionPeelAttributes::SelectCategoryName()
{
    Select(2, (void *)&categoryName);
}

void
OnionPeelAttributes::SelectSubsetName()
{
    Select(3, (void *)&subsetName);
}

void
OnionPeelAttributes::SelectIndex()
{
    Select(4, (void *)&index);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: OnionPeelAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Jan 19 15:42:52 PST 2005
//
// Modifications:
//   
// ****************************************************************************

std::string
OnionPeelAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "Adjacency";
        case 1:  return "useGlobalId";
        case 2:  return "Category";
        case 3:  return "Set";
        case 4:  return "Location";
        case 5:  return "Logical";
        case 6:  return "Layers";
        case 7:  return "Seed Type";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: OnionPeelAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Jan 19 15:42:52 PST 2005
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
OnionPeelAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_enum;
        case 1:  return FieldType_bool;
        case 2:  return FieldType_string;
        case 3:  return FieldType_string;
        case 4:  return FieldType_intVector;
        case 5:  return FieldType_bool;
        case 6:  return FieldType_int;
        case 7:  return FieldType_enum;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: OnionPeelAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Jan 19 15:42:52 PST 2005
//
// Modifications:
//   
// ****************************************************************************

std::string
OnionPeelAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "enum";
        case 1:  return "bool";
        case 2:  return "string";
        case 3:  return "string";
        case 4:  return "intVector";
        case 5:  return "bool";
        case 6:  return "int";
        case 7:  return "enum";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: OnionPeelAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Jan 19 15:42:52 PST 2005
//
// Modifications:
//   
// ****************************************************************************

bool
OnionPeelAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const OnionPeelAttributes &obj = *((const OnionPeelAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (adjacencyType == obj.adjacencyType);
        }
        break;
    case 1:
        {  // new scope
        retval = (useGlobalId == obj.useGlobalId);
        }
        break;
    case 2:
        {  // new scope
        retval = (categoryName == obj.categoryName);
        }
        break;
    case 3:
        {  // new scope
        retval = (subsetName == obj.subsetName);
        }
        break;
    case 4:
        {  // new scope
        retval = (index == obj.index);
        }
        break;
    case 5:
        {  // new scope
        retval = (logical == obj.logical);
        }
        break;
    case 6:
        {  // new scope
        retval = (requestedLayer == obj.requestedLayer);
        }
        break;
    case 7:
        {  // new scope
        retval = (seedType == obj.seedType);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

