#include <PyMetricThresholdAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyMetricThresholdAttributes
//
// Purpose: 
//   This class contains attributes for the MetricThreshold operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Tue Aug 20 16:16:22 PST 2002
//
// ****************************************************************************

//
// This struct contains the Python type information and a MetricThresholdAttributes.
//
struct MetricThresholdAttributesObject
{
    PyObject_HEAD
    MetricThresholdAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewMetricThresholdAttributes();

static PyObject *
MetricThresholdAttributes_Notify(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MetricThresholdAttributes_SetPreset(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the preset in the object.
    obj->data->SetPreset(MetricThresholdAttributes::Preset(ival));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MetricThresholdAttributes_GetPreset(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPreset()));
    return retval;
}

static PyObject *
MetricThresholdAttributes_SetHexahedron(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the Hexahedron in the object.
    obj->data->SetHexahedron(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MetricThresholdAttributes_GetHexahedron(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetHexahedron()?1L:0L);
    return retval;
}

static PyObject *
MetricThresholdAttributes_SetHex_lower(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the hex_lower in the object.
    obj->data->SetHex_lower(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MetricThresholdAttributes_GetHex_lower(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetHex_lower());
    return retval;
}

static PyObject *
MetricThresholdAttributes_SetHex_upper(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the hex_upper in the object.
    obj->data->SetHex_upper(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MetricThresholdAttributes_GetHex_upper(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetHex_upper());
    return retval;
}

static PyObject *
MetricThresholdAttributes_SetTetrahedron(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the Tetrahedron in the object.
    obj->data->SetTetrahedron(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MetricThresholdAttributes_GetTetrahedron(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetTetrahedron()?1L:0L);
    return retval;
}

static PyObject *
MetricThresholdAttributes_SetTet_lower(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the tet_lower in the object.
    obj->data->SetTet_lower(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MetricThresholdAttributes_GetTet_lower(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTet_lower());
    return retval;
}

static PyObject *
MetricThresholdAttributes_SetTet_upper(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the tet_upper in the object.
    obj->data->SetTet_upper(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MetricThresholdAttributes_GetTet_upper(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTet_upper());
    return retval;
}

static PyObject *
MetricThresholdAttributes_SetWedge(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the Wedge in the object.
    obj->data->SetWedge(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MetricThresholdAttributes_GetWedge(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetWedge()?1L:0L);
    return retval;
}

static PyObject *
MetricThresholdAttributes_SetWed_lower(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the wed_lower in the object.
    obj->data->SetWed_lower(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MetricThresholdAttributes_GetWed_lower(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetWed_lower());
    return retval;
}

static PyObject *
MetricThresholdAttributes_SetWed_upper(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the wed_upper in the object.
    obj->data->SetWed_upper(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MetricThresholdAttributes_GetWed_upper(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetWed_upper());
    return retval;
}

static PyObject *
MetricThresholdAttributes_SetPyramid(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the Pyramid in the object.
    obj->data->SetPyramid(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MetricThresholdAttributes_GetPyramid(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPyramid()?1L:0L);
    return retval;
}

static PyObject *
MetricThresholdAttributes_SetPyr_lower(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the pyr_lower in the object.
    obj->data->SetPyr_lower(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MetricThresholdAttributes_GetPyr_lower(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPyr_lower());
    return retval;
}

static PyObject *
MetricThresholdAttributes_SetPyr_upper(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the pyr_upper in the object.
    obj->data->SetPyr_upper(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MetricThresholdAttributes_GetPyr_upper(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPyr_upper());
    return retval;
}

static PyObject *
MetricThresholdAttributes_SetTriangle(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the Triangle in the object.
    obj->data->SetTriangle(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MetricThresholdAttributes_GetTriangle(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetTriangle()?1L:0L);
    return retval;
}

static PyObject *
MetricThresholdAttributes_SetTri_lower(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the tri_lower in the object.
    obj->data->SetTri_lower(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MetricThresholdAttributes_GetTri_lower(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTri_lower());
    return retval;
}

static PyObject *
MetricThresholdAttributes_SetTri_upper(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the tri_upper in the object.
    obj->data->SetTri_upper(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MetricThresholdAttributes_GetTri_upper(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTri_upper());
    return retval;
}

static PyObject *
MetricThresholdAttributes_SetQuad(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the Quad in the object.
    obj->data->SetQuad(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MetricThresholdAttributes_GetQuad(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetQuad()?1L:0L);
    return retval;
}

static PyObject *
MetricThresholdAttributes_SetQuad_lower(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the quad_lower in the object.
    obj->data->SetQuad_lower(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MetricThresholdAttributes_GetQuad_lower(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetQuad_lower());
    return retval;
}

static PyObject *
MetricThresholdAttributes_SetQuad_upper(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the quad_upper in the object.
    obj->data->SetQuad_upper(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MetricThresholdAttributes_GetQuad_upper(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetQuad_upper());
    return retval;
}



static struct PyMethodDef MetricThresholdAttributes_methods[] = {
    {"Notify", MetricThresholdAttributes_Notify, METH_VARARGS},
    {"SetPreset", MetricThresholdAttributes_SetPreset, METH_VARARGS},
    {"GetPreset", MetricThresholdAttributes_GetPreset, METH_VARARGS},
    {"SetHexahedron", MetricThresholdAttributes_SetHexahedron, METH_VARARGS},
    {"GetHexahedron", MetricThresholdAttributes_GetHexahedron, METH_VARARGS},
    {"SetHex_lower", MetricThresholdAttributes_SetHex_lower, METH_VARARGS},
    {"GetHex_lower", MetricThresholdAttributes_GetHex_lower, METH_VARARGS},
    {"SetHex_upper", MetricThresholdAttributes_SetHex_upper, METH_VARARGS},
    {"GetHex_upper", MetricThresholdAttributes_GetHex_upper, METH_VARARGS},
    {"SetTetrahedron", MetricThresholdAttributes_SetTetrahedron, METH_VARARGS},
    {"GetTetrahedron", MetricThresholdAttributes_GetTetrahedron, METH_VARARGS},
    {"SetTet_lower", MetricThresholdAttributes_SetTet_lower, METH_VARARGS},
    {"GetTet_lower", MetricThresholdAttributes_GetTet_lower, METH_VARARGS},
    {"SetTet_upper", MetricThresholdAttributes_SetTet_upper, METH_VARARGS},
    {"GetTet_upper", MetricThresholdAttributes_GetTet_upper, METH_VARARGS},
    {"SetWedge", MetricThresholdAttributes_SetWedge, METH_VARARGS},
    {"GetWedge", MetricThresholdAttributes_GetWedge, METH_VARARGS},
    {"SetWed_lower", MetricThresholdAttributes_SetWed_lower, METH_VARARGS},
    {"GetWed_lower", MetricThresholdAttributes_GetWed_lower, METH_VARARGS},
    {"SetWed_upper", MetricThresholdAttributes_SetWed_upper, METH_VARARGS},
    {"GetWed_upper", MetricThresholdAttributes_GetWed_upper, METH_VARARGS},
    {"SetPyramid", MetricThresholdAttributes_SetPyramid, METH_VARARGS},
    {"GetPyramid", MetricThresholdAttributes_GetPyramid, METH_VARARGS},
    {"SetPyr_lower", MetricThresholdAttributes_SetPyr_lower, METH_VARARGS},
    {"GetPyr_lower", MetricThresholdAttributes_GetPyr_lower, METH_VARARGS},
    {"SetPyr_upper", MetricThresholdAttributes_SetPyr_upper, METH_VARARGS},
    {"GetPyr_upper", MetricThresholdAttributes_GetPyr_upper, METH_VARARGS},
    {"SetTriangle", MetricThresholdAttributes_SetTriangle, METH_VARARGS},
    {"GetTriangle", MetricThresholdAttributes_GetTriangle, METH_VARARGS},
    {"SetTri_lower", MetricThresholdAttributes_SetTri_lower, METH_VARARGS},
    {"GetTri_lower", MetricThresholdAttributes_GetTri_lower, METH_VARARGS},
    {"SetTri_upper", MetricThresholdAttributes_SetTri_upper, METH_VARARGS},
    {"GetTri_upper", MetricThresholdAttributes_GetTri_upper, METH_VARARGS},
    {"SetQuad", MetricThresholdAttributes_SetQuad, METH_VARARGS},
    {"GetQuad", MetricThresholdAttributes_GetQuad, METH_VARARGS},
    {"SetQuad_lower", MetricThresholdAttributes_SetQuad_lower, METH_VARARGS},
    {"GetQuad_lower", MetricThresholdAttributes_GetQuad_lower, METH_VARARGS},
    {"SetQuad_upper", MetricThresholdAttributes_SetQuad_upper, METH_VARARGS},
    {"GetQuad_upper", MetricThresholdAttributes_GetQuad_upper, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
MetricThresholdAttributes_dealloc(PyObject *v)
{
   MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
MetricThresholdAttributes_compare(PyObject *v, PyObject *w)
{
    MetricThresholdAttributes *a = ((MetricThresholdAttributesObject *)v)->data;
    MetricThresholdAttributes *b = ((MetricThresholdAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
MetricThresholdAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "preset") == 0)
        return MetricThresholdAttributes_GetPreset(self, NULL);
    if(strcmp(name, "None") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::None));
    else if(strcmp(name, "Aspect_Ratio") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Aspect_Ratio));
    else if(strcmp(name, "Aspect_Gamma") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Aspect_Gamma));
    else if(strcmp(name, "Skew") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Skew));
    else if(strcmp(name, "Taper") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Taper));
    else if(strcmp(name, "Volume") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Volume));
    else if(strcmp(name, "Stretch") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Stretch));
    else if(strcmp(name, "Diagonal") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Diagonal));
    else if(strcmp(name, "Dimension") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Dimension));
    else if(strcmp(name, "Oddy") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Oddy));
    else if(strcmp(name, "Condition") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Condition));
    else if(strcmp(name, "Jacobian") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Jacobian));
    else if(strcmp(name, "Scaled_Jacobian") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Scaled_Jacobian));
    else if(strcmp(name, "Shear") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Shear));
    else if(strcmp(name, "Shape") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Shape));
    else if(strcmp(name, "Relative_Size") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Relative_Size));
    else if(strcmp(name, "Shape_and_Size") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Shape_and_Size));
    else if(strcmp(name, "Area") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Area));
    else if(strcmp(name, "Warpage") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Warpage));
    else if(strcmp(name, "Smallest_Angle") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Smallest_Angle));
    else if(strcmp(name, "Largest_Angle") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Largest_Angle));

    if(strcmp(name, "Hexahedron") == 0)
        return MetricThresholdAttributes_GetHexahedron(self, NULL);
    if(strcmp(name, "hex_lower") == 0)
        return MetricThresholdAttributes_GetHex_lower(self, NULL);
    if(strcmp(name, "hex_upper") == 0)
        return MetricThresholdAttributes_GetHex_upper(self, NULL);
    if(strcmp(name, "Tetrahedron") == 0)
        return MetricThresholdAttributes_GetTetrahedron(self, NULL);
    if(strcmp(name, "tet_lower") == 0)
        return MetricThresholdAttributes_GetTet_lower(self, NULL);
    if(strcmp(name, "tet_upper") == 0)
        return MetricThresholdAttributes_GetTet_upper(self, NULL);
    if(strcmp(name, "Wedge") == 0)
        return MetricThresholdAttributes_GetWedge(self, NULL);
    if(strcmp(name, "wed_lower") == 0)
        return MetricThresholdAttributes_GetWed_lower(self, NULL);
    if(strcmp(name, "wed_upper") == 0)
        return MetricThresholdAttributes_GetWed_upper(self, NULL);
    if(strcmp(name, "Pyramid") == 0)
        return MetricThresholdAttributes_GetPyramid(self, NULL);
    if(strcmp(name, "pyr_lower") == 0)
        return MetricThresholdAttributes_GetPyr_lower(self, NULL);
    if(strcmp(name, "pyr_upper") == 0)
        return MetricThresholdAttributes_GetPyr_upper(self, NULL);
    if(strcmp(name, "Triangle") == 0)
        return MetricThresholdAttributes_GetTriangle(self, NULL);
    if(strcmp(name, "tri_lower") == 0)
        return MetricThresholdAttributes_GetTri_lower(self, NULL);
    if(strcmp(name, "tri_upper") == 0)
        return MetricThresholdAttributes_GetTri_upper(self, NULL);
    if(strcmp(name, "Quad") == 0)
        return MetricThresholdAttributes_GetQuad(self, NULL);
    if(strcmp(name, "quad_lower") == 0)
        return MetricThresholdAttributes_GetQuad_lower(self, NULL);
    if(strcmp(name, "quad_upper") == 0)
        return MetricThresholdAttributes_GetQuad_upper(self, NULL);

    return Py_FindMethod(MetricThresholdAttributes_methods, self, name);
}

static int
MetricThresholdAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "preset") == 0)
        retval = (MetricThresholdAttributes_SetPreset(self, tuple) != NULL);
    else if(strcmp(name, "Hexahedron") == 0)
        retval = (MetricThresholdAttributes_SetHexahedron(self, tuple) != NULL);
    else if(strcmp(name, "hex_lower") == 0)
        retval = (MetricThresholdAttributes_SetHex_lower(self, tuple) != NULL);
    else if(strcmp(name, "hex_upper") == 0)
        retval = (MetricThresholdAttributes_SetHex_upper(self, tuple) != NULL);
    else if(strcmp(name, "Tetrahedron") == 0)
        retval = (MetricThresholdAttributes_SetTetrahedron(self, tuple) != NULL);
    else if(strcmp(name, "tet_lower") == 0)
        retval = (MetricThresholdAttributes_SetTet_lower(self, tuple) != NULL);
    else if(strcmp(name, "tet_upper") == 0)
        retval = (MetricThresholdAttributes_SetTet_upper(self, tuple) != NULL);
    else if(strcmp(name, "Wedge") == 0)
        retval = (MetricThresholdAttributes_SetWedge(self, tuple) != NULL);
    else if(strcmp(name, "wed_lower") == 0)
        retval = (MetricThresholdAttributes_SetWed_lower(self, tuple) != NULL);
    else if(strcmp(name, "wed_upper") == 0)
        retval = (MetricThresholdAttributes_SetWed_upper(self, tuple) != NULL);
    else if(strcmp(name, "Pyramid") == 0)
        retval = (MetricThresholdAttributes_SetPyramid(self, tuple) != NULL);
    else if(strcmp(name, "pyr_lower") == 0)
        retval = (MetricThresholdAttributes_SetPyr_lower(self, tuple) != NULL);
    else if(strcmp(name, "pyr_upper") == 0)
        retval = (MetricThresholdAttributes_SetPyr_upper(self, tuple) != NULL);
    else if(strcmp(name, "Triangle") == 0)
        retval = (MetricThresholdAttributes_SetTriangle(self, tuple) != NULL);
    else if(strcmp(name, "tri_lower") == 0)
        retval = (MetricThresholdAttributes_SetTri_lower(self, tuple) != NULL);
    else if(strcmp(name, "tri_upper") == 0)
        retval = (MetricThresholdAttributes_SetTri_upper(self, tuple) != NULL);
    else if(strcmp(name, "Quad") == 0)
        retval = (MetricThresholdAttributes_SetQuad(self, tuple) != NULL);
    else if(strcmp(name, "quad_lower") == 0)
        retval = (MetricThresholdAttributes_SetQuad_lower(self, tuple) != NULL);
    else if(strcmp(name, "quad_upper") == 0)
        retval = (MetricThresholdAttributes_SetQuad_upper(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
MetricThresholdAttributes_print(PyObject *v, FILE *fp, int flags)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)v;

    if(obj->data->GetPreset() == MetricThresholdAttributes::None)
        fprintf(fp, "preset = None\n");
    else if(obj->data->GetPreset() == MetricThresholdAttributes::Aspect_Ratio)
        fprintf(fp, "preset = Aspect_Ratio\n");
    else if(obj->data->GetPreset() == MetricThresholdAttributes::Aspect_Gamma)
        fprintf(fp, "preset = Aspect_Gamma\n");
    else if(obj->data->GetPreset() == MetricThresholdAttributes::Skew)
        fprintf(fp, "preset = Skew\n");
    else if(obj->data->GetPreset() == MetricThresholdAttributes::Taper)
        fprintf(fp, "preset = Taper\n");
    else if(obj->data->GetPreset() == MetricThresholdAttributes::Volume)
        fprintf(fp, "preset = Volume\n");
    else if(obj->data->GetPreset() == MetricThresholdAttributes::Stretch)
        fprintf(fp, "preset = Stretch\n");
    else if(obj->data->GetPreset() == MetricThresholdAttributes::Diagonal)
        fprintf(fp, "preset = Diagonal\n");
    else if(obj->data->GetPreset() == MetricThresholdAttributes::Dimension)
        fprintf(fp, "preset = Dimension\n");
    else if(obj->data->GetPreset() == MetricThresholdAttributes::Oddy)
        fprintf(fp, "preset = Oddy\n");
    else if(obj->data->GetPreset() == MetricThresholdAttributes::Condition)
        fprintf(fp, "preset = Condition\n");
    else if(obj->data->GetPreset() == MetricThresholdAttributes::Jacobian)
        fprintf(fp, "preset = Jacobian\n");
    else if(obj->data->GetPreset() == MetricThresholdAttributes::Scaled_Jacobian)
        fprintf(fp, "preset = Scaled_Jacobian\n");
    else if(obj->data->GetPreset() == MetricThresholdAttributes::Shear)
        fprintf(fp, "preset = Shear\n");
    else if(obj->data->GetPreset() == MetricThresholdAttributes::Shape)
        fprintf(fp, "preset = Shape\n");
    else if(obj->data->GetPreset() == MetricThresholdAttributes::Relative_Size)
        fprintf(fp, "preset = Relative_Size\n");
    else if(obj->data->GetPreset() == MetricThresholdAttributes::Shape_and_Size)
        fprintf(fp, "preset = Shape_and_Size\n");
    else if(obj->data->GetPreset() == MetricThresholdAttributes::Area)
        fprintf(fp, "preset = Area\n");
    else if(obj->data->GetPreset() == MetricThresholdAttributes::Warpage)
        fprintf(fp, "preset = Warpage\n");
    else if(obj->data->GetPreset() == MetricThresholdAttributes::Smallest_Angle)
        fprintf(fp, "preset = Smallest_Angle\n");
    else
        fprintf(fp, "preset = Largest_Angle\n");

    if(obj->data->GetHexahedron())
        fprintf(fp, "Hexahedron = 1\n");
    else
        fprintf(fp, "Hexahedron = 0\n");
    fprintf(fp, "hex_lower = %g\n", obj->data->GetHex_lower());
    fprintf(fp, "hex_upper = %g\n", obj->data->GetHex_upper());
    if(obj->data->GetTetrahedron())
        fprintf(fp, "Tetrahedron = 1\n");
    else
        fprintf(fp, "Tetrahedron = 0\n");
    fprintf(fp, "tet_lower = %g\n", obj->data->GetTet_lower());
    fprintf(fp, "tet_upper = %g\n", obj->data->GetTet_upper());
    if(obj->data->GetWedge())
        fprintf(fp, "Wedge = 1\n");
    else
        fprintf(fp, "Wedge = 0\n");
    fprintf(fp, "wed_lower = %g\n", obj->data->GetWed_lower());
    fprintf(fp, "wed_upper = %g\n", obj->data->GetWed_upper());
    if(obj->data->GetPyramid())
        fprintf(fp, "Pyramid = 1\n");
    else
        fprintf(fp, "Pyramid = 0\n");
    fprintf(fp, "pyr_lower = %g\n", obj->data->GetPyr_lower());
    fprintf(fp, "pyr_upper = %g\n", obj->data->GetPyr_upper());
    if(obj->data->GetTriangle())
        fprintf(fp, "Triangle = 1\n");
    else
        fprintf(fp, "Triangle = 0\n");
    fprintf(fp, "tri_lower = %g\n", obj->data->GetTri_lower());
    fprintf(fp, "tri_upper = %g\n", obj->data->GetTri_upper());
    if(obj->data->GetQuad())
        fprintf(fp, "Quad = 1\n");
    else
        fprintf(fp, "Quad = 0\n");
    fprintf(fp, "quad_lower = %g\n", obj->data->GetQuad_lower());
    fprintf(fp, "quad_upper = %g\n", obj->data->GetQuad_upper());

    return 0;
}

//
// The doc string for the class.
//
static char *MetricThresholdAttributes_Purpose = "This class contains attributes for the MetricThreshold operator.";

//
// The type description structure
//
static PyTypeObject MetricThresholdAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "MetricThresholdAttributes",                    // tp_name
    sizeof(MetricThresholdAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)MetricThresholdAttributes_dealloc,  // tp_dealloc
    (printfunc)MetricThresholdAttributes_print,     // tp_print
    (getattrfunc)MetricThresholdAttributes_getattr, // tp_getattr
    (setattrfunc)MetricThresholdAttributes_setattr, // tp_setattr
    (cmpfunc)MetricThresholdAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    0,                                   // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    MetricThresholdAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static MetricThresholdAttributes *defaultAtts = 0;

static PyObject *
NewMetricThresholdAttributes()
{
    MetricThresholdAttributesObject *newObject;
    newObject = PyObject_NEW(MetricThresholdAttributesObject, &MetricThresholdAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new MetricThresholdAttributes(*defaultAtts);
    else
        newObject->data = new MetricThresholdAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapMetricThresholdAttributes(const MetricThresholdAttributes *attr)
{
    MetricThresholdAttributesObject *newObject;
    newObject = PyObject_NEW(MetricThresholdAttributesObject, &MetricThresholdAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (MetricThresholdAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
MetricThresholdAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewMetricThresholdAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef MetricThresholdAttributesMethods[] = {
    {"MetricThresholdAttributes", MetricThresholdAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *MetricThresholdAttributesObserver = 0;
static bool MetricThresholdAttributesEnableLogging = true;

static void
PyMetricThresholdAttributes_WriteLog(Subject *subj, void *data)
{
    MetricThresholdAttributes *atts = (MetricThresholdAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!MetricThresholdAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# MetricThresholdAttributes_WriteLog()\n");
}

void
PyMetricThresholdAttributes_StartUp(MetricThresholdAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyMetricThresholdAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(MetricThresholdAttributesObserver == 0)
    {
        MetricThresholdAttributesObserver = new ObserverToCallback(subj,
            PyMetricThresholdAttributes_WriteLog, (void *)logFile);
    }

    MetricThresholdAttributesEnableLogging = true;
}

void
PyMetricThresholdAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete MetricThresholdAttributesObserver;
    MetricThresholdAttributesObserver = 0;
}

PyMethodDef *
PyMetricThresholdAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return MetricThresholdAttributesMethods;
}

bool
PyMetricThresholdAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &MetricThresholdAttributesType);
}

MetricThresholdAttributes *
PyMetricThresholdAttributes_FromPyObject(PyObject *obj)
{
    MetricThresholdAttributesObject *obj2 = (MetricThresholdAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyMetricThresholdAttributes_NewPyObject()
{
    return NewMetricThresholdAttributes();
}

PyObject *
PyMetricThresholdAttributes_WrapPyObject(const MetricThresholdAttributes *attr)
{
    return WrapMetricThresholdAttributes(attr);
}

void
PyMetricThresholdAttributes_SetLogging(bool val)
{
    MetricThresholdAttributesEnableLogging = val;
}

void
PyMetricThresholdAttributes_SetDefaults(const MetricThresholdAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new MetricThresholdAttributes(*atts);
}

