// ************************************************************************* //
//  File: MetricThresholdViewerPluginInfo.C
// ************************************************************************* //

#include <MetricThresholdPluginInfo.h>
#include <MetricThresholdAttributes.h>

#if defined(__APPLE__)
#define GetViewerInfo MetricThreshold_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the MetricThreshold operator.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:03:50 PST 2003
//
// ****************************************************************************
extern "C" ViewerOperatorPluginInfo* GetViewerInfo()
{
    MetricThresholdViewerPluginInfo::InitializeGlobalObjects();
    return new MetricThresholdViewerPluginInfo;
}

//
// Storage for static data elements.
//
MetricThresholdAttributes *MetricThresholdViewerPluginInfo::clientAtts = NULL;
MetricThresholdAttributes *MetricThresholdViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  MetricThresholdViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:03:50 PST 2003
//
// ****************************************************************************
void
MetricThresholdViewerPluginInfo::InitializeGlobalObjects()
{
    MetricThresholdViewerPluginInfo::clientAtts  = new MetricThresholdAttributes;
    MetricThresholdViewerPluginInfo::defaultAtts = new MetricThresholdAttributes;
}

// ****************************************************************************
//  Method: MetricThresholdViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:03:50 PST 2003
//
// ****************************************************************************

AttributeSubject *
MetricThresholdViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: MetricThresholdViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:03:50 PST 2003
//
// ****************************************************************************

AttributeSubject *
MetricThresholdViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: MetricThresholdViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:03:50 PST 2003
//
// ****************************************************************************

void
MetricThresholdViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(MetricThresholdAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: MetricThresholdViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:03:50 PST 2003
//
// ****************************************************************************

void
MetricThresholdViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(MetricThresholdAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: MetricThresholdViewerPluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:03:50 PST 2003
//
// ****************************************************************************

void
MetricThresholdViewerPluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const ViewerPlot *plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(MetricThresholdAttributes*)atts = *defaultAtts;
    else
        *(MetricThresholdAttributes*)atts = *clientAtts;
}
