// ************************************************************************* //
//  File: MetricThresholdGUIPluginInfo.C
// ************************************************************************* //

#include <MetricThresholdPluginInfo.h>
#include <MetricThresholdAttributes.h>
#include <QvisMetricThresholdWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo MetricThreshold_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the MetricThreshold operator.
//
//  Programmer: haddox1 -- generated by xml2info
//  Creation:   Tue Aug 20 16:14:49 PST 2002
//
// ****************************************************************************
extern "C" GUIOperatorPluginInfo* GetGUIInfo()
{
    return new MetricThresholdGUIPluginInfo;
}

// ****************************************************************************
//  Method: MetricThresholdGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: haddox1 -- generated by xml2info
//  Creation:   Tue Aug 20 16:14:49 PST 2002
//
// ****************************************************************************

const char *
MetricThresholdGUIPluginInfo::GetMenuName() const
{
    return "Metric Threshold";
}


// ****************************************************************************
//  Method: MetricThresholdGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: haddox1 -- generated by xml2info
//  Creation:   Tue Aug 20 16:14:49 PST 2002
//
// ****************************************************************************

QvisPostableWindowObserver *
MetricThresholdGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisMetricThresholdWindow(type, (MetricThresholdAttributes *)attr,
        "Metric Threshold operator attributes", "MetricThreshold operator", notepad);
}
