#ifndef METRICTHRESHOLDATTRIBUTES_H
#define METRICTHRESHOLDATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>

// ****************************************************************************
// Class: MetricThresholdAttributes
//
// Purpose:
//    This class contains attributes for the MetricThreshold operator.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:55 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

class MetricThresholdAttributes : public AttributeSubject
{
public:
    enum Preset
    {
        None,
        Aspect_Ratio,
        Aspect_Gamma,
        Skew,
        Taper,
        Volume,
        Stretch,
        Diagonal,
        Dimension,
        Oddy,
        Condition,
        Jacobian,
        Scaled_Jacobian,
        Shear,
        Shape,
        Relative_Size,
        Shape_and_Size,
        Area,
        Warpage,
        Smallest_Angle,
        Largest_Angle
    };

    MetricThresholdAttributes();
    MetricThresholdAttributes(const MetricThresholdAttributes &obj);
    virtual ~MetricThresholdAttributes();

    virtual void operator = (const MetricThresholdAttributes &obj);
    virtual bool operator == (const MetricThresholdAttributes &obj) const;
    virtual bool operator != (const MetricThresholdAttributes &obj) const;

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();

    // Property setting methods
    void SetPreset(Preset preset_);
    void SetHexahedron(bool Hexahedron_);
    void SetHex_lower(double hex_lower_);
    void SetHex_upper(double hex_upper_);
    void SetTetrahedron(bool Tetrahedron_);
    void SetTet_lower(double tet_lower_);
    void SetTet_upper(double tet_upper_);
    void SetWedge(bool Wedge_);
    void SetWed_lower(double wed_lower_);
    void SetWed_upper(double wed_upper_);
    void SetPyramid(bool Pyramid_);
    void SetPyr_lower(double pyr_lower_);
    void SetPyr_upper(double pyr_upper_);
    void SetTriangle(bool Triangle_);
    void SetTri_lower(double tri_lower_);
    void SetTri_upper(double tri_upper_);
    void SetQuad(bool Quad_);
    void SetQuad_lower(double quad_lower_);
    void SetQuad_upper(double quad_upper_);

    // Property getting methods
    Preset GetPreset() const;
    bool   GetHexahedron() const;
    double GetHex_lower() const;
    double GetHex_upper() const;
    bool   GetTetrahedron() const;
    double GetTet_lower() const;
    double GetTet_upper() const;
    bool   GetWedge() const;
    double GetWed_lower() const;
    double GetWed_upper() const;
    bool   GetPyramid() const;
    double GetPyr_lower() const;
    double GetPyr_upper() const;
    bool   GetTriangle() const;
    double GetTri_lower() const;
    double GetTri_upper() const;
    bool   GetQuad() const;
    double GetQuad_lower() const;
    double GetQuad_upper() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string Preset_ToString(Preset);
    static bool Preset_FromString(const std::string &, Preset &);
protected:
    static std::string Preset_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

private:
    int    preset;
    bool   Hexahedron;
    double hex_lower;
    double hex_upper;
    bool   Tetrahedron;
    double tet_lower;
    double tet_upper;
    bool   Wedge;
    double wed_lower;
    double wed_upper;
    bool   Pyramid;
    double pyr_lower;
    double pyr_upper;
    bool   Triangle;
    double tri_lower;
    double tri_upper;
    bool   Quad;
    double quad_lower;
    double quad_upper;
};

#endif
