#include <MetricThresholdAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for MetricThresholdAttributes::Preset
//

static const char *Preset_strings[] = {
"None", "Aspect_Ratio", "Aspect_Gamma", 
"Skew", "Taper", "Volume", 
"Stretch", "Diagonal", "Dimension", 
"Oddy", "Condition", "Jacobian", 
"Scaled_Jacobian", "Shear", "Shape", 
"Relative_Size", "Shape_and_Size", "Area", 
"Warpage", "Smallest_Angle", "Largest_Angle"
};

std::string
MetricThresholdAttributes::Preset_ToString(MetricThresholdAttributes::Preset t)
{
    int index = int(t);
    if(index < 0 || index >= 21) index = 0;
    return Preset_strings[index];
}

std::string
MetricThresholdAttributes::Preset_ToString(int t)
{
    int index = (t < 0 || t >= 21) ? 0 : t;
    return Preset_strings[index];
}

bool
MetricThresholdAttributes::Preset_FromString(const std::string &s, MetricThresholdAttributes::Preset &val)
{
    val = MetricThresholdAttributes::None;
    for(int i = 0; i < 21; ++i)
    {
        if(s == Preset_strings[i])
        {
            val = (Preset)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: MetricThresholdAttributes::MetricThresholdAttributes
//
// Purpose: 
//   Constructor for the MetricThresholdAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:55 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

MetricThresholdAttributes::MetricThresholdAttributes() : AttributeSubject("ibddbddbddbddbddbdd")
{
    preset = None;
    Hexahedron = false;
    hex_lower = 0;
    hex_upper = 0;
    Tetrahedron = false;
    tet_lower = 0;
    tet_upper = 0;
    Wedge = false;
    wed_lower = 0;
    wed_upper = 0;
    Pyramid = false;
    pyr_lower = 0;
    pyr_upper = 0;
    Triangle = false;
    tri_lower = 0;
    tri_upper = 0;
    Quad = false;
    quad_lower = 0;
    quad_upper = 0;
}

// ****************************************************************************
// Method: MetricThresholdAttributes::MetricThresholdAttributes
//
// Purpose: 
//   Copy constructor for the MetricThresholdAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:55 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

MetricThresholdAttributes::MetricThresholdAttributes(const MetricThresholdAttributes &obj) : AttributeSubject("ibddbddbddbddbddbdd")
{
    preset = obj.preset;
    Hexahedron = obj.Hexahedron;
    hex_lower = obj.hex_lower;
    hex_upper = obj.hex_upper;
    Tetrahedron = obj.Tetrahedron;
    tet_lower = obj.tet_lower;
    tet_upper = obj.tet_upper;
    Wedge = obj.Wedge;
    wed_lower = obj.wed_lower;
    wed_upper = obj.wed_upper;
    Pyramid = obj.Pyramid;
    pyr_lower = obj.pyr_lower;
    pyr_upper = obj.pyr_upper;
    Triangle = obj.Triangle;
    tri_lower = obj.tri_lower;
    tri_upper = obj.tri_upper;
    Quad = obj.Quad;
    quad_lower = obj.quad_lower;
    quad_upper = obj.quad_upper;

    SelectAll();
}

// ****************************************************************************
// Method: MetricThresholdAttributes::~MetricThresholdAttributes
//
// Purpose: 
//   Destructor for the MetricThresholdAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:55 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

MetricThresholdAttributes::~MetricThresholdAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: MetricThresholdAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the MetricThresholdAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:55 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
MetricThresholdAttributes::operator = (const MetricThresholdAttributes &obj)
{
    preset = obj.preset;
    Hexahedron = obj.Hexahedron;
    hex_lower = obj.hex_lower;
    hex_upper = obj.hex_upper;
    Tetrahedron = obj.Tetrahedron;
    tet_lower = obj.tet_lower;
    tet_upper = obj.tet_upper;
    Wedge = obj.Wedge;
    wed_lower = obj.wed_lower;
    wed_upper = obj.wed_upper;
    Pyramid = obj.Pyramid;
    pyr_lower = obj.pyr_lower;
    pyr_upper = obj.pyr_upper;
    Triangle = obj.Triangle;
    tri_lower = obj.tri_lower;
    tri_upper = obj.tri_upper;
    Quad = obj.Quad;
    quad_lower = obj.quad_lower;
    quad_upper = obj.quad_upper;

    SelectAll();
}

// ****************************************************************************
// Method: MetricThresholdAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the MetricThresholdAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:55 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
MetricThresholdAttributes::operator == (const MetricThresholdAttributes &obj) const
{
    // Create the return value
    return ((preset == obj.preset) &&
            (Hexahedron == obj.Hexahedron) &&
            (hex_lower == obj.hex_lower) &&
            (hex_upper == obj.hex_upper) &&
            (Tetrahedron == obj.Tetrahedron) &&
            (tet_lower == obj.tet_lower) &&
            (tet_upper == obj.tet_upper) &&
            (Wedge == obj.Wedge) &&
            (wed_lower == obj.wed_lower) &&
            (wed_upper == obj.wed_upper) &&
            (Pyramid == obj.Pyramid) &&
            (pyr_lower == obj.pyr_lower) &&
            (pyr_upper == obj.pyr_upper) &&
            (Triangle == obj.Triangle) &&
            (tri_lower == obj.tri_lower) &&
            (tri_upper == obj.tri_upper) &&
            (Quad == obj.Quad) &&
            (quad_lower == obj.quad_lower) &&
            (quad_upper == obj.quad_upper));
}

// ****************************************************************************
// Method: MetricThresholdAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the MetricThresholdAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:55 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
MetricThresholdAttributes::operator != (const MetricThresholdAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: MetricThresholdAttributes::TypeName
//
// Purpose: 
//   Type name method for the MetricThresholdAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:55 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const std::string
MetricThresholdAttributes::TypeName() const
{
    return "MetricThresholdAttributes";
}

// ****************************************************************************
// Method: MetricThresholdAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the MetricThresholdAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:55 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
MetricThresholdAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const MetricThresholdAttributes *tmp = (const MetricThresholdAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: MetricThresholdAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the MetricThresholdAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:55 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
MetricThresholdAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new MetricThresholdAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: MetricThresholdAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the MetricThresholdAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:55 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
MetricThresholdAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new MetricThresholdAttributes(*this);
    else
        retval = new MetricThresholdAttributes;

    return retval;
}

// ****************************************************************************
// Method: MetricThresholdAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:55 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
MetricThresholdAttributes::SelectAll()
{
    Select(0, (void *)&preset);
    Select(1, (void *)&Hexahedron);
    Select(2, (void *)&hex_lower);
    Select(3, (void *)&hex_upper);
    Select(4, (void *)&Tetrahedron);
    Select(5, (void *)&tet_lower);
    Select(6, (void *)&tet_upper);
    Select(7, (void *)&Wedge);
    Select(8, (void *)&wed_lower);
    Select(9, (void *)&wed_upper);
    Select(10, (void *)&Pyramid);
    Select(11, (void *)&pyr_lower);
    Select(12, (void *)&pyr_upper);
    Select(13, (void *)&Triangle);
    Select(14, (void *)&tri_lower);
    Select(15, (void *)&tri_upper);
    Select(16, (void *)&Quad);
    Select(17, (void *)&quad_lower);
    Select(18, (void *)&quad_upper);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: MetricThresholdAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:55 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
MetricThresholdAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    MetricThresholdAttributes defaultObject;
    bool addToParent = false;
    // Create a node for MetricThresholdAttributes.
    DataNode *node = new DataNode("MetricThresholdAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("preset", Preset_ToString(preset)));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("Hexahedron", Hexahedron));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("hex_lower", hex_lower));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("hex_upper", hex_upper));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("Tetrahedron", Tetrahedron));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("tet_lower", tet_lower));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("tet_upper", tet_upper));
    }

    if(completeSave || !FieldsEqual(7, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("Wedge", Wedge));
    }

    if(completeSave || !FieldsEqual(8, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("wed_lower", wed_lower));
    }

    if(completeSave || !FieldsEqual(9, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("wed_upper", wed_upper));
    }

    if(completeSave || !FieldsEqual(10, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("Pyramid", Pyramid));
    }

    if(completeSave || !FieldsEqual(11, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("pyr_lower", pyr_lower));
    }

    if(completeSave || !FieldsEqual(12, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("pyr_upper", pyr_upper));
    }

    if(completeSave || !FieldsEqual(13, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("Triangle", Triangle));
    }

    if(completeSave || !FieldsEqual(14, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("tri_lower", tri_lower));
    }

    if(completeSave || !FieldsEqual(15, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("tri_upper", tri_upper));
    }

    if(completeSave || !FieldsEqual(16, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("Quad", Quad));
    }

    if(completeSave || !FieldsEqual(17, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("quad_lower", quad_lower));
    }

    if(completeSave || !FieldsEqual(18, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("quad_upper", quad_upper));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: MetricThresholdAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:55 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
MetricThresholdAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("MetricThresholdAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("preset")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 21)
                SetPreset(Preset(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Preset value;
            if(Preset_FromString(node->AsString(), value))
                SetPreset(value);
        }
    }
    if((node = searchNode->GetNode("Hexahedron")) != 0)
        SetHexahedron(node->AsBool());
    if((node = searchNode->GetNode("hex_lower")) != 0)
        SetHex_lower(node->AsDouble());
    if((node = searchNode->GetNode("hex_upper")) != 0)
        SetHex_upper(node->AsDouble());
    if((node = searchNode->GetNode("Tetrahedron")) != 0)
        SetTetrahedron(node->AsBool());
    if((node = searchNode->GetNode("tet_lower")) != 0)
        SetTet_lower(node->AsDouble());
    if((node = searchNode->GetNode("tet_upper")) != 0)
        SetTet_upper(node->AsDouble());
    if((node = searchNode->GetNode("Wedge")) != 0)
        SetWedge(node->AsBool());
    if((node = searchNode->GetNode("wed_lower")) != 0)
        SetWed_lower(node->AsDouble());
    if((node = searchNode->GetNode("wed_upper")) != 0)
        SetWed_upper(node->AsDouble());
    if((node = searchNode->GetNode("Pyramid")) != 0)
        SetPyramid(node->AsBool());
    if((node = searchNode->GetNode("pyr_lower")) != 0)
        SetPyr_lower(node->AsDouble());
    if((node = searchNode->GetNode("pyr_upper")) != 0)
        SetPyr_upper(node->AsDouble());
    if((node = searchNode->GetNode("Triangle")) != 0)
        SetTriangle(node->AsBool());
    if((node = searchNode->GetNode("tri_lower")) != 0)
        SetTri_lower(node->AsDouble());
    if((node = searchNode->GetNode("tri_upper")) != 0)
        SetTri_upper(node->AsDouble());
    if((node = searchNode->GetNode("Quad")) != 0)
        SetQuad(node->AsBool());
    if((node = searchNode->GetNode("quad_lower")) != 0)
        SetQuad_lower(node->AsDouble());
    if((node = searchNode->GetNode("quad_upper")) != 0)
        SetQuad_upper(node->AsDouble());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
MetricThresholdAttributes::SetPreset(MetricThresholdAttributes::Preset preset_)
{
    preset = preset_;
    Select(0, (void *)&preset);
}

void
MetricThresholdAttributes::SetHexahedron(bool Hexahedron_)
{
    Hexahedron = Hexahedron_;
    Select(1, (void *)&Hexahedron);
}

void
MetricThresholdAttributes::SetHex_lower(double hex_lower_)
{
    hex_lower = hex_lower_;
    Select(2, (void *)&hex_lower);
}

void
MetricThresholdAttributes::SetHex_upper(double hex_upper_)
{
    hex_upper = hex_upper_;
    Select(3, (void *)&hex_upper);
}

void
MetricThresholdAttributes::SetTetrahedron(bool Tetrahedron_)
{
    Tetrahedron = Tetrahedron_;
    Select(4, (void *)&Tetrahedron);
}

void
MetricThresholdAttributes::SetTet_lower(double tet_lower_)
{
    tet_lower = tet_lower_;
    Select(5, (void *)&tet_lower);
}

void
MetricThresholdAttributes::SetTet_upper(double tet_upper_)
{
    tet_upper = tet_upper_;
    Select(6, (void *)&tet_upper);
}

void
MetricThresholdAttributes::SetWedge(bool Wedge_)
{
    Wedge = Wedge_;
    Select(7, (void *)&Wedge);
}

void
MetricThresholdAttributes::SetWed_lower(double wed_lower_)
{
    wed_lower = wed_lower_;
    Select(8, (void *)&wed_lower);
}

void
MetricThresholdAttributes::SetWed_upper(double wed_upper_)
{
    wed_upper = wed_upper_;
    Select(9, (void *)&wed_upper);
}

void
MetricThresholdAttributes::SetPyramid(bool Pyramid_)
{
    Pyramid = Pyramid_;
    Select(10, (void *)&Pyramid);
}

void
MetricThresholdAttributes::SetPyr_lower(double pyr_lower_)
{
    pyr_lower = pyr_lower_;
    Select(11, (void *)&pyr_lower);
}

void
MetricThresholdAttributes::SetPyr_upper(double pyr_upper_)
{
    pyr_upper = pyr_upper_;
    Select(12, (void *)&pyr_upper);
}

void
MetricThresholdAttributes::SetTriangle(bool Triangle_)
{
    Triangle = Triangle_;
    Select(13, (void *)&Triangle);
}

void
MetricThresholdAttributes::SetTri_lower(double tri_lower_)
{
    tri_lower = tri_lower_;
    Select(14, (void *)&tri_lower);
}

void
MetricThresholdAttributes::SetTri_upper(double tri_upper_)
{
    tri_upper = tri_upper_;
    Select(15, (void *)&tri_upper);
}

void
MetricThresholdAttributes::SetQuad(bool Quad_)
{
    Quad = Quad_;
    Select(16, (void *)&Quad);
}

void
MetricThresholdAttributes::SetQuad_lower(double quad_lower_)
{
    quad_lower = quad_lower_;
    Select(17, (void *)&quad_lower);
}

void
MetricThresholdAttributes::SetQuad_upper(double quad_upper_)
{
    quad_upper = quad_upper_;
    Select(18, (void *)&quad_upper);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

MetricThresholdAttributes::Preset
MetricThresholdAttributes::GetPreset() const
{
    return Preset(preset);
}

bool
MetricThresholdAttributes::GetHexahedron() const
{
    return Hexahedron;
}

double
MetricThresholdAttributes::GetHex_lower() const
{
    return hex_lower;
}

double
MetricThresholdAttributes::GetHex_upper() const
{
    return hex_upper;
}

bool
MetricThresholdAttributes::GetTetrahedron() const
{
    return Tetrahedron;
}

double
MetricThresholdAttributes::GetTet_lower() const
{
    return tet_lower;
}

double
MetricThresholdAttributes::GetTet_upper() const
{
    return tet_upper;
}

bool
MetricThresholdAttributes::GetWedge() const
{
    return Wedge;
}

double
MetricThresholdAttributes::GetWed_lower() const
{
    return wed_lower;
}

double
MetricThresholdAttributes::GetWed_upper() const
{
    return wed_upper;
}

bool
MetricThresholdAttributes::GetPyramid() const
{
    return Pyramid;
}

double
MetricThresholdAttributes::GetPyr_lower() const
{
    return pyr_lower;
}

double
MetricThresholdAttributes::GetPyr_upper() const
{
    return pyr_upper;
}

bool
MetricThresholdAttributes::GetTriangle() const
{
    return Triangle;
}

double
MetricThresholdAttributes::GetTri_lower() const
{
    return tri_lower;
}

double
MetricThresholdAttributes::GetTri_upper() const
{
    return tri_upper;
}

bool
MetricThresholdAttributes::GetQuad() const
{
    return Quad;
}

double
MetricThresholdAttributes::GetQuad_lower() const
{
    return quad_lower;
}

double
MetricThresholdAttributes::GetQuad_upper() const
{
    return quad_upper;
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: MetricThresholdAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
MetricThresholdAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "preset";
        case 1:  return "Hexahedron";
        case 2:  return "hex_lower";
        case 3:  return "hex_upper";
        case 4:  return "Tetrahedron";
        case 5:  return "tet_lower";
        case 6:  return "tet_upper";
        case 7:  return "Wedge";
        case 8:  return "wed_lower";
        case 9:  return "wed_upper";
        case 10:  return "Pyramid";
        case 11:  return "pyr_lower";
        case 12:  return "pyr_upper";
        case 13:  return "Triangle";
        case 14:  return "tri_lower";
        case 15:  return "tri_upper";
        case 16:  return "Quad";
        case 17:  return "quad_lower";
        case 18:  return "quad_upper";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: MetricThresholdAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
MetricThresholdAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_enum;
        case 1:  return FieldType_bool;
        case 2:  return FieldType_double;
        case 3:  return FieldType_double;
        case 4:  return FieldType_bool;
        case 5:  return FieldType_double;
        case 6:  return FieldType_double;
        case 7:  return FieldType_bool;
        case 8:  return FieldType_double;
        case 9:  return FieldType_double;
        case 10:  return FieldType_bool;
        case 11:  return FieldType_double;
        case 12:  return FieldType_double;
        case 13:  return FieldType_bool;
        case 14:  return FieldType_double;
        case 15:  return FieldType_double;
        case 16:  return FieldType_bool;
        case 17:  return FieldType_double;
        case 18:  return FieldType_double;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: MetricThresholdAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
MetricThresholdAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "enum";
        case 1:  return "bool";
        case 2:  return "double";
        case 3:  return "double";
        case 4:  return "bool";
        case 5:  return "double";
        case 6:  return "double";
        case 7:  return "bool";
        case 8:  return "double";
        case 9:  return "double";
        case 10:  return "bool";
        case 11:  return "double";
        case 12:  return "double";
        case 13:  return "bool";
        case 14:  return "double";
        case 15:  return "double";
        case 16:  return "bool";
        case 17:  return "double";
        case 18:  return "double";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: MetricThresholdAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
MetricThresholdAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const MetricThresholdAttributes &obj = *((const MetricThresholdAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (preset == obj.preset);
        }
        break;
    case 1:
        {  // new scope
        retval = (Hexahedron == obj.Hexahedron);
        }
        break;
    case 2:
        {  // new scope
        retval = (hex_lower == obj.hex_lower);
        }
        break;
    case 3:
        {  // new scope
        retval = (hex_upper == obj.hex_upper);
        }
        break;
    case 4:
        {  // new scope
        retval = (Tetrahedron == obj.Tetrahedron);
        }
        break;
    case 5:
        {  // new scope
        retval = (tet_lower == obj.tet_lower);
        }
        break;
    case 6:
        {  // new scope
        retval = (tet_upper == obj.tet_upper);
        }
        break;
    case 7:
        {  // new scope
        retval = (Wedge == obj.Wedge);
        }
        break;
    case 8:
        {  // new scope
        retval = (wed_lower == obj.wed_lower);
        }
        break;
    case 9:
        {  // new scope
        retval = (wed_upper == obj.wed_upper);
        }
        break;
    case 10:
        {  // new scope
        retval = (Pyramid == obj.Pyramid);
        }
        break;
    case 11:
        {  // new scope
        retval = (pyr_lower == obj.pyr_lower);
        }
        break;
    case 12:
        {  // new scope
        retval = (pyr_upper == obj.pyr_upper);
        }
        break;
    case 13:
        {  // new scope
        retval = (Triangle == obj.Triangle);
        }
        break;
    case 14:
        {  // new scope
        retval = (tri_lower == obj.tri_lower);
        }
        break;
    case 15:
        {  // new scope
        retval = (tri_upper == obj.tri_upper);
        }
        break;
    case 16:
        {  // new scope
        retval = (Quad == obj.Quad);
        }
        break;
    case 17:
        {  // new scope
        retval = (quad_lower == obj.quad_lower);
        }
        break;
    case 18:
        {  // new scope
        retval = (quad_upper == obj.quad_upper);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

