// ************************************************************************* //
//  File: avtLineoutFilter.h
// ************************************************************************* //

#ifndef AVT_LINEOUT_FILTER_H
#define AVT_LINEOUT_FILTER_H


#include <avtPluginStreamer.h>
#include <LineoutAttributes.h>


class vtkDataSet;
class vtkIdList;
class vtkPoints;
class vtkPolyData;


// ****************************************************************************
//  Class: avtLineoutFilter
//
//  Purpose:
//      A plugin operator for Lineout.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Thu Apr 25 16:01:28 PST 2002
//
//  Modifications:
//
//    Hank Childs, Tue Sep 10 16:46:57 PDT 2002
//    Re-worked memory management paradigm.
//
//    Kathleen Bonnell, Tue Dec 23 10:18:06 PST 2003 
//    Added PerformRestriction. 
//
//    Kathleen Bonnell, Wed Jan 14 12:02:38 PST 2004 
//    Added PostExecute. 
//
//    Kathleen Bonnell, Thu Jul 29 09:55:49 PDT 2004 
//    Added Sampling, NoSampling, and CreatePolys methods.
//
//    Kathleen Bonnell, Wed Oct 20 17:35:10 PDT 2004 
//    Added arg to CreatePolys, added method CreatePolysFromOriginalCells, 
//    added var useOriginalCells. 
//
// ****************************************************************************

class avtLineoutFilter : public avtPluginStreamer
{
  public:
                             avtLineoutFilter();
    virtual                 ~avtLineoutFilter() {;};

    static avtFilter        *Create();

    virtual const char      *GetType(void)  
                             { return "avtLineoutFilter"; };
    virtual const char      *GetDescription(void)
                             { return "Lineout"; };

    virtual void              SetAtts(const AttributeGroup*);
    virtual bool              Equivalent(const AttributeGroup*);

  protected:
    LineoutAttributes         atts;

    virtual vtkDataSet       *ExecuteData(vtkDataSet *, int, std::string);
    virtual void              PostExecute(void);
    virtual void              VerifyInput(void);
    virtual void              RefashionDataObjectInfo(void);
    virtual avtPipelineSpecification_p
                              PerformRestriction(avtPipelineSpecification_p);

  private:
    bool                      useOriginalCells;
    vtkDataSet               *Sampling(vtkDataSet *, int);
    vtkDataSet               *NoSampling(vtkDataSet *, int);
    vtkPolyData              *CreatePolys(vtkDataSet *, float *, float *,
                                          vtkPoints *, vtkIdList *);
    vtkPolyData              *CreatePolysFromOrigCells(vtkDataSet *, float *, float *,
                                          vtkPoints *, vtkIdList *);
};

#endif
