// ************************************************************************* //
//  File: LineoutViewerPluginInfo.C
// ************************************************************************* //

#include <LineoutPluginInfo.h>
#include <LineoutAttributes.h>

#if defined(__APPLE__)
#define GetViewerInfo Makefile.in_GetViewerInfo
#endif

#if defined(__APPLE__)
#define GetViewerInfo Lineout_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Lineout operator.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:03:34 PST 2003
//
// ****************************************************************************
extern "C" ViewerOperatorPluginInfo* GetViewerInfo()
{
    LineoutViewerPluginInfo::InitializeGlobalObjects();
    return new LineoutViewerPluginInfo;
}

//
// Storage for static data elements.
//
LineoutAttributes *LineoutViewerPluginInfo::clientAtts = NULL;
LineoutAttributes *LineoutViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  LineoutViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:03:34 PST 2003
//
// ****************************************************************************
void
LineoutViewerPluginInfo::InitializeGlobalObjects()
{
    LineoutViewerPluginInfo::clientAtts  = new LineoutAttributes;
    LineoutViewerPluginInfo::defaultAtts = new LineoutAttributes;
}

// ****************************************************************************
//  Method: LineoutViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:03:34 PST 2003
//
// ****************************************************************************

AttributeSubject *
LineoutViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: LineoutViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:03:34 PST 2003
//
// ****************************************************************************

AttributeSubject *
LineoutViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: LineoutViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:03:34 PST 2003
//
// ****************************************************************************

void
LineoutViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(LineoutAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: LineoutViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:03:34 PST 2003
//
// ****************************************************************************

void
LineoutViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(LineoutAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: LineoutViewerPluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:03:34 PST 2003
//
// ****************************************************************************

void
LineoutViewerPluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const ViewerPlot *plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(LineoutAttributes*)atts = *defaultAtts;
    else
        *(LineoutAttributes*)atts = *clientAtts;
}

// ****************************************************************************
//  Method: LineoutViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:03:34 PST 2003
//
// ****************************************************************************

#include <Lineout.xpm>
const char **
LineoutViewerPluginInfo::XPMIconData() const
{
    return Lineout_xpm;
}
