// ************************************************************************* //
//                        LineoutScriptingPluginInfo.C
// ************************************************************************* //
#include <LineoutPluginInfo.h>
#include <PyLineoutAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo Makefile.in_GetScriptingInfo
#endif

#if defined(__APPLE__)
#define GetScriptingInfo Lineout_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the Lineout plot.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue May 7 13:13:46 PST 2002
//
// ****************************************************************************
extern "C" ScriptingOperatorPluginInfo* GetScriptingInfo()
{
    return new LineoutScriptingPluginInfo;
}

// ****************************************************************************
// Method: LineoutScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue May 7 13:13:46 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
LineoutScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyLineoutAttributes_StartUp((LineoutAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: LineoutScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue May 7 13:13:46 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void *
LineoutScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyLineoutAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: LineoutScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is Lineout plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue May 7 13:13:46 PST 2002
//
// Modifications:
//   
// ****************************************************************************

bool
LineoutScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyLineoutAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: LineoutScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue May 7 13:13:46 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
LineoutScriptingPluginInfo::SetLogging(bool val)
{
    PyLineoutAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: LineoutScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue May 7 13:13:46 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
LineoutScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyLineoutAttributes_SetDefaults((const LineoutAttributes *)atts);
}
