// ************************************************************************* //
//  File: LineoutPluginInfo.h
// ************************************************************************* //

#ifndef LINEOUT_PLUGIN_INFO_H
#define LINEOUT_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class LineoutAttributes;

// ****************************************************************************
//  Class: LineoutPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an Lineout operator
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:03:34 PST 2003
//
//  Modifications:
//
// ****************************************************************************

class LineoutGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
};

class LineoutCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual LineoutGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class LineoutGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual LineoutCommonPluginInfo
{
  public:
    virtual const char *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, QvisNotepadArea *notepad);
    virtual const char **XPMIconData() const;
};

class LineoutViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual LineoutCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const ViewerPlot *plot,
                                        const bool fromDefault);
    virtual const char **XPMIconData() const;
    virtual bool Removeable() const                { return false; }
    virtual bool Moveable() const                  { return false; }
    virtual bool AllowsSubsequentOperators() const { return false; }

    static void InitializeGlobalObjects();
  private:
    static LineoutAttributes *defaultAtts;
    static LineoutAttributes *clientAtts;
};

class LineoutEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual LineoutCommonPluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class LineoutScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual LineoutCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, FILE *log);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual void SetLogging(bool val);
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
