// ************************************************************************* //
//  File: LineoutGUIPluginInfo.C
// ************************************************************************* //

#include <LineoutPluginInfo.h>
#include <LineoutAttributes.h>
#include <QvisLineoutWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo Makefile.in_GetGUIInfo
#endif

#if defined(__APPLE__)
#define GetGUIInfo Lineout_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the Lineout operator.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 14:56:13 PST 2003
//
// ****************************************************************************
extern "C" GUIOperatorPluginInfo* GetGUIInfo()
{
    return new LineoutGUIPluginInfo;
}

// ****************************************************************************
//  Method: LineoutGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 14:56:13 PST 2003
//
// ****************************************************************************

const char *
LineoutGUIPluginInfo::GetMenuName() const
{
    return "Lineout";
}


// ****************************************************************************
//  Method: LineoutGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 14:56:13 PST 2003
//
// ****************************************************************************

QvisPostableWindowObserver *
LineoutGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisLineoutWindow(type, (LineoutAttributes *)attr,
        "Lineout operator attributes", "Lineout operator", notepad);
}

// ****************************************************************************
//  Method: LineoutGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 14:56:13 PST 2003
//
// ****************************************************************************

#include <Lineout.xpm>
const char **
LineoutGUIPluginInfo::XPMIconData() const
{
    return Lineout_xpm;
}
